/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.largeobject.BlobNewOutputStream;
import org.postgresql.util.LOGGER;
import org.postgresql.util.TraceLogger;

public class EsBlob
implements Blob {
    private byte[] _buf;
    private Blob blob;
    private long leng;
    private PgResultSet resultSet;
    private int _columnIndex;

    public EsBlob(byte[] b) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.leng = b.length;
        this._buf = new byte[(int)this.leng];
        System.arraycopy(b, 0, this._buf, 0, b.length);
    }

    public EsBlob(byte[] b, PgResultSet resultSet, int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (b != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = b.length;
            this._buf = new byte[(int)this.leng];
            System.arraycopy(b, 0, this._buf, 0, b.length);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = 0L;
            this._buf = new byte[(int)this.leng];
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.resultSet = resultSet;
        this._columnIndex = _columnIndex;
    }

    public EsBlob(Blob blob) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (blob == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Cannot instantiate a EsBlob object with a null Blob object");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.leng = blob.length();
        this._buf = blob.getBytes(1L, (int)this.leng);
        this.blob = blob;
    }

    @Override
    public byte[] getBytes(long position, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        if ((long)length > this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            length = (int)this.leng;
        }
        if (position < 1L || position > this.leng && this.leng > 0L || position > 1L && this.leng == 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid arguments: position cannot be less than 1 or greater than the length of the EsBlob");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] b = new byte[length];
        System.arraycopy(this._buf, (int)(--position), b, 0, length);
        return b;
    }

    @Override
    public long length() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        return this.leng;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        ByteArrayInputStream stream = new ByteArrayInputStream(this._buf);
        return stream;
    }

    @Override
    public long position(byte[] pat, long start) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        if (start < 1L || start > this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return -1L;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int position = (int)start - 1;
        int i = 0;
        long patleng = pat.length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while ((long)position < this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (pat[i] == this._buf[position]) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if ((long)(i + 1) == patleng) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return (long)(position + 1) - (patleng - 1L);
                }
                ++i;
                ++position;
                continue;
            }
            if (pat[i] == this._buf[position]) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++position;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return -1L;
    }

    @Override
    public long position(Blob pat, long start) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        return this.position(pat.getBytes(1L, (int)pat.length()), start);
    }

    @Override
    public int setBytes(long position, byte[] _bytes) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.WARNING)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.WARNING, "position:{0}, _bytes:{1}", position, _bytes);
        }
        return this.setBytes(position, _bytes, 0, _bytes.length);
    }

    @Override
    public int setBytes(long position, byte[] _bytes, int _offset, int length) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.WARNING)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.WARNING, "position:{0} _bytes:{1} _offset:{2} length:{3}", position, _bytes, _offset, length);
        }
        this.isValid();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_offset < 0 || _offset > _bytes.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid _offset in byte array set");
        }
        if (length < 0 || length > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid length in byte array set");
        }
        if (length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        if (position < 1L || position + (long)length - 1L > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position in BLOB object set");
        }
        int newleng = 0;
        if (position <= this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long remainleng = this.leng - position + 1L;
            if (remainleng < (long)length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newleng = (int)(this.leng + (long)length - remainleng);
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newleng = (int)(position + (long)length - 1L);
        }
        if ((long)newleng > this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = newleng;
            byte[] btemp = new byte[(int)this.leng];
            btemp = Arrays.copyOf(this._buf, (int)this.leng);
            this._buf = btemp;
        }
        int cpleng = 0;
        if (_offset + length > _bytes.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            cpleng = _bytes.length - (int)position;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            cpleng = length;
        }
        System.arraycopy(_bytes, _offset, this._buf, (int)(--position), cpleng);
        if (this.resultSet != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.resultSet.insertLob(this);
        }
        return length;
    }

    @Override
    public OutputStream setBinaryStream(long position) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.WARNING)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.WARNING, "position: {0}", position);
        }
        this.isValid();
        if (position < 1L || position > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position in BLOB object set");
        }
        return new BlobNewOutputStream(this, (int)position);
    }

    @Override
    public void truncate(long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        if (length > this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = length;
            byte[] btemp = new byte[(int)this.leng];
            btemp = Arrays.copyOf(this._buf, (int)this.leng);
            this._buf = btemp;
        } else if ((int)length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._buf = new byte[0];
            this.leng = length;
        } else {
            if (length == this.leng) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = length;
            this._buf = this.getBytes(1L, (int)this.leng);
        }
    }

    @Override
    public InputStream getBinaryStream(long position, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        if (position < 1L || position > this.leng && this.leng > 0L || position > 1L && this.leng == 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position in BLOB object set");
        }
        if (length < 0L || length > this.leng - position + 1L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("length is < 0 or position + length > total number of _bytes");
        }
        return new ByteArrayInputStream(this._buf, (int)position - 1, (int)length);
    }

    @Override
    public void free() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._buf != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._buf = null;
            if (this.blob != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.blob.free();
            }
            this.blob = null;
        }
    }

    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this == objt) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if (objt instanceof EsBlob) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            EsBlob sbu = (EsBlob)objt;
            if (this.leng == sbu.leng) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Arrays.equals(this._buf, sbu._buf);
            }
        }
        return false;
    }

    private void isValid() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._buf == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Error: You cannot call a mtd on a PgClob instance once free() has been called.");
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.setBinaryStream(1L);
    }

    public int getColumnIndex() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._columnIndex;
    }

    public void setColumnIndex(int _columnIndex) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._columnIndex = _columnIndex;
    }
}

