/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.security.Provider;
import java.security.Security;
import java.sql.SQLException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class SM3Digest {
    private SM3Digest() {
    }

    public static byte[] encode(byte[] user, byte[] password, byte[] salt) throws SQLException {
        byte[] hexDigest = new byte[67];
        try {
            Mac mac = Mac.getInstance("HMACSM3");
            SecretKeySpec key = new SecretKeySpec(user, "HMACSM3");
            mac.init(key);
            mac.update(password);
            byte[] tempDigest = mac.doFinal();
            SM3Digest.bytesToHex(tempDigest, hexDigest, 0);
            key = new SecretKeySpec(salt, "HMACSM3");
            mac.init(key);
            mac.update(hexDigest, 0, 64);
            byte[] passDigest = mac.doFinal();
            SM3Digest.bytesToHex(passDigest, hexDigest, 3);
            hexDigest[0] = 115;
            hexDigest[1] = 109;
            hexDigest[2] = 51;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to encode password with SM3", e);
        }
        return hexDigest;
    }

    private static void bytesToHex(byte[] bytes, byte[] hex, int offset) {
        char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int pos = offset;
        for (int i = 0; i < 32; ++i) {
            int c = bytes[i] & 0xFF;
            int j = c >> 4;
            hex[pos++] = (byte)lookup[j];
            j = c & 0xF;
            hex[pos++] = (byte)lookup[j];
        }
    }

    private static void initBouncyCastleProvider() throws PSQLException {
        String providerName = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        try {
            Provider provider = Security.getProvider("BC");
            if (provider == null) {
                Class<?> bouncyCastleProvider = Class.forName(providerName);
                provider = (Provider)bouncyCastleProvider.newInstance();
                Security.addProvider(provider);
            }
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("Could not found bouncyCastle provider, please load bcprov-jdk15on jar package manually!", new Object[0]), PSQLState.CONNECTION_REJECTED);
        }
    }

    static {
        try {
            SM3Digest.initBouncyCastleProvider();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

