/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PGInterval
extends PGobject
implements Serializable,
Cloneable {
    private int years;
    private int mons;
    private int days;
    private int hours;
    private int minutes;
    private int wholeSecs;
    private int microSeconds;

    public PGInterval() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("interval");
    }

    public PGInterval(String _value) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(_value);
    }

    private int lookForward(String _value, int position, String findStr) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char[] charArray = findStr.toCharArray();
        Integer foundIndex = -1;
        for (int k = 0; k < charArray.length; ++k) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            foundIndex = _value.indexOf(charArray[k], position);
            if (foundIndex <= 0) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return foundIndex;
        }
        return foundIndex;
    }

    public PGInterval(int years, int mons, int days, int hours, int minutes, double seconds) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(years, mons, days, hours, minutes, seconds);
    }

    private void parseISO8601Fmt(String _value) {
        int lookForward;
        int k;
        String dateValueStr;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int numberT = 0;
        String timeValueStr = null;
        int hasTimeIndex = _value.indexOf(84);
        if (hasTimeIndex > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dateValueStr = _value.substring(1, hasTimeIndex);
            timeValueStr = _value.substring(hasTimeIndex + 1);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dateValueStr = _value.substring(1);
        }
        for (k = 0; k < dateValueStr.length(); ++k) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            lookForward = this.lookForward(dateValueStr, k, "YMD");
            if (lookForward <= 0) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            numberT = Integer.parseInt(dateValueStr.substring(k, lookForward));
            if (dateValueStr.charAt(lookForward) == 'Y') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setYears(numberT);
            } else if (dateValueStr.charAt(lookForward) == 'M') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setMonths(numberT);
            } else if (dateValueStr.charAt(lookForward) == 'D') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setDays(numberT);
            }
            k = lookForward;
        }
        if (timeValueStr != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (k = 0; k < timeValueStr.length(); ++k) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                lookForward = this.lookForward(timeValueStr, k, "HMS");
                if (lookForward <= 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                numberT = Integer.parseInt(timeValueStr.substring(k, lookForward));
                if (timeValueStr.charAt(lookForward) == 'H') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setHours(numberT);
                } else if (timeValueStr.charAt(lookForward) == 'M') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setMinutes(numberT);
                } else if (timeValueStr.charAt(lookForward) == 'S') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setSeconds(numberT);
                }
                k = lookForward;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setValue(String valueStr) throws SQLException {
        block59: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ZERO = false;
            ZERO_DOUBLE = 0.0;
            v0 = PostgreSQLFormat = valueStr.startsWith("@") == false;
            if (valueStr.startsWith("P")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.parseISO8601Fmt(valueStr);
                return;
            }
            if (!PostgreSQLFormat && valueStr.length() == 3 && valueStr.charAt(2) == '0') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setValue(0, 0, 0, 0, 0, 0.0);
                return;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            secondsT = 0.0;
            daysT = 0;
            hoursT = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            monsT = 0;
            minutesT = 0;
            yearsT = 0;
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                valueTokenT = null;
                valueStr = valueStr.replace('+', ' ').replace('@', ' ');
                stringTokenizer = new StringTokenizer(valueStr);
                kbFormat = this.isKBFormat(valueStr);
                if (kbFormat) {
                    k = 1;
                    while (stringTokenizer.hasMoreTokens()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        tokenStr = stringTokenizer.nextToken();
                        if (k & true) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            endHoursT = tokenStr.indexOf(58);
                            if (endHoursT == -1) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                valueTokenT = tokenStr;
                            } else {
                                _offset = tokenStr.charAt(0) == '-' ? 1 : 0;
                                hoursT = PGInterval.nullSafeIntGet(tokenStr.substring(_offset + 0, endHoursT));
                                minutesT = PGInterval.nullSafeIntGet(tokenStr.substring(endHoursT + 1, endHoursT + 3));
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                endMinutes = tokenStr.indexOf(58, endHoursT + 1);
                                if (endMinutes != -1) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    secondsT = PGInterval.nullSafeDoubleGet(tokenStr.substring(endMinutes + 1));
                                }
                                if (_offset == 1) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    hoursT = -hoursT;
                                    minutesT = -minutesT;
                                    secondsT = -secondsT;
                                }
                                valueTokenT = null;
                            }
                        } else {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (tokenStr.startsWith("year")) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                yearsT = PGInterval.nullSafeIntGet(valueTokenT);
                            } else if (tokenStr.startsWith("mon")) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                monsT = PGInterval.nullSafeIntGet(valueTokenT);
                            } else if (tokenStr.startsWith("day")) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                daysT = PGInterval.nullSafeIntGet(valueTokenT);
                            } else if (tokenStr.startsWith("hour")) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                hoursT = PGInterval.nullSafeIntGet(valueTokenT);
                            } else if (tokenStr.startsWith("min")) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                minutesT = PGInterval.nullSafeIntGet(valueTokenT);
                            } else if (tokenStr.startsWith("sec")) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                secondsT = PGInterval.nullSafeDoubleGet(valueTokenT);
                            }
                        }
                        ++k;
                    }
                    break block59;
                }
                countTokens = stringTokenizer.countTokens();
                k = 1;
                while (stringTokenizer.hasMoreTokens()) {
                    block61: {
                        block60: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            tokenStr = stringTokenizer.nextToken();
                            if (k != true) break block60;
                            if (countTokens != 3) ** GOTO lbl102
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            splitYear = tokenStr.indexOf(45);
                            if (splitYear == -1) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                yearsT = PGInterval.nullSafeIntGet(tokenStr);
                            } else {
                                _offset = tokenStr.charAt(0) == '-' ? 1 : 0;
                                yearsT = PGInterval.nullSafeIntGet(tokenStr.substring(_offset + 0, splitYear));
                                monsT = PGInterval.nullSafeIntGet(tokenStr.substring(splitYear + 1));
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                if (_offset == 1) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    hoursT = -hoursT;
                                    monsT = -monsT;
                                }
lbl102:
                                // 4 sources

                                if (countTokens == 2) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    _offset = tokenStr.charAt(0) == '-' ? 1 : 0;
                                    daysT = PGInterval.nullSafeIntGet(tokenStr.substring(_offset + 0));
                                    if (_offset == 1) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        daysT = -daysT;
                                    }
                                }
                                if (countTokens == 1) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    _offset = tokenStr.charAt(0) == '-' ? 1 : 0;
                                    stringHourSecond = tokenStr.substring(_offset + 0);
                                    st = new StringTokenizer(stringHourSecond, ":");
                                    i = 1;
                                    while (st.hasMoreTokens()) {
                                        token = st.nextToken();
                                        if (i == 1) {
                                            hoursT = PGInterval.nullSafeIntGet(token);
                                        } else if (i == 2) {
                                            minutesT = PGInterval.nullSafeIntGet(token);
                                        } else if (i == 3) {
                                            secondsT = PGInterval.nullSafeDoubleGet(token);
                                        }
                                        ++i;
                                    }
                                    if (_offset == 1) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        hoursT = -hoursT;
                                        minutesT = -minutesT;
                                        secondsT = -secondsT;
                                    }
                                }
                            }
                            break block61;
                        }
                        if (k == 2) {
                            if (countTokens == 3) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                _offset = tokenStr.charAt(0) == '-' ? 1 : 0;
                                daysT = PGInterval.nullSafeIntGet(tokenStr.substring(_offset + 0));
                                if (_offset == 1) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    daysT = -daysT;
                                }
                            }
                            if (countTokens == 2) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                _offset = tokenStr.charAt(0) == '-' ? 1 : 0;
                                stringHourSecond = tokenStr.substring(_offset + 0);
                                st = new StringTokenizer(stringHourSecond, ":");
                                i = 1;
                                while (st.hasMoreTokens()) {
                                    token = st.nextToken();
                                    if (i == 1) {
                                        hoursT = PGInterval.nullSafeIntGet(token);
                                    } else if (i == 2) {
                                        minutesT = PGInterval.nullSafeIntGet(token);
                                    } else if (i == 3) {
                                        secondsT = PGInterval.nullSafeDoubleGet(token);
                                    }
                                    ++i;
                                }
                                if (_offset == 1) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    hoursT = -hoursT;
                                    minutesT = -minutesT;
                                    secondsT = -secondsT;
                                }
                            }
                        } else if (k == 3) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _offset = tokenStr.charAt(0) == '-' ? 1 : 0;
                            stringHourSecond = tokenStr.substring(_offset + 0);
                            st = new StringTokenizer(stringHourSecond, ":");
                            i = 1;
                            while (st.hasMoreTokens()) {
                                token = st.nextToken();
                                if (i == 1) {
                                    hoursT = PGInterval.nullSafeIntGet(token);
                                } else if (i == 2) {
                                    minutesT = PGInterval.nullSafeIntGet(token);
                                } else if (i == 3) {
                                    secondsT = PGInterval.nullSafeDoubleGet(token);
                                }
                                ++i;
                            }
                            if (_offset == 1) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                hoursT = -hoursT;
                                minutesT = -minutesT;
                                secondsT = -secondsT;
                            }
                        }
                    }
                    ++k;
                }
            }
            catch (NumberFormatException numberFormatException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new PSQLException(GT.tr("Con_version of kbInterval failed", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)numberFormatException);
            }
        }
        if (!PostgreSQLFormat && valueStr.endsWith("ago")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setValue(-yearsT, -monsT, -daysT, -hoursT, -minutesT, -secondsT);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setValue(yearsT, monsT, daysT, hoursT, minutesT, secondsT);
        }
    }

    private boolean isKBFormat(String s) {
        return s.indexOf("year") > -1 || s.indexOf("years") > -1 || s.indexOf("mon") > -1 || s.indexOf("mons") > -1 || s.indexOf("day") > -1 || s.indexOf("days") > -1 || s.indexOf("hour") > -1 || s.indexOf("hours") > -1 || s.indexOf("min") > -1 || s.indexOf("mins") > -1 || s.indexOf("sec") > -1 || s.indexOf("secs") > -1;
    }

    public void setValue(int yearsNum, int monsNum, int daysNum, int hoursNum, int minutesNum, double secondsNum) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setYearToDay(yearsNum, monsNum, daysNum);
        this.setHourToSecond(hoursNum, minutesNum, secondsNum);
    }

    private void setYearToDay(int yearsNum, int monsNum, int daysNum) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setDays(daysNum);
        this.setMonths(monsNum);
        this.setYears(yearsNum);
    }

    private void setHourToSecond(int hoursNum, int minutesNum, double secondsNum) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setSeconds(secondsNum);
        this.setMinutes(minutesNum);
        this.setHours(hoursNum);
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.years + " years " + this.mons + " mons " + this.days + " days " + this.hours + " hours " + this.minutes + " mins " + this.wholeSecs + '.' + this.microSeconds + " secs";
    }

    public int getYears() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.years;
    }

    public void setYears(int years) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.years = years;
    }

    public int getMonths() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.mons;
    }

    public void setMonths(int mons) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.mons = mons;
    }

    public int getDays() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.days;
    }

    public void setDays(int days) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.days = days;
    }

    public int getHours() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.hours;
    }

    public void setHours(int hours) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.hours = hours;
    }

    public int getMinutes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.minutes = minutes;
    }

    public double getSeconds() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.microSeconds < 0) {
            if (this.wholeSecs == 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Double.parseDouble("-0." + -this.microSeconds);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Double.parseDouble("" + this.wholeSecs + '.' + -this.microSeconds);
        }
        return Double.parseDouble("" + this.wholeSecs + '.' + this.microSeconds);
    }

    public int getWholeSeconds() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.wholeSecs;
    }

    public int getMicroSeconds() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.microSeconds;
    }

    public void setSeconds(double seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String ss = Double.toString(seconds);
        int decimal = ss.indexOf(46);
        if (decimal > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String micSeconds = ss.substring(decimal + 1);
            int power = 6 - micSeconds.length();
            this.microSeconds = Integer.parseInt(micSeconds) * (int)Math.pow(10.0, power);
            this.wholeSecs = Integer.parseInt(ss.substring(0, decimal));
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.microSeconds = 0;
            this.wholeSecs = Integer.parseInt(ss);
        }
        if (seconds < 0.0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.microSeconds = -this.microSeconds;
        }
    }

    public void add(Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int millisecs = (this.microSeconds + (this.microSeconds < 0 ? -500 : 500)) / 1000 + this.wholeSecs * 1000;
        calendar.add(14, millisecs);
        calendar.add(12, this.getMinutes());
        calendar.add(10, this.getHours());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendar.add(5, this.getDays());
        calendar.add(2, this.getMonths());
        calendar.add(1, this.getYears());
    }

    public void add(Date date) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.add(calendar);
        date.setTime(calendar.getTime().getTime());
    }

    public void add(PGInterval kbInterval) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        kbInterval.setYears(kbInterval.getYears() + this.getYears());
        kbInterval.setMonths(kbInterval.getMonths() + this.getMonths());
        kbInterval.setDays(kbInterval.getDays() + this.getDays());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        kbInterval.setHours(kbInterval.getHours() + this.getHours());
        kbInterval.setMinutes(kbInterval.getMinutes() + this.getMinutes());
        kbInterval.setSeconds(kbInterval.getSeconds() + this.getSeconds());
    }

    public void scale(int fac) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setYears(fac * this.getYears());
        this.setMonths(fac * this.getMonths());
        this.setDays(fac * this.getDays());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setHours(fac * this.getHours());
        this.setMinutes(fac * this.getMinutes());
        this.setSeconds((double)fac * this.getSeconds());
    }

    private static int nullSafeIntGet(String _value) throws NumberFormatException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _value == null ? 0 : Integer.parseInt(_value);
    }

    private static double nullSafeDoubleGet(String _value) throws NumberFormatException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _value == null ? 0.0 : Double.parseDouble(_value);
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (objt == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (objt == this) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if (!(objt instanceof PGInterval)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        PGInterval pgi = (PGInterval)objt;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return pgi.years == this.years && pgi.mons == this.mons && pgi.days == this.days && pgi.hours == this.hours && pgi.minutes == this.minutes && pgi.wholeSecs == this.wholeSecs && pgi.microSeconds == this.microSeconds;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (((((((248 + this.microSeconds) * 31 + this.wholeSecs) * 31 + this.minutes) * 31 + this.hours) * 31 + this.days) * 31 + this.mons) * 31 + this.years) * 31;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return super.clone();
    }
}

