/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.net.SocketFactory;
import org.postgresql.PGProperty;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.PGStream;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.SetupQueryRunner;
import org.postgresql.core.SocketFactoryFactory;
import org.postgresql.core.Utils;
import org.postgresql.core.Version;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.gss.MakeGSS;
import org.postgresql.hostchooser.CandidateHost;
import org.postgresql.hostchooser.GlobalHostStatusTracker;
import org.postgresql.hostchooser.HostChooser;
import org.postgresql.hostchooser.HostChooserFactory;
import org.postgresql.hostchooser.HostRequirement;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.jdbc.SslMode;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.sspi.ISSPIClient;
import org.postgresql.ukpwd.CertAuthenticator;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.LOGGER;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.SM3Digest;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.TraceLogger;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final boolean TRUE = true;
    private static final int AUTH_REQ_OK_T = 0;
    private static final int AUTH_REQ_KRB4_T = 1;
    private static final int AUTH_REQ_KRB5_T = 2;
    private static final int AUTH_REQ_PASSWORD_T = 3;
    private static final int AUTH_REQ_CRYPT_T = 4;
    private static final int AUTH_REQ_MD5_T = 5;
    private static final int AUTH_REQ_SCM_T = 6;
    private static final int AUTH_REQ_GSS_T = 7;
    private static final int AUTH_REQ_GSS_CONTINUE_T = 8;
    private static final int AUTH_REQ_SSPI_T = 9;
    private static final int AUTH_REQ_SASL_T = 10;
    private static final int AUTH_REQ_SASL_CONTINUE_T = 11;
    private static final int AUTH_REQ_SASL_FINAL_T = 12;
    private static final int AUTH_REQ_SM3_T = 13;
    private static final int AUTH_REQ_KCERT_T = 14;

    private ISSPIClient createSSPI(PGStream pgStream, String spnServiceClass, boolean enableNegotiate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Class<?> clientClass = Class.forName("org.postgresql.sspi.SSPIClient");
            return (ISSPIClient)clientClass.getDeclaredConstructor(PGStream.class, String.class, Boolean.TYPE).newInstance(pgStream, spnServiceClass, enableNegotiate);
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Unable to load org.postgresql.sspi.SSPIClient. Please check that SSPIClient is included in your pgjdbc distribution.", exception);
        }
    }

    private PGStream tryConnect(String user, String database, Properties infoProps, SocketFactory socketFactory, HostSpec _hostSpec, SslMode sslMode, int _version, Object cCMV2) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int connectTimeoutT = PGProperty.CONNECT_TIMEOUT.getInt(infoProps) * 1000;
        PGStream newStreamT = new PGStream(socketFactory, _hostSpec, connectTimeoutT, PGProperty.USEDISPATCH.getBoolean(infoProps) && infoProps.getProperty("isMonitor") == null, _version, cCMV2);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int socketTimeoutT = PGProperty.SOCKET_TIMEOUT.getInt(infoProps);
        if (PGProperty.USEDISPATCH.getBoolean(infoProps) && infoProps.getProperty("isMonitor") == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (socketTimeoutT < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                socketTimeoutT = 0;
            }
            newStreamT.getSocket().setSoTimeout(1000);
            newStreamT.setSocketTimeout(socketTimeoutT);
            LOGGER.log(Level.INFO, "Dispatch : socketTimeout is " + socketTimeoutT * 1000, new Object[0]);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (socketTimeoutT > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newStreamT.getSocket().setSoTimeout(socketTimeoutT * 1000);
                LOGGER.log(Level.INFO, "Single or Monitor : socketTimeout is " + socketTimeoutT * 1000, new Object[0]);
            }
        }
        boolean requireTCPKeepAliveT = PGProperty.TCP_KEEP_ALIVE.getBoolean(infoProps);
        newStreamT.getSocket().setKeepAlive(requireTCPKeepAliveT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int receiveBufferSizeT = PGProperty.RECEIVE_BUFFER_SIZE.getInt(infoProps);
        if (receiveBufferSizeT > -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (receiveBufferSizeT > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newStreamT.getSocket().setReceiveBufferSize(receiveBufferSizeT);
            } else {
                LOGGER.log(Level.WARNING, "Ignore invalid _value for receiveBufferSize: {0}", receiveBufferSizeT);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sendBufferSize = PGProperty.SEND_BUFFER_SIZE.getInt(infoProps);
        if (sendBufferSize > -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (sendBufferSize > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newStreamT.getSocket().setSendBufferSize(sendBufferSize);
            } else {
                LOGGER.log(Level.WARNING, "Ignore invalid _value for sendBufferSize: {0}", sendBufferSize);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINE, "Receive Buffer Size is {0}", newStreamT.getSocket().getReceiveBufferSize());
            LOGGER.log(Level.FINE, "Send Buffer Size is {0}", newStreamT.getSocket().getSendBufferSize());
        }
        newStreamT = this.enableSSL(newStreamT, sslMode, infoProps, connectTimeoutT, _version, cCMV2);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        List<String[]> _paramList = this.getParametersForStartup(user, database, infoProps);
        String client_encoding = PGProperty.CLIENT_ENCODING.get(infoProps);
        newStreamT.setEncoding(Encoding.getJVMEncoding(client_encoding));
        this.sendStartupPacket(newStreamT, _paramList, client_encoding);
        newStreamT.setZipLevel(PGProperty.ZIP_LEVEL.getInt(infoProps));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.doAuthentication(newStreamT, _hostSpec.getHost(), user, infoProps);
        return newStreamT;
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecsT, String user, String database, Properties infoProps, int _version, Object cCMV2) throws SQLException {
        HostRequirement targetServerTypeT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SslMode sslMode = SslMode.of(infoProps);
        String targetServerTypeStrT = PGProperty.TARGET_SERVER_TYPE.get(infoProps);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            targetServerTypeT = HostRequirement.getTargetServerType(targetServerTypeStrT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Invalid targetServerType _value: {0}", targetServerTypeStrT), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SocketFactory socketFactoryT = SocketFactoryFactory.getSocketFactory(infoProps);
        HostChooser hostChooserT = HostChooserFactory.createHostChooser(hostSpecsT, targetServerTypeT, infoProps);
        Iterator<CandidateHost> hostIterT = hostChooserT.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (hostIterT.hasNext()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            CandidateHost candidateHostT = hostIterT.next();
            HostSpec hostSpecT = candidateHostT._hostSpec;
            LOGGER.log(Level.FINE, "Trying to establish a protocol _version 3 _connection to {0}", hostSpecT);
            HostStatus knownStatusT = (HostStatus)((Object)knownStates.get(hostSpecT));
            if (knownStatusT != null && !candidateHostT.targetServerType.allowConnectingTo(knownStatusT)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Known status of _host {0} is {1}, and required status was {2}. Will try next _host", new Object[]{hostSpecT, knownStatusT, candidateHostT.targetServerType});
                continue;
            }
            PGStream newStreamT = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                try {
                    newStreamT = this.tryConnect(user, database, infoProps, socketFactoryT, hostSpecT, sslMode, _version, cCMV2);
                }
                catch (SQLException sqlException1) {
                    Exception throwable;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (sslMode == SslMode.PREFER && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(sqlException1.getSQLState())) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throwable = null;
                        try {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            newStreamT = this.tryConnect(user, database, infoProps, socketFactoryT, hostSpecT, SslMode.DISABLE, _version, cCMV2);
                            LOGGER.log(Level.FINE, "Downgraded to non-encrypted _connection for _host {0}", hostSpecT);
                        }
                        catch (SQLException sqlException2) {
                            throwable = sqlException2;
                        }
                        catch (IOException ioException) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            throwable = ioException;
                        }
                        if (throwable != null) {
                            LOGGER.log(Level.FINE, "sslMode==PREFER, however non-SSL _connection failed as well", throwable);
                            throw sqlException1;
                        }
                    }
                    if (sslMode == SslMode.ALLOW && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(sqlException1.getSQLState())) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throwable = null;
                        try {
                            newStreamT = this.tryConnect(user, database, infoProps, socketFactoryT, hostSpecT, SslMode.REQUIRE, _version, cCMV2);
                            LOGGER.log(Level.FINE, "Upgraded to encrypted _connection for _host {0}", hostSpecT);
                        }
                        catch (SQLException ee) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            throwable = ee;
                        }
                        catch (IOException ee) {
                            throwable = ee;
                        }
                        if (throwable != null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            LOGGER.log(Level.FINE, "sslMode==ALLOW, however SSL _connection failed as well", throwable);
                            throw sqlException1;
                        }
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw sqlException1;
                }
                int cancelSignalTimeoutT = PGProperty.CANCEL_SIGNAL_TIMEOUT.getInt(infoProps) * 1000;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                QueryExecutorImpl queryExecutorImpl = new QueryExecutorImpl(newStreamT, user, database, cancelSignalTimeoutT, infoProps);
                HostStatus _hostStatus = HostStatus.ConnectOK;
                if (candidateHostT.targetServerType != HostRequirement.any) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _hostStatus = this.isMaster(queryExecutorImpl) ? HostStatus.Master : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, _hostStatus);
                knownStates.put(hostSpecT, _hostStatus);
                if (!candidateHostT.targetServerType.allowConnectingTo(_hostStatus)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    queryExecutorImpl.close();
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, HostStatus.First);
                knownStates.put(hostSpecT, HostStatus.First);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.runInitialQueries(queryExecutorImpl, infoProps);
                return queryExecutorImpl;
            }
            catch (ConnectException cex) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, HostStatus.ConnectFail);
                knownStates.put(hostSpecT, HostStatus.ConnectFail);
                if (hostIterT.hasNext()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    LOGGER.log(Level.FINE, "ConnectException occurred while _connecting to {0}", hostSpecT);
                    LOGGER.log(Level.FINE, cex);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new PSQLException(GT.tr("Connection to {0} refused. Check that the _hostname and port are correct and that the postmaster is accepting TCP/IP _connections.", hostSpecT), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.closeStream(newStreamT);
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, HostStatus.ConnectFail);
                knownStates.put(hostSpecT, HostStatus.ConnectFail);
                if (hostIterT.hasNext()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    LOGGER.log(Level.FINE, "IOException occurred while _connecting to {0}", hostSpecT);
                    LOGGER.log(Level.FINE, ioe);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new PSQLException(GT.tr("The _connection attempt failed.Reason:" + ioe.getMessage(), new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.closeStream(newStreamT);
                GlobalHostStatusTracker.reportHostStatus(hostSpecT, HostStatus.ConnectFail);
                knownStates.put(hostSpecT, HostStatus.ConnectFail);
                if (hostIterT.hasNext()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    LOGGER.log(Level.FINE, "SQLException occurred while _connecting to {0}", hostSpecT);
                    LOGGER.log(Level.FINE, se);
                    continue;
                }
                throw se;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerTypeT}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<String[]> getParametersForStartup(String user, String database, Properties info) throws PSQLException {
        int zipLevel;
        String options;
        String currentSchema;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String client_encoding = PGProperty.CLIENT_ENCODING.get(info);
        if (client_encoding == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            client_encoding = System.getProperty("file.encoding");
            PGProperty.CLIENT_ENCODING.set(info, client_encoding);
            LOGGER.log(Level.FINE, "Use current JVM default _encoding {0}", client_encoding);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<String[]> _paramList = new ArrayList<String[]>();
        _paramList.add(new String[]{"user", user});
        _paramList.add(new String[]{"database", database});
        _paramList.add(new String[]{"client_encoding", client_encoding});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _paramList.add(new String[]{"DateStyle", "ISO"});
        _paramList.add(new String[]{"TimeZone", ConnectionFactoryImpl.createPostgreSQLTimeZone()});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Version assumeVersion = ServerVersion.from(PGProperty.ASSUME_MIN_SERVER_VERSION.get(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            _paramList.add(new String[]{"extra_float_digits", "3"});
            String appName = PGProperty.APPLICATION_NAME.get(info);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (appName != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _paramList.add(new String[]{"application_name", appName});
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"extra_float_digits", "2"});
        }
        String replication = PGProperty.REPLICATION.get(info);
        if (replication != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"replication", replication});
        }
        if ((currentSchema = PGProperty.CURRENT_SCHEMA.get(info)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"search_path", currentSchema});
        }
        if ((options = PGProperty.OPTIONS.get(info)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"options", options});
        }
        if ((zipLevel = PGProperty.ZIP_LEVEL.getInt(info)) < 0 || zipLevel >= 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("ZipLevel must be a integer _value greater to or equal to 0 and less to or equal to 9.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (zipLevel != 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _paramList.add(new String[]{"comm_compress", "" + zipLevel});
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _paramList;
    }

    private static String createPostgreSQLTimeZone() {
        String startT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String timezoneStr = TimeZone.getDefault().getID();
        if (timezoneStr.length() <= 3 || !timezoneStr.startsWith("GMT")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return timezoneStr;
        }
        char signT = timezoneStr.charAt(3);
        switch (signT) {
            case '-': {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = "GMT+";
                break;
            }
            case '+': {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = "GMT-";
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return timezoneStr;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return startT + timezoneStr.substring(4);
    }

    private PGStream enableSSL(PGStream pgStream, SslMode sslMode, Properties info, int connectTimeout, int _version, Object cCMV2) throws IOException, PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sslMode == SslMode.DISABLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return pgStream;
        }
        if (sslMode == SslMode.ALLOW) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return pgStream;
        }
        LOGGER.log(Level.FINEST, " FE=> SSLRequest", new Object[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5679);
        pgStream.flush();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int beresp = pgStream.receiveChar();
        switch (beresp) {
            case 69: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                LOGGER.log(Level.FINEST, " <=BE SSLError", new Object[0]);
                if (sslMode.requireEncryption()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new PGStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout, PGProperty.USEDISPATCH.getBoolean(info), _version, cCMV2);
            }
            case 78: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                LOGGER.log(Level.FINEST, " <=BE SSLRefused", new Object[0]);
                if (sslMode.requireEncryption()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                LOGGER.log(Level.FINEST, " <=BE SSLOk", new Object[0]);
                MakeSSL.convert(pgStream, info);
                return pgStream;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("An _error occurred while setting up the SSL _connection.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(PGStream pgStream, List<String[]> _params, String _encoding) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < _params.size(); ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i != 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    details.append(", ");
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                details.append(_params.get(i)[0]);
                details.append("=");
                details.append(_params.get(i)[1]);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINEST, " FE=> StartupPacket({0})", details);
        }
        int length = 8;
        byte[][] _encodedParams = new byte[_params.size() * 2][];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < _params.size(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _encodedParams[i * 2] = _params.get(i)[0].getBytes(_encoding);
            _encodedParams[i * 2 + 1] = _params.get(i)[1].getBytes(_encoding);
            length += _encodedParams[i * 2].length + 1 + _encodedParams[i * 2 + 1].length + 1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        pgStream.sendInteger4(++length);
        pgStream.sendInteger2(3);
        pgStream.sendInteger2(0);
        for (byte[] _encodedParam : _encodedParams) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            pgStream.send(_encodedParam);
            pgStream.sendChar(0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        pgStream.sendChar(0);
        pgStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAuthentication(PGStream pgStream, String _host, String user, Properties info) throws IOException, SQLException {
        ISSPIClient sspiClient;
        block36: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String password = PGProperty.PASSWORD.get(info);
            String client_encoding = PGProperty.CLIENT_ENCODING.get(info);
            sspiClient = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                while (true) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int berespT = pgStream.receiveChar();
                    block3 : switch (berespT) {
                        case 69: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            int eleng = pgStream.receiveInteger4();
                            ServerErrorMessage _errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(eleng - 4), null);
                            LOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", _errorMsg);
                            throw new PSQLException(_errorMsg, PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                        }
                        case 82: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            int msgLen = pgStream.receiveInteger4();
                            int areq = pgStream.receiveInteger4();
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            switch (areq) {
                                case 5: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    byte[] md5Salt = pgStream.receive(4);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqMD5(salt={0})", Utils.toHexString(md5Salt));
                                    }
                                    if (password == null) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    byte[] digest = MD5Digest.encode(user.getBytes(client_encoding), password.getBytes(client_encoding), md5Salt);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        LOGGER.log(Level.FINEST, " FE=> Password(md5digest={0})", new String(digest, "US-ASCII"));
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    pgStream.sendChar(112);
                                    pgStream.sendInteger4(4 + digest.length + 1);
                                    pgStream.send(digest);
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    break block3;
                                }
                                case 3: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    LOGGER.log(Level.FINEST, "<=BE AuthenticationReqPassword", new Object[0]);
                                    LOGGER.log(Level.FINEST, " FE=> Password(password=<not shown>)", new Object[0]);
                                    if (password == null) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] _encodedPassword = password.getBytes(client_encoding);
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    pgStream.sendChar(112);
                                    pgStream.sendInteger4(4 + _encodedPassword.length + 1);
                                    pgStream.send(_encodedPassword);
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    break block3;
                                }
                                case 7: 
                                case 9: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    String gsslib = PGProperty.GSS_LIB.get(info);
                                    boolean usespnego = PGProperty.USE_SPNEGO.getBoolean(info);
                                    boolean useSSPIT = false;
                                    if (gsslib.equals("gssapi")) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, _param gsslib=gssapi", new Object[0]);
                                    } else if (areq == 7 && !gsslib.equals("sspi")) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced", new Object[0]);
                                    } else {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        sspiClient = this.createSSPI(pgStream, PGProperty.SSPI_SERVICE_CLASS.get(info), areq == 9 || areq == 7 && usespnego);
                                        useSSPIT = sspiClient.isSSPISupported();
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        LOGGER.log(Level.FINE, "SSPI support detected: {0}", useSSPIT);
                                        if (!useSSPIT) {
                                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                            sspiClient = null;
                                            if (gsslib.equals("sspi")) {
                                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                                throw new PSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                            }
                                        }
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Using SSPI: {0}, gsslib={1} and SSPI support detected", useSSPIT, gsslib);
                                        }
                                    }
                                    if (useSSPIT) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        sspiClient.startSSPI();
                                        break block3;
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    MakeGSS.authenticate(pgStream, _host, user, password, PGProperty.JAAS_APPLICATION_NAME.get(info), PGProperty.KERBEROS_SERVER_NAME.get(info), usespnego, PGProperty.JAAS_LOGIN.getBoolean(info), PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                                    break block3;
                                }
                                case 8: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    sspiClient.continueSSPI(msgLen - 8);
                                    break block3;
                                }
                                case 10: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationSASL", new Object[0]);
                                    throw new PSQLException(GT.tr("SCRAM authentication is not supported by this driver. You need JDK >= 8 and pgjdbc >= 42.2.0 (not \".jre\" _versions)", areq), PSQLState.CONNECTION_REJECTED);
                                }
                                case 13: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    byte[] sm3Salt = pgStream.receive(4);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqSM3(salt={0})", Utils.toHexString(sm3Salt));
                                    }
                                    if (password == null) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] digest = SM3Digest.encode(user.getBytes(client_encoding), password.getBytes(client_encoding), sm3Salt);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        LOGGER.log(Level.FINEST, " FE=> Password(sm3digest={0})", new String(digest, "US-ASCII"));
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    pgStream.sendChar(112);
                                    pgStream.sendInteger4(4 + digest.length + 1);
                                    pgStream.send(digest);
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    break block3;
                                }
                                case 0: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationOk", new Object[0]);
                                    break block36;
                                }
                                case 14: {
                                    CertAuthenticator certAuthenticator = new CertAuthenticator(pgStream, info);
                                    certAuthenticator.sendCertAndSign(msgLen - 4 - 4);
                                    break block3;
                                }
                                default: {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationReq (unsupported type {0})", areq);
                                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), PSQLState.CONNECTION_REJECTED);
                                }
                            }
                        }
                        default: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            throw new PSQLException(GT.tr("Protocol _error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (sspiClient == null) throw throwable;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    sspiClient.dispose();
                    throw throwable;
                }
                catch (RuntimeException ex) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    LOGGER.log(Level.FINE, "Unexpected _error during SSPI context dispositional", ex);
                }
                throw throwable;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sspiClient == null) return;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            sspiClient.dispose();
            return;
        }
        catch (RuntimeException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINE, "Unexpected _error during SSPI context dispositional", ex);
            return;
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutorImpl, Properties info) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String initParams = PGProperty.INIT_PARAMS.get(info);
        if (initParams != null) {
            String[] _params;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (String _param : _params = initParams.split(";")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    SetupQueryRunner.run(queryExecutorImpl, "SET " + _param, false);
                }
                catch (SQLException sqlException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw sqlException;
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String assumeMinServerVersion = PGProperty.ASSUME_MIN_SERVER_VERSION.get(info);
        if (Utils.parseServerVersionStr(assumeMinServerVersion) >= ServerVersion.v9_0.getVersionNum()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        int dbVersion = queryExecutorImpl.getServerVersionNum();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SetupQueryRunner.run(queryExecutorImpl, "SET extra_float_digits = 3", false);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String appName = PGProperty.APPLICATION_NAME.get(info);
        if (appName != null && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder _sql = new StringBuilder();
            _sql.append("SET application_name = '");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Utils.escapeLiteral(_sql, appName, queryExecutorImpl.getStandardConformingStrings());
            _sql.append("'");
            SetupQueryRunner.run(queryExecutorImpl, _sql.toString(), false);
        }
    }

    private boolean isMaster(QueryExecutor queryExecutorImpl) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[][] _results = SetupQueryRunner.run(queryExecutorImpl, "show transaction_read_only", true);
        String _value = queryExecutorImpl.getEncoding().decode(_results[0]);
        return _value.equalsIgnoreCase("off");
    }
}

