/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.provider;

import android.content.Context;
import androidx.annotation.NonNull;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.WellKnownTileServer;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import dji.v5.ux.mapkit.core.Mapkit;
import dji.v5.ux.mapkit.core.MapkitOptions;
import dji.v5.ux.mapkit.core.maps.DJIMapViewInternal;
import dji.v5.ux.mapkit.core.places.IInternalPlacesClient;
import dji.v5.ux.mapkit.core.providers.MapProvider;
import dji.v5.ux.mapkit.maplibre.map.MaplibreMapView;
import dji.v5.ux.mapkit.maplibre.place.MaplibrePlaceDelegate;

public class MaplibreProvider
extends MapProvider {
    public MaplibreProvider() {
        this.providerType = 3;
    }

    @Override
    protected DJIMapViewInternal requestMapView(@NonNull Context context, @NonNull MapkitOptions mapkitOptions) {
        MaplibreMapView mapView = null;
        int mapType = mapkitOptions.getMapType();
        Mapkit.mapType(mapType);
        Mapkit.mapProvider(this.providerType);
        Mapbox.getInstance((Context)context.getApplicationContext(), (String)Mapkit.getMapboxAccessToken(), (WellKnownTileServer)WellKnownTileServer.Mapbox);
        MapboxMapOptions options = MapboxMapOptions.createFromAttributes((Context)context);
        options.textureMode(true);
        options.attributionGravity(85);
        options.logoGravity(85);
        options.logoMargins(new int[]{0, 0, 75, 12});
        mapView = new MaplibreMapView(context, options);
        return mapView;
    }

    @Override
    protected IInternalPlacesClient requestGeocodingClient(Context context, MapkitOptions mapkitOptions) {
        MaplibrePlaceDelegate client = null;
        Mapkit.geocodingProvider(this.getProviderType());
        client = new MaplibrePlaceDelegate();
        return client;
    }
}

