/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.maps;

import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.ux.mapkit.core.callback.MapScreenShotListener;
import dji.v5.ux.mapkit.core.callback.OnCameraChangeListener;
import dji.v5.ux.mapkit.core.callback.OnMapTypeLoadedListener;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.maps.DJIProjection;
import dji.v5.ux.mapkit.core.maps.DJIUiSettings;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircle;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygon;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;

public interface DJIMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_NIGHT = 3;
    public static final int MAP_TYPE_HYBRID = 4;

    public DJIMarker addMarker(DJIMarkerOptions var1);

    public Object getMap();

    public void animateCamera(DJICameraUpdate var1);

    public void setOnCameraChangeListener(OnCameraChangeListener var1);

    public void removeAllOnCameraChangeListeners();

    public DJICameraPosition getCameraPosition();

    public void moveCamera(DJICameraUpdate var1);

    public void setInfoWindowAdapter(InfoWindowAdapter var1);

    public void setMapType(MapType var1);

    public void setMapType(MapType var1, OnMapTypeLoadedListener var2);

    public void setMapType(int var1);

    public DJIPolyline addPolyline(DJIPolylineOptions var1);

    @Nullable
    public DJIPolygon addPolygon(DJIPolygonOptions var1);

    @Nullable
    public DJICircle addSingleCircle(DJICircleOptions var1);

    @Nullable
    public DJICircle addMarkerCircle(DJICircleOptions var1);

    @Nullable
    public DJIGroupCircle addGroupCircle(DJIGroupCircleOptions var1);

    public DJIUiSettings getUiSettings();

    public void removeOnCameraChangeListener(OnCameraChangeListener var1);

    public void removeOnMarkerClickListener(OnMarkerClickListener var1);

    public void removeAllOnMarkerClickListener();

    public void setOnInfoWindowClickListener(OnInfoWindowClickListener var1);

    public void setOnMarkerClickListener(OnMarkerClickListener var1);

    public void setOnMapClickListener(OnMapClickListener var1);

    public void removeOnMapClickListener(OnMapClickListener var1);

    public void setOnMapLongClickListener(OnMapLongClickListener var1);

    public void removeAllOnMapClickListener();

    public void removeOnMapLongClickListener(OnMapLongClickListener var1);

    public void removeAllOnMapLongClickListener();

    public void setOnMarkerDragListener(OnMarkerDragListener var1);

    public void removeOnMarkerDragListener(OnMarkerDragListener var1);

    public void removeAllOnMarkerDragListener();

    public void snapshot(MapScreenShotListener var1);

    public DJIProjection getProjection();

    public void clear();

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(DJIMarker var1);

        public void onMarkerDrag(DJIMarker var1);

        public void onMarkerDragEnd(DJIMarker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(DJILatLng var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(DJIMarker var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(DJILatLng var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(DJIMarker var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(DJIMarker var1);

        public View getInfoContents(DJIMarker var1);
    }

    public static enum MapType {
        NORMAL(1),
        SATELLITE(2),
        HYBRID(4);

        int value;
        private static MapType[] mValues;

        private MapType(int value) {
            this.value = value;
        }

        public static MapType[] getValues() {
            if (mValues == null) {
                mValues = MapType.values();
            }
            return mValues;
        }

        @NonNull
        public static MapType find(@IntRange(from=1L, to=4L) int index) {
            for (MapType mapProvider : MapType.getValues()) {
                if (mapProvider.getValue() != index) continue;
                return mapProvider;
            }
            return NORMAL;
        }

        public int getValue() {
            return this.value;
        }
    }
}

