/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.takeoff;

import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightAssistantKey;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.value.flightassistant.LandingProtectionState;
import dji.sdk.keyvalue.value.flightcontroller.FCAutoRTHReason;
import dji.sdk.keyvalue.value.flightcontroller.FCFlightMode;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.sdk.keyvalue.value.remotecontroller.RCMode;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002ABB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203J\u0006\u00105\u001a\u000203J\u0006\u00106\u001a\u000203J\u0006\u00107\u001a\u000203J\b\u00108\u001a\u000209H\u0014J\b\u0010:\u001a\u000209H\u0014J\b\u0010;\u001a\u000209H\u0014J\b\u0010<\u001a\u000209H\u0002J\b\u0010=\u001a\u00020\fH\u0002J\u0010\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020@H\u0002J\b\u00101\u001a\u00020@H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0&8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010(R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0011\u00100\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010-\u00a8\u0006C"}, d2={"Ldji/v5/ux/flight/takeoff/TakeOffWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "preferencesManager", "Ldji/v5/ux/core/communication/GlobalPreferencesInterface;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/communication/GlobalPreferencesInterface;)V", "isFlyingDataProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "isAutoLandingDataProcessor", "isLandingConfNeededDataProcessor", "forceLandingHeightDataProcessor", "", "areMotorsOnDataProcessor", "isGoingHomeDataProcessor", "flightModeStringDataProcessor", "", "isCancelAutoLandingDisabledProcessor", "autoRTHReasonProcessor", "Ldji/sdk/keyvalue/value/flightcontroller/FCAutoRTHReason;", "rcModeDataProcessor", "Ldji/sdk/keyvalue/value/remotecontroller/RCMode;", "productModelProcessor", "Ldji/sdk/keyvalue/value/product/ProductType;", "unitTypeProcessor", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "landingProtectionStateDataProcessor", "Ldji/sdk/keyvalue/value/flightassistant/LandingProtectionState;", "flightModeProcessor", "Ldji/sdk/keyvalue/value/flightcontroller/FCFlightMode;", "takeOffLandingStateDataProcessor", "Ldji/v5/ux/flight/takeoff/TakeOffWidgetModel$TakeOffLandingState;", "isInAttiModeDataProcessor", "takeOffLandingState", "Lio/reactivex/rxjava3/core/Flowable;", "getTakeOffLandingState", "()Lio/reactivex/rxjava3/core/Flowable;", "isInAttiMode", "takeOffHeight", "Ldji/v5/ux/flight/takeoff/TakeOffWidgetModel$Height;", "getTakeOffHeight", "()Ldji/v5/ux/flight/takeoff/TakeOffWidgetModel$Height;", "precisionTakeOffHeight", "getPrecisionTakeOffHeight", "landHeight", "getLandHeight", "performTakeOffAction", "Lio/reactivex/rxjava3/core/Completable;", "performPrecisionTakeOffAction", "performLandingAction", "performCancelLandingAction", "performLandingConfirmationAction", "inSetup", "", "inCleanup", "updateStates", "updateAutoLandingData", "isCancelAutoLandingDisabled", "getHeightFromValue", "value", "", "TakeOffLandingState", "Height", "android-sdk-v5-uxsdk_release"})
public final class TakeOffWidgetModel
extends WidgetModel {
    @Nullable
    private final GlobalPreferencesInterface preferencesManager;
    @NotNull
    private final DataProcessor<Boolean> isFlyingDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> isAutoLandingDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> isLandingConfNeededDataProcessor;
    @NotNull
    private final DataProcessor<Integer> forceLandingHeightDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> areMotorsOnDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> isGoingHomeDataProcessor;
    @NotNull
    private final DataProcessor<String> flightModeStringDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> isCancelAutoLandingDisabledProcessor;
    @NotNull
    private final DataProcessor<FCAutoRTHReason> autoRTHReasonProcessor;
    @NotNull
    private final DataProcessor<RCMode> rcModeDataProcessor;
    @NotNull
    private final DataProcessor<ProductType> productModelProcessor;
    @NotNull
    private final DataProcessor<UnitConversionUtil.UnitType> unitTypeProcessor;
    @NotNull
    private final DataProcessor<LandingProtectionState> landingProtectionStateDataProcessor;
    @NotNull
    private final DataProcessor<FCFlightMode> flightModeProcessor;
    @NotNull
    private final DataProcessor<TakeOffLandingState> takeOffLandingStateDataProcessor;
    @NotNull
    private final DataProcessor<Boolean> isInAttiModeDataProcessor;

    public TakeOffWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.preferencesManager = preferencesManager;
        DataProcessor<Boolean> dataProcessor = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.isFlyingDataProcessor = dataProcessor;
        DataProcessor<Boolean> dataProcessor2 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.isAutoLandingDataProcessor = dataProcessor2;
        DataProcessor<Boolean> dataProcessor3 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.isLandingConfNeededDataProcessor = dataProcessor3;
        DataProcessor<Integer> dataProcessor4 = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.forceLandingHeightDataProcessor = dataProcessor4;
        DataProcessor<Boolean> dataProcessor5 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor5, (String)"create(...)");
        this.areMotorsOnDataProcessor = dataProcessor5;
        DataProcessor<Boolean> dataProcessor6 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor6, (String)"create(...)");
        this.isGoingHomeDataProcessor = dataProcessor6;
        DataProcessor<String> dataProcessor7 = DataProcessor.create("");
        Intrinsics.checkNotNullExpressionValue(dataProcessor7, (String)"create(...)");
        this.flightModeStringDataProcessor = dataProcessor7;
        DataProcessor<Boolean> dataProcessor8 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor8, (String)"create(...)");
        this.isCancelAutoLandingDisabledProcessor = dataProcessor8;
        DataProcessor<FCAutoRTHReason> dataProcessor9 = DataProcessor.create(FCAutoRTHReason.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor9, (String)"create(...)");
        this.autoRTHReasonProcessor = dataProcessor9;
        DataProcessor<RCMode> dataProcessor10 = DataProcessor.create(RCMode.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor10, (String)"create(...)");
        this.rcModeDataProcessor = dataProcessor10;
        DataProcessor<ProductType> dataProcessor11 = DataProcessor.create(ProductType.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor11, (String)"create(...)");
        this.productModelProcessor = dataProcessor11;
        DataProcessor<UnitConversionUtil.UnitType> dataProcessor12 = DataProcessor.create(UnitConversionUtil.UnitType.METRIC);
        Intrinsics.checkNotNullExpressionValue(dataProcessor12, (String)"create(...)");
        this.unitTypeProcessor = dataProcessor12;
        DataProcessor<LandingProtectionState> dataProcessor13 = DataProcessor.create(LandingProtectionState.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor13, (String)"create(...)");
        this.landingProtectionStateDataProcessor = dataProcessor13;
        DataProcessor<FCFlightMode> dataProcessor14 = DataProcessor.create(FCFlightMode.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor14, (String)"create(...)");
        this.flightModeProcessor = dataProcessor14;
        DataProcessor<TakeOffLandingState> dataProcessor15 = DataProcessor.create(TakeOffLandingState.DISCONNECTED);
        Intrinsics.checkNotNullExpressionValue(dataProcessor15, (String)"create(...)");
        this.takeOffLandingStateDataProcessor = dataProcessor15;
        DataProcessor<Boolean> dataProcessor16 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor16, (String)"create(...)");
        this.isInAttiModeDataProcessor = dataProcessor16;
        if (this.preferencesManager != null) {
            this.unitTypeProcessor.onNext(this.preferencesManager.getUnitType());
        }
    }

    @NotNull
    public final Flowable<TakeOffLandingState> getTakeOffLandingState() {
        Flowable flowable = this.takeOffLandingStateDataProcessor.toFlowable().distinctUntilChanged();
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"distinctUntilChanged(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<Boolean> isInAttiMode() {
        Flowable<Boolean> flowable = this.isInAttiModeDataProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Height getTakeOffHeight() {
        return this.getHeightFromValue(1.2f);
    }

    @NotNull
    public final Height getPrecisionTakeOffHeight() {
        return this.getHeightFromValue(6.0f);
    }

    @NotNull
    public final Height getLandHeight() {
        return this.getHeightFromValue(this.getLandHeight());
    }

    @NotNull
    public final Completable performTakeOffAction() {
        Completable completable = this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStartTakeoff)).onErrorResumeNext(new Function(this){
            final /* synthetic */ TakeOffWidgetModel this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                if (((Boolean)TakeOffWidgetModel.access$getAreMotorsOnDataProcessor$p(this.this$0).getValue()).booleanValue()) {
                    return (CompletableSource)Completable.complete();
                }
                return (CompletableSource)Completable.error((Throwable)error);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorResumeNext(...)");
        return completable;
    }

    @NotNull
    public final Completable performPrecisionTakeOffAction() {
        Completable completable = this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStartTakeoff)).onErrorResumeNext(new Function(this){
            final /* synthetic */ TakeOffWidgetModel this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                if (((Boolean)TakeOffWidgetModel.access$getAreMotorsOnDataProcessor$p(this.this$0).getValue()).booleanValue()) {
                    return (CompletableSource)Completable.complete();
                }
                return (CompletableSource)Completable.error((Throwable)error);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorResumeNext(...)");
        return completable;
    }

    @NotNull
    public final Completable performLandingAction() {
        Completable completable = this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStartAutoLanding));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"performActionWithOutResult(...)");
        return completable;
    }

    @NotNull
    public final Completable performCancelLandingAction() {
        Completable completable = this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStopAutoLanding));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"performActionWithOutResult(...)");
        return completable;
    }

    @NotNull
    public final Completable performLandingConfirmationAction() {
        Completable completable = this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyConfirmLanding));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"performActionWithOutResult(...)");
        return completable;
    }

    @Override
    protected void inSetup() {
        block0: {
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIsFlying), this.isFlyingDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIsInLandingMode), this.isAutoLandingDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIsLandingConfirmationNeeded), this.isLandingConfNeededDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyTouchDownConfirmLimitHeight), this.forceLandingHeightDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyFlightModeString), this.flightModeStringDataProcessor, arg_0 -> TakeOffWidgetModel.inSetup$lambda$0(this, arg_0));
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAreMotorsOn), this.areMotorsOnDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyFCFlightMode), this.flightModeProcessor, arg_0 -> TakeOffWidgetModel.inSetup$lambda$1(this, arg_0));
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAutoRTHReason), this.autoRTHReasonProcessor, arg_0 -> TakeOffWidgetModel.inSetup$lambda$2(this, arg_0));
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcMachineMode), this.rcModeDataProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)ProductKey.KeyProductType), this.productModelProcessor);
            UXKey unitKey = UXKeys.create("UnitType");
            this.bindDataProcessor(unitKey, this.unitTypeProcessor);
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightAssistantKey.KeyLandingProtectionState), this.landingProtectionStateDataProcessor);
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface == null) break block0;
            globalPreferencesInterface.setUpListener();
        }
    }

    @Override
    protected void inCleanup() {
        block0: {
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface == null) break block0;
            globalPreferencesInterface.cleanup();
        }
    }

    @Override
    protected void updateStates() {
        if (!((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.DISCONNECTED);
        } else if (this.isAutoLandingDataProcessor.getValue().booleanValue()) {
            this.updateAutoLandingData();
        } else if (this.isGoingHomeDataProcessor.getValue().booleanValue() && !this.isAutoLandingDataProcessor.getValue().booleanValue()) {
            this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.RETURNING_TO_HOME);
        } else if (!this.areMotorsOnDataProcessor.getValue().booleanValue()) {
            if (this.rcModeDataProcessor.getValue() == RCMode.SLAVE) {
                this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.TAKE_OFF_DISABLED);
            } else {
                this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.READY_TO_TAKE_OFF);
            }
        } else if (this.rcModeDataProcessor.getValue() == RCMode.SLAVE) {
            this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.LAND_DISABLED);
        } else {
            this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.READY_TO_LAND);
        }
    }

    private final void updateAutoLandingData() {
        if (this.isLandingConfNeededDataProcessor.getValue().booleanValue()) {
            this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.WAITING_FOR_LANDING_CONFIRMATION);
        } else if (this.isCancelAutoLandingDisabled()) {
            this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.FORCED_AUTO_LANDING);
        } else if (this.landingProtectionStateDataProcessor.getValue() == LandingProtectionState.NOT_SAFE_TO_LAND) {
            this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.UNSAFE_TO_LAND);
        } else {
            this.takeOffLandingStateDataProcessor.onNext(TakeOffLandingState.AUTO_LANDING);
        }
    }

    private final boolean isCancelAutoLandingDisabled() {
        return this.isCancelAutoLandingDisabledProcessor.getValue() != false || this.rcModeDataProcessor.getValue() == RCMode.SLAVE;
    }

    private final Height getHeightFromValue(float value) {
        float f = this.unitTypeProcessor.getValue() == UnitConversionUtil.UnitType.IMPERIAL ? UnitConversionUtil.convertMetersToFeet(value) : value;
        UnitConversionUtil.UnitType unitType = this.unitTypeProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
        return new Height(f, unitType);
    }

    private final float getLandHeight() {
        Integer n = this.forceLandingHeightDataProcessor.getValue();
        int n2 = Integer.MIN_VALUE;
        return n == null || n != n2 ? ((Number)this.forceLandingHeightDataProcessor.getValue()).floatValue() * 0.1f : 0.3f;
    }

    private static final void inSetup$lambda$0(TakeOffWidgetModel this$0, Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.isInAttiModeDataProcessor.onNext(StringsKt.contains((CharSequence)((String)value), (CharSequence)"atti", (boolean)true));
    }

    private static final void inSetup$lambda$1(TakeOffWidgetModel this$0, FCFlightMode it) {
        this$0.isGoingHomeDataProcessor.onNext(it == FCFlightMode.GO_HOME || it == FCFlightMode.AUTO_LANDING);
    }

    private static final void inSetup$lambda$2(TakeOffWidgetModel this$0, FCAutoRTHReason it) {
        this$0.isCancelAutoLandingDisabledProcessor.onNext(it == FCAutoRTHReason.WARNING_POWER_LANDING || it == FCAutoRTHReason.SMART_POWER_LANDING || it == FCAutoRTHReason.LOW_VOLTAGE_LANDING || it == FCAutoRTHReason.SERIOUS_LOW_VOLTAGE_LANDING || it == FCAutoRTHReason.NO_FLY_ZONE_LANDING || it == FCAutoRTHReason.BATTERY_FORCE_LANDING);
    }

    public static final /* synthetic */ DataProcessor access$getAreMotorsOnDataProcessor$p(TakeOffWidgetModel $this) {
        return $this.areMotorsOnDataProcessor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ldji/v5/ux/flight/takeoff/TakeOffWidgetModel$Height;", "", "height", "", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(FLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getHeight", "()F", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
    public static final class Height {
        private final float height;
        @NotNull
        private final UnitConversionUtil.UnitType unitType;

        public Height(float height, @NotNull UnitConversionUtil.UnitType unitType) {
            Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
            this.height = height;
            this.unitType = unitType;
        }

        public final float getHeight() {
            return this.height;
        }

        @NotNull
        public final UnitConversionUtil.UnitType getUnitType() {
            return this.unitType;
        }

        public final float component1() {
            return this.height;
        }

        @NotNull
        public final UnitConversionUtil.UnitType component2() {
            return this.unitType;
        }

        @NotNull
        public final Height copy(float height, @NotNull UnitConversionUtil.UnitType unitType) {
            Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
            return new Height(height, unitType);
        }

        public static /* synthetic */ Height copy$default(Height height, float f, UnitConversionUtil.UnitType unitType, int n, Object object) {
            if ((n & 1) != 0) {
                f = height.height;
            }
            if ((n & 2) != 0) {
                unitType = height.unitType;
            }
            return height.copy(f, unitType);
        }

        @NotNull
        public String toString() {
            return "Height(height=" + this.height + ", unitType=" + this.unitType + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.height);
            result = result * 31 + this.unitType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Height)) {
                return false;
            }
            Height height = (Height)other;
            if (Float.compare(this.height, height.height) != 0) {
                return false;
            }
            return this.unitType == height.unitType;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Ldji/v5/ux/flight/takeoff/TakeOffWidgetModel$TakeOffLandingState;", "", "<init>", "(Ljava/lang/String;I)V", "READY_TO_TAKE_OFF", "READY_TO_LAND", "AUTO_LANDING", "FORCED_AUTO_LANDING", "WAITING_FOR_LANDING_CONFIRMATION", "UNSAFE_TO_LAND", "RETURNING_TO_HOME", "TAKE_OFF_DISABLED", "LAND_DISABLED", "DISCONNECTED", "android-sdk-v5-uxsdk_release"})
    public static final class TakeOffLandingState
    extends Enum<TakeOffLandingState> {
        public static final /* enum */ TakeOffLandingState READY_TO_TAKE_OFF = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState READY_TO_LAND = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState AUTO_LANDING = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState FORCED_AUTO_LANDING = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState WAITING_FOR_LANDING_CONFIRMATION = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState UNSAFE_TO_LAND = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState RETURNING_TO_HOME = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState TAKE_OFF_DISABLED = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState LAND_DISABLED = new TakeOffLandingState();
        public static final /* enum */ TakeOffLandingState DISCONNECTED = new TakeOffLandingState();
        private static final /* synthetic */ TakeOffLandingState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TakeOffLandingState[] values() {
            return (TakeOffLandingState[])$VALUES.clone();
        }

        public static TakeOffLandingState valueOf(String value) {
            return Enum.valueOf(TakeOffLandingState.class, value);
        }

        @NotNull
        public static EnumEntries<TakeOffLandingState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = takeOffLandingStateArray = new TakeOffLandingState[]{TakeOffLandingState.READY_TO_TAKE_OFF, TakeOffLandingState.READY_TO_LAND, TakeOffLandingState.AUTO_LANDING, TakeOffLandingState.FORCED_AUTO_LANDING, TakeOffLandingState.WAITING_FOR_LANDING_CONFIRMATION, TakeOffLandingState.UNSAFE_TO_LAND, TakeOffLandingState.RETURNING_TO_HOME, TakeOffLandingState.TAKE_OFF_DISABLED, TakeOffLandingState.LAND_DISABLED, TakeOffLandingState.DISCONNECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

