/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting;

import android.content.Context;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.ContextUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.setting.data.MenuBean;
import dji.v5.ux.core.ui.setting.taplayout.QTabView;
import dji.v5.ux.core.ui.setting.taplayout.TabAdapter;
import dji.v5.ux.core.ui.setting.ui.SettingMenuFragment;
import java.util.List;

public class SettingFragmentPagerAdapter
extends FragmentPagerAdapter
implements TabAdapter {
    private List<MenuBean> mAdapterMenus;
    private List<Fragment> mAdapterFragments;
    private FragmentManager mCurrentFragmentManager;

    public SettingFragmentPagerAdapter(FragmentManager fm, List<MenuBean> menus, List<Fragment> mFragments) {
        super(fm);
        this.mAdapterMenus = menus;
        this.mAdapterFragments = mFragments;
        this.mCurrentFragmentManager = fm;
    }

    public Fragment getItem(int position) {
        return this.mAdapterFragments.get(position);
    }

    public int getSelectIndex(String str) {
        if (this.mAdapterFragments != null && this.mAdapterFragments.size() > 0 && !TextUtils.isEmpty((CharSequence)str)) {
            for (int i = 0; i < this.mAdapterFragments.size(); ++i) {
                SettingMenuFragment fragment;
                if (!(this.mAdapterFragments.get(i) instanceof SettingMenuFragment) || !str.equals((fragment = (SettingMenuFragment)this.mAdapterFragments.get(i)).getFragmentFlag())) continue;
                return i;
            }
        }
        return -1;
    }

    public String getSelectFlag(int index) {
        SettingMenuFragment fragment;
        if (this.mAdapterFragments != null && index >= 0 && index < this.mAdapterFragments.size() && (fragment = (SettingMenuFragment)this.mAdapterFragments.get(index)) != null) {
            return fragment.getFragmentFlag();
        }
        return "";
    }

    public void removePayloadPanel() {
        this.removeMenuPanel("PayloadFragment", R.drawable.uxsdk_ic_setting_psdk);
    }

    public void addPayloadPanel() {
        this.addMenuPanel("GimbalMenuFragment", "PayloadFragment", R.drawable.uxsdk_ic_setting_psdk_active, R.drawable.uxsdk_ic_setting_psdk);
    }

    public void addSearchlightPayloadPanel() {
        this.addMenuPanel("GimbalMenuFragment", "SearchlightSettingFragment", R.drawable.uxsdk_ic_setting_psdk_active, R.drawable.uxsdk_ic_setting_psdk);
    }

    public void removeSearchlightPayloadPanel() {
        this.removeMenuPanel("SearchlightSettingFragment", R.drawable.uxsdk_ic_setting_psdk);
    }

    public void removeRTKPanel() {
        this.removeMenuPanel("RtkMenuFragment", R.drawable.uxsdk_ic_setting_rtk);
    }

    public void addRTKPanel() {
        this.addMenuPanel("GimbalMenuFragment", "RtkMenuFragment", R.drawable.uxsdk_ic_setting_rtk_active, R.drawable.uxsdk_ic_setting_rtk);
    }

    public void addMenuPanel(String prePage, String page, int selectedIcon, int normalIcon) {
        int payloadIndex = this.getSelectIndex(page);
        if (payloadIndex >= 0) {
            return;
        }
        int gimbalIndex = this.getSelectIndex(prePage);
        if (gimbalIndex >= 0) {
            payloadIndex = gimbalIndex + 1;
            this.mAdapterMenus.add(payloadIndex, new MenuBean(selectedIcon, normalIcon));
            SettingMenuFragment fragment = SettingMenuFragment.newInstance(page);
            this.mAdapterFragments.add(payloadIndex, fragment);
            this.notifyDataSetChanged();
        }
    }

    public void removeMenuPanel(String page, int normalIcon) {
        MenuBean menu;
        int payloadIndex = this.getSelectIndex(page);
        if (payloadIndex >= 0 && (menu = this.mAdapterMenus.get(payloadIndex)).getNormalIcon() == normalIcon) {
            this.mAdapterMenus.remove(payloadIndex);
            this.mAdapterFragments.remove(payloadIndex);
            this.notifyDataSetChanged();
        }
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    @Override
    public int getCount() {
        return this.mAdapterFragments.size();
    }

    @Override
    public int getBadge(int position) {
        return 0;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        String name = ((SettingMenuFragment)this.getItem(position)).getFragmentFlag();
        Fragment fragment = this.mCurrentFragmentManager.findFragmentByTag(name);
        if (fragment != null) {
            this.mCurrentFragmentManager.beginTransaction().attach(fragment).commitNowAllowingStateLoss();
        } else {
            fragment = this.getItem(position);
            this.mCurrentFragmentManager.beginTransaction().add(container.getId(), fragment, name).commitNowAllowingStateLoss();
        }
        this.mCurrentFragmentManager.executePendingTransactions();
        return fragment;
    }

    @Override
    public QTabView.TabIcon getIcon(int position) {
        MenuBean menu = this.mAdapterMenus.get(position >= this.mAdapterMenus.size() ? this.mAdapterMenus.size() - 1 : position);
        return new QTabView.TabIcon.Builder().setIcon(menu.getSelectIcon(), menu.getNormalIcon()).setIconGravity(17).setIconSize(AndUtil.dip2px((Context)ContextUtil.getContext(), (float)50.0f), AndUtil.dip2px((Context)ContextUtil.getContext(), (float)50.0f)).setBackground(R.drawable.uxsdk_selector_blue_oval_mask).build();
    }

    @Override
    public QTabView.TabTitle getTitle(int position) {
        return null;
    }

    @Override
    public int getBackground(int position) {
        return R.color.uxsdk_fpv_popover_content_background_color;
    }

    public void destroy() {
        this.mCurrentFragmentManager = null;
        if (this.mAdapterFragments != null) {
            this.mAdapterFragments.clear();
        }
        if (this.mAdapterMenus != null) {
            this.mAdapterMenus.clear();
        }
    }
}

