/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi;

import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.GimbalKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.value.common.Attitude;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.common.LocationCoordinate3D;
import dji.sdk.keyvalue.value.common.Velocity3D;
import dji.sdk.keyvalue.value.flightcontroller.FCFlightMode;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.common.utils.RxUtil;
import dji.v5.manager.aircraft.perception.PerceptionManager;
import dji.v5.manager.aircraft.perception.data.ObstacleData;
import dji.v5.manager.aircraft.perception.data.PerceptionInfo;
import dji.v5.manager.aircraft.perception.listener.ObstacleDataListener;
import dji.v5.manager.aircraft.perception.listener.PerceptionInformationListener;
import dji.v5.manager.aircraft.perception.radar.RadarInformation;
import dji.v5.manager.aircraft.perception.radar.RadarInformationListener;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.MobileGPSLocationUtil;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;

public class HSIWidgetModel
extends WidgetModel
implements LocationListener {
    private final DataProcessor<LocationCoordinate3D> aircraftLocationDataProcessor = DataProcessor.create(new LocationCoordinate3D(Double.valueOf(Double.NaN), Double.valueOf(Double.NaN), Double.valueOf(Double.NaN)));
    private final DataProcessor<LocationCoordinate2D> homeLocationDataProcessor = DataProcessor.create(new LocationCoordinate2D(Double.valueOf(Double.NaN), Double.valueOf(Double.NaN)));
    private final DataProcessor<FCFlightMode> flightModeProcessor = DataProcessor.create(FCFlightMode.UNKNOWN);
    private final DataProcessor<Boolean> multipleFlightModeEnabledProcessor = DataProcessor.create(false);
    private final DataProcessor<Velocity3D> velocityProcessor = DataProcessor.create(new Velocity3D());
    private final DataProcessor<Attitude> aircraftAttitudeProcessor = DataProcessor.create(new Attitude());
    private final DataProcessor<ProductType> productTypeDataProcessor = DataProcessor.create(ProductType.UNKNOWN);
    private final List<DataProcessor<Boolean>> gimbalConnectionProcessorList = new ArrayList<DataProcessor<Boolean>>();
    private final DataProcessor<Boolean> gimbalConnection0Processor = DataProcessor.create(false);
    private final DataProcessor<Boolean> gimbalConnection1Processor = DataProcessor.create(false);
    private final DataProcessor<Boolean> gimbalConnection2Processor = DataProcessor.create(false);
    private final List<DataProcessor<Double>> gimbalYawInDegreesProcessorList = new ArrayList<DataProcessor<Double>>();
    private final DataProcessor<Double> gimbalYawInDegrees0Processor = DataProcessor.create(0.0);
    private final DataProcessor<Double> gimbalYawInDegrees1Processor = DataProcessor.create(0.0);
    private final DataProcessor<Double> gimbalYawInDegrees2Processor = DataProcessor.create(0.0);
    private static final Double RAD_TO_DEG = 57.29577951308232;
    private final DataProcessor<RadarInformation> radarInformationDataProcessor = DataProcessor.create(new RadarInformation());
    private final DataProcessor<PerceptionInfo> perceptionInformationDataProcessor = DataProcessor.create(new PerceptionInfo());
    private final DataProcessor<ObstacleData> radarObstacleDataProcessor = DataProcessor.create(new ObstacleData());
    private final DataProcessor<ObstacleData> perceptionObstacleDataProcessor = DataProcessor.create(new ObstacleData());
    private RadarInformationListener radarInformationListener = radarInformation -> this.radarInformationDataProcessor.onNext(radarInformation);
    private PerceptionInformationListener perceptionInformationListener = perceptionInfo -> this.perceptionInformationDataProcessor.onNext(perceptionInfo);
    private ObstacleDataListener radarObstacleDataListener = data -> this.radarObstacleDataProcessor.onNext(data);
    private ObstacleDataListener perceptionObstacleDataListener = data -> this.perceptionObstacleDataProcessor.onNext(data);
    private final DataProcessor<Location> locationDataProcessor = DataProcessor.create(new Location("HSIWidgetModel"));

    public HSIWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftLocation3D), this.aircraftLocationDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHomeLocation), this.homeLocationDataProcessor);
        Flowable.combineLatest((Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyGimbalAttitude, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyImuCoordinateTran), (Object)this), (attitude, aDouble) -> attitude.getYaw() + aDouble * RAD_TO_DEG).subscribe(this.gimbalYawInDegrees0Processor::onNext);
        Flowable.combineLatest((Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyGimbalAttitude, (ComponentIndexType)ComponentIndexType.RIGHT), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyImuCoordinateTran), (Object)this), (attitude, aDouble) -> attitude.getYaw() + aDouble * RAD_TO_DEG).subscribe(this.gimbalYawInDegrees1Processor::onNext);
        Flowable.combineLatest((Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyGimbalAttitude, (ComponentIndexType)ComponentIndexType.UP), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyImuCoordinateTran), (Object)this), (attitude, aDouble) -> attitude.getYaw() + aDouble * RAD_TO_DEG).subscribe(this.gimbalYawInDegrees2Processor::onNext);
        this.gimbalYawInDegreesProcessorList.add(this.gimbalYawInDegrees0Processor);
        this.gimbalYawInDegreesProcessorList.add(this.gimbalYawInDegrees1Processor);
        this.gimbalYawInDegreesProcessorList.add(this.gimbalYawInDegrees2Processor);
        MobileGPSLocationUtil.getInstance().addLocationListener(this);
        MobileGPSLocationUtil.getInstance().startUpdateLocation();
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyFCFlightMode), this.flightModeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyMultipleFlightModeEnabled), this.multipleFlightModeEnabledProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftVelocity), this.velocityProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftAttitude), this.aircraftAttitudeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)ProductKey.KeyProductType), this.productTypeDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyConnection, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.gimbalConnection0Processor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyConnection, (ComponentIndexType)ComponentIndexType.RIGHT), this.gimbalConnection1Processor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyConnection, (ComponentIndexType)ComponentIndexType.UP), this.gimbalConnection2Processor);
        this.gimbalConnectionProcessorList.add(this.gimbalConnection0Processor);
        this.gimbalConnectionProcessorList.add(this.gimbalConnection1Processor);
        this.gimbalConnectionProcessorList.add(this.gimbalConnection2Processor);
        PerceptionManager.getInstance().getRadarManager().addObstacleDataListener(this.radarObstacleDataListener);
        PerceptionManager.getInstance().getRadarManager().addRadarInformationListener(this.radarInformationListener);
        PerceptionManager.getInstance().addPerceptionInformationListener(this.perceptionInformationListener);
        PerceptionManager.getInstance().addObstacleDataListener(this.perceptionObstacleDataListener);
    }

    @Override
    protected void inCleanup() {
        this.gimbalConnectionProcessorList.clear();
        this.gimbalYawInDegreesProcessorList.clear();
        PerceptionManager.getInstance().getRadarManager().removeRadarInformationListener(this.radarInformationListener);
        PerceptionManager.getInstance().getRadarManager().removeObstacleDataListener(this.radarObstacleDataListener);
        PerceptionManager.getInstance().removePerceptionInformationListener(this.perceptionInformationListener);
        PerceptionManager.getInstance().removeObstacleDataListener(this.perceptionObstacleDataListener);
        MobileGPSLocationUtil.getInstance().removeLocationListener(this);
    }

    public DataProcessor<LocationCoordinate3D> getAircraftLocationDataProcessor() {
        return this.aircraftLocationDataProcessor;
    }

    public DataProcessor<LocationCoordinate2D> getHomeLocationDataProcessor() {
        return this.homeLocationDataProcessor;
    }

    public DataProcessor<FCFlightMode> getFlightModeProcessor() {
        return this.flightModeProcessor;
    }

    public DataProcessor<Boolean> getMultipleFlightModeEnabledProcessor() {
        return this.multipleFlightModeEnabledProcessor;
    }

    public DataProcessor<Velocity3D> getVelocityProcessor() {
        return this.velocityProcessor;
    }

    public DataProcessor<Attitude> getAircraftAttitudeProcessor() {
        return this.aircraftAttitudeProcessor;
    }

    public List<DataProcessor<Boolean>> getGimbalConnectionProcessorList() {
        return this.gimbalConnectionProcessorList;
    }

    public List<DataProcessor<Double>> getGimbalYawInDegreesProcessorList() {
        return this.gimbalYawInDegreesProcessorList;
    }

    public DataProcessor<RadarInformation> getRadarInformationDataProcessor() {
        return this.radarInformationDataProcessor;
    }

    public DataProcessor<ProductType> getProductTypeDataProcessor() {
        return this.productTypeDataProcessor;
    }

    public DataProcessor<PerceptionInfo> getPerceptionInformationDataProcessor() {
        return this.perceptionInformationDataProcessor;
    }

    public DataProcessor<Location> getLocationDataProcessor() {
        return this.locationDataProcessor;
    }

    public void onLocationChanged(Location location) {
        this.locationDataProcessor.onNext(location);
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }

    public DataProcessor<ObstacleData> getRadarObstacleDataProcessor() {
        return this.radarObstacleDataProcessor;
    }

    public DataProcessor<ObstacleData> getPerceptionObstacleDataProcessor() {
        return this.perceptionObstacleDataProcessor;
    }
}

