/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DividerLinearLayout;

public class ProgressStatusWidget
extends DividerLinearLayout {
    public TextView mValueView;
    public TextView mDescView;
    public ProgressBar mProgressBar;

    public ProgressStatusWidget(Context context) {
        this(context, null);
    }

    public ProgressStatusWidget(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressStatusWidget(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    @TargetApi(value=21)
    public ProgressStatusWidget(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context);
    }

    private void initialize(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_widget_progress_bar_layout, (ViewGroup)this, true);
        if (this.isInEditMode()) {
            return;
        }
        this.setBottomDividerEnable(false);
        this.mValueView = (TextView)this.findViewById(R.id.status_widget_value);
        this.mDescView = (TextView)this.findViewById(R.id.status_widget_desc);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.status_widget_progress);
    }

    public String getValue() {
        return this.mValueView.getText().toString();
    }

    public void setValue(String value) {
        this.mValueView.setText((CharSequence)value);
    }

    public String getDesc() {
        return this.mDescView.getText().toString();
    }

    public void setDesc(String desc) {
        this.mDescView.setText((CharSequence)desc);
    }

    public int getProgress() {
        return this.mProgressBar.getProgress();
    }

    public void setProgress(int progress) {
        this.mProgressBar.setProgress(progress);
    }

    public void setProgressDrawable(Drawable drawable2) {
        this.mProgressBar.setProgressDrawable(drawable2);
    }
}

