/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracapture.recordvideo;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.camera.CameraSDCardState;
import dji.sdk.keyvalue.value.camera.CameraStorageLocation;
import dji.sdk.keyvalue.value.camera.SSDOperationState;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.util.CameraActionSound;
import dji.v5.ux.cameracore.widget.cameracapture.recordvideo.CameraSDVideoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.recordvideo.CameraSSDVideoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.recordvideo.CameraVideoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.recordvideo.RecordVideoWidgetModel;
import dji.v5.ux.cameracore.widget.cameracontrols.RemoteControllerButtonDownModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.core.util.UxErrorHandle;
import io.reactivex.rxjava3.core.Completable;
import java.util.HashMap;
import java.util.Map;

public class RecordVideoWidget
extends ConstraintLayoutWidget<Object>
implements View.OnClickListener,
ICameraIndex {
    private static final String TAG = "RecordVideoWidget";
    private RecordVideoWidgetModel widgetModel;
    private RemoteControllerButtonDownModel buttonDownModel;
    private ImageView centerImageView;
    private TextView videoTimerTextView;
    private ImageView storageStatusOverlayImageView;
    private Map<StorageIconState, Drawable> storageInternalIconMap;
    private Map<StorageIconState, Drawable> storageSSDIconMap;
    private Map<StorageIconState, Drawable> storageSDCardIconMap;
    private Drawable recordVideoStartDrawable;
    private Drawable recordVideoStopDrawable;
    private CameraActionSound cameraActionSound;

    public RecordVideoWidget(Context context) {
        super(context);
    }

    public RecordVideoWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RecordVideoWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        RecordVideoWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_record_video, (ViewGroup)this);
        this.centerImageView = (ImageView)this.findViewById(R.id.image_view_center);
        this.videoTimerTextView = (TextView)this.findViewById(R.id.text_view_video_record_time);
        this.storageStatusOverlayImageView = (ImageView)this.findViewById(R.id.image_view_storage_status_overlay);
        this.storageInternalIconMap = new HashMap<StorageIconState, Drawable>();
        this.storageSSDIconMap = new HashMap<StorageIconState, Drawable>();
        this.storageSDCardIconMap = new HashMap<StorageIconState, Drawable>();
        this.centerImageView.setOnClickListener((View.OnClickListener)this);
        this.cameraActionSound = new CameraActionSound(context);
        if (!this.isInEditMode()) {
            this.widgetModel = new RecordVideoWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.buttonDownModel = new RemoteControllerButtonDownModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        this.initDefaults();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
            this.buttonDownModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
            this.buttonDownModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getRecordingTimeInSeconds().observeOn(SchedulerProvider.ui()).subscribe(this::updateRecordingTime, UxErrorHandle.logErrorConsumer(TAG, "record time: ")));
        this.addReaction(this.widgetModel.getRecordingState().observeOn(SchedulerProvider.ui()).subscribe(recordingState -> this.onIsRecordingVideoChange((RecordVideoWidgetModel.RecordingState)((Object)recordingState), true), UxErrorHandle.logErrorConsumer(TAG, "is recording: ")));
        this.addReaction(this.widgetModel.getCameraVideoStorageState().observeOn(SchedulerProvider.ui()).subscribe(this::updateCameraForegroundResource, UxErrorHandle.logErrorConsumer(TAG, "camera storage update: ")));
        this.addReaction(this.buttonDownModel.isRecordButtonDownProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(aBoolean -> {
            if (aBoolean == Boolean.TRUE) {
                this.actionOnRecording();
            }
        }));
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_default_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        if (!this.isInEditMode()) {
            this.widgetModel.updateCameraSource(cameraIndex, lensType);
        }
    }

    public void onClick(View v) {
        if (v.equals(this.centerImageView)) {
            this.actionOnRecording();
        }
    }

    private void actionOnRecording() {
        if (!this.widgetModel.isVideoMode()) {
            return;
        }
        this.widgetModel.getRecordingState().firstOrError().flatMapCompletable(recordingState -> {
            if (recordingState == RecordVideoWidgetModel.RecordingState.RECORDING_IN_PROGRESS) {
                return this.widgetModel.stopRecordVideo();
            }
            if (recordingState == RecordVideoWidgetModel.RecordingState.RECORDING_STOPPED || recordingState == RecordVideoWidgetModel.RecordingState.RECORDING_NOT_STARED) {
                return this.widgetModel.startRecordVideo();
            }
            return Completable.complete();
        }).observeOn(SchedulerProvider.ui()).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(TAG, "START STOP VIDEO"));
    }

    private void initDefaults() {
        this.recordVideoStartDrawable = this.getResources().getDrawable(R.drawable.uxsdk_selector_start_record_video);
        this.recordVideoStopDrawable = this.getResources().getDrawable(R.drawable.uxsdk_selector_stop_record_video);
        this.setInternalStorageIcon(StorageIconState.NOT_INSERTED, R.drawable.uxsdk_ic_internal_storage_not_inserted);
        this.setInternalStorageIcon(StorageIconState.SLOW, R.drawable.uxsdk_ic_internal_storage_slow);
        this.setInternalStorageIcon(StorageIconState.FULL, R.drawable.uxsdk_ic_internal_storage_full);
        this.setSDCardStorageIcon(StorageIconState.NOT_INSERTED, R.drawable.uxsdk_ic_sdcard_not_inserted);
        this.setSDCardStorageIcon(StorageIconState.SLOW, R.drawable.uxsdk_ic_sdcard_slow);
        this.setSDCardStorageIcon(StorageIconState.FULL, R.drawable.uxsdk_ic_sdcard_full);
        this.setSSDStorageIcon(StorageIconState.NOT_INSERTED, R.drawable.uxsdk_ic_ssd_not_inserted);
        this.setSSDStorageIcon(StorageIconState.FULL, R.drawable.uxsdk_ic_ssd_full);
        this.setVideoTimerTextColor(-1);
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RecordVideoWidget);
        this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.RecordVideoWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.RecordVideoWidget_uxsdk_lensType, 0)));
        int textAppearance = typedArray.getResourceId(R.styleable.RecordVideoWidget_uxsdk_timerTextAppearance, -1);
        if (textAppearance != -1) {
            this.setTimerTextAppearance(textAppearance);
        }
        this.setVideoTimerTextColor(typedArray.getColor(R.styleable.RecordVideoWidget_uxsdk_timerTextColor, -1));
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_timerTextBackground) != null) {
            this.setVideoTimerTextBackground(typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_timerTextBackground));
        }
        this.setVideoTimerTextSize(typedArray.getDimension(R.styleable.RecordVideoWidget_uxsdk_timerTextSize, 12.0f));
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_foregroundIconBackground) != null) {
            this.setForegroundIconBackground(typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_foregroundIconBackground));
        }
        this.initRecordVideoDrawable(typedArray);
        this.initInternalStorageIcon(typedArray);
        this.initSDCardStorageIcon(typedArray);
        this.initSSDStorageIcon(typedArray);
        typedArray.recycle();
    }

    private void initSSDStorageIcon(TypedArray typedArray) {
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_ssdNotInsertedIcon) != null) {
            this.setSSDStorageIcon(StorageIconState.NOT_INSERTED, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_ssdNotInsertedIcon));
        }
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_ssdFullIcon) != null) {
            this.setSSDStorageIcon(StorageIconState.FULL, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_ssdFullIcon));
        }
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_ssdSlowIcon) != null) {
            this.setSSDStorageIcon(StorageIconState.SLOW, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_ssdSlowIcon));
        }
    }

    private void initSDCardStorageIcon(TypedArray typedArray) {
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_sdCardNotInsertedIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.NOT_INSERTED, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_sdCardNotInsertedIcon));
        }
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_sdCardFullIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.FULL, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_sdCardFullIcon));
        }
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_sdCardSlowIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.SLOW, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_sdCardSlowIcon));
        }
    }

    private void initInternalStorageIcon(TypedArray typedArray) {
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_internalStorageNotInsertedIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.NOT_INSERTED, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_internalStorageNotInsertedIcon));
        }
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_internalStorageFullIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.FULL, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_internalStorageFullIcon));
        }
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_internalStorageSlowIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.SLOW, typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_internalStorageSlowIcon));
        }
    }

    private void initRecordVideoDrawable(TypedArray typedArray) {
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_recordStartIcon) != null) {
            this.recordVideoStartDrawable = typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_recordStartIcon);
        }
        if (typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_recordStopIcon) != null) {
            this.recordVideoStopDrawable = typedArray.getDrawable(R.styleable.RecordVideoWidget_uxsdk_recordStopIcon);
        }
    }

    private void updateCameraForegroundResource(CameraVideoStorageState cameraVideoStorageState) {
        Drawable foregroundResource = null;
        if (cameraVideoStorageState instanceof CameraSDVideoStorageState) {
            if (cameraVideoStorageState.getStorageLocation() == CameraStorageLocation.SDCARD) {
                foregroundResource = this.updateResourceWithStorageInSDCard(cameraVideoStorageState);
            } else if (cameraVideoStorageState.getStorageLocation() == CameraStorageLocation.INTERNAL) {
                foregroundResource = this.updateResourceWithStorageInternal(cameraVideoStorageState);
            }
        } else if (cameraVideoStorageState instanceof CameraSSDVideoStorageState) {
            if (((CameraSSDVideoStorageState)cameraVideoStorageState).getSsdOperationState() == SSDOperationState.NOT_FOUND) {
                foregroundResource = this.getSSDStorageIcon(StorageIconState.NOT_INSERTED);
            } else if (((CameraSSDVideoStorageState)cameraVideoStorageState).getSsdOperationState() == SSDOperationState.FULL) {
                foregroundResource = this.getSSDStorageIcon(StorageIconState.FULL);
            }
        }
        this.storageStatusOverlayImageView.setImageDrawable(foregroundResource);
    }

    private Drawable updateResourceWithStorageInSDCard(CameraVideoStorageState cameraVideoStorageState) {
        Drawable foregroundResource = null;
        if (((CameraSDVideoStorageState)cameraVideoStorageState).getSdCardOperationState() == CameraSDCardState.NOT_INSERTED) {
            foregroundResource = this.getSDCardStorageIcon(StorageIconState.NOT_INSERTED);
        } else if (((CameraSDVideoStorageState)cameraVideoStorageState).getSdCardOperationState() == CameraSDCardState.FULL) {
            foregroundResource = this.getSDCardStorageIcon(StorageIconState.FULL);
        } else if (((CameraSDVideoStorageState)cameraVideoStorageState).getSdCardOperationState() == CameraSDCardState.SLOW) {
            foregroundResource = this.getSDCardStorageIcon(StorageIconState.SLOW);
        }
        return foregroundResource;
    }

    private Drawable updateResourceWithStorageInternal(CameraVideoStorageState cameraVideoStorageState) {
        Drawable foregroundResource = null;
        if (((CameraSDVideoStorageState)cameraVideoStorageState).getSdCardOperationState() == CameraSDCardState.NOT_INSERTED) {
            foregroundResource = this.getInternalStorageIcon(StorageIconState.NOT_INSERTED);
        } else if (((CameraSDVideoStorageState)cameraVideoStorageState).getSdCardOperationState() == CameraSDCardState.FULL) {
            foregroundResource = this.getInternalStorageIcon(StorageIconState.FULL);
        } else if (((CameraSDVideoStorageState)cameraVideoStorageState).getSdCardOperationState() == CameraSDCardState.SLOW) {
            foregroundResource = this.getInternalStorageIcon(StorageIconState.SLOW);
        }
        return foregroundResource;
    }

    private void updateRecordingTime(int seconds) {
        this.videoTimerTextView.setText((CharSequence)CameraUtil.formatVideoTime(this.getResources(), seconds));
    }

    private void onIsRecordingVideoChange(RecordVideoWidgetModel.RecordingState recordingState, boolean playSound) {
        boolean isRecordingVideo = recordingState == RecordVideoWidgetModel.RecordingState.RECORDING_IN_PROGRESS;
        Drawable recordStart = this.recordVideoStartDrawable;
        Drawable recordStop = this.recordVideoStopDrawable;
        this.centerImageView.setImageDrawable(isRecordingVideo ? recordStop : recordStart);
        this.videoTimerTextView.setVisibility(isRecordingVideo ? 0 : 4);
        this.storageStatusOverlayImageView.setVisibility(isRecordingVideo ? 8 : 0);
        if (playSound) {
            if (recordingState == RecordVideoWidgetModel.RecordingState.RECORDING_IN_PROGRESS) {
                this.cameraActionSound.playStartRecordVideo();
            } else if (recordingState == RecordVideoWidgetModel.RecordingState.RECORDING_STOPPED) {
                this.cameraActionSound.playStopRecordVideo();
            }
        }
    }

    private void checkAndUpdateCameraForegroundResource() {
        if (!this.isInEditMode()) {
            this.addDisposable(this.widgetModel.getCameraVideoStorageState().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(this::updateCameraForegroundResource, UxErrorHandle.logErrorConsumer(TAG, "check and update camera foreground resource: ")));
        }
    }

    private void checkAndUpdateCenterImageView() {
        if (!this.isInEditMode()) {
            this.addDisposable(this.widgetModel.getRecordingState().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(recordingState -> this.onIsRecordingVideoChange((RecordVideoWidgetModel.RecordingState)((Object)recordingState), false), UxErrorHandle.logErrorConsumer(TAG, "check and update camera foreground resource: ")));
        }
    }

    @Nullable
    public Drawable getRecordVideoStartDrawable() {
        return this.recordVideoStartDrawable;
    }

    public void setRecordVideoStartDrawable(@DrawableRes int resourceId) {
        this.setRecordVideoStartDrawable(this.getResources().getDrawable(resourceId));
    }

    public void setRecordVideoStartDrawable(@Nullable Drawable drawable2) {
        this.recordVideoStartDrawable = drawable2;
        this.checkAndUpdateCenterImageView();
    }

    @Nullable
    public Drawable getRecordVideoStopDrawable() {
        return this.recordVideoStopDrawable;
    }

    public void setRecordVideoStopDrawable(@DrawableRes int resourceId) {
        this.setRecordVideoStopDrawable(this.getResources().getDrawable(resourceId));
    }

    public void setRecordVideoStopDrawable(@Nullable Drawable drawable2) {
        this.recordVideoStopDrawable = drawable2;
        this.checkAndUpdateCenterImageView();
    }

    public void setInternalStorageIcon(@NonNull StorageIconState storageIconState, @DrawableRes int resourceId) {
        this.setInternalStorageIcon(storageIconState, this.getResources().getDrawable(resourceId));
    }

    public void setInternalStorageIcon(@NonNull StorageIconState storageIconState, @Nullable Drawable drawable2) {
        this.storageInternalIconMap.put(storageIconState, drawable2);
        this.checkAndUpdateCameraForegroundResource();
    }

    @Nullable
    public Drawable getInternalStorageIcon(@NonNull StorageIconState storageIconState) {
        return this.storageInternalIconMap.get((Object)storageIconState);
    }

    public void setSDCardStorageIcon(@NonNull StorageIconState storageIconState, @DrawableRes int resourceId) {
        this.setSDCardStorageIcon(storageIconState, this.getResources().getDrawable(resourceId));
    }

    public void setSDCardStorageIcon(@NonNull StorageIconState storageIconState, @Nullable Drawable drawable2) {
        this.storageSDCardIconMap.put(storageIconState, drawable2);
        this.checkAndUpdateCameraForegroundResource();
    }

    @Nullable
    public Drawable getSDCardStorageIcon(@NonNull StorageIconState storageIconState) {
        return this.storageSDCardIconMap.get((Object)storageIconState);
    }

    public void setSSDStorageIcon(@NonNull StorageIconState storageIconState, @DrawableRes int resourceId) {
        this.setSSDStorageIcon(storageIconState, this.getResources().getDrawable(resourceId));
    }

    public void setSSDStorageIcon(@NonNull StorageIconState storageIconState, @Nullable Drawable drawable2) {
        this.storageSSDIconMap.put(storageIconState, drawable2);
        this.checkAndUpdateCameraForegroundResource();
    }

    @Nullable
    public Drawable getSSDStorageIcon(@NonNull StorageIconState storageIconState) {
        return this.storageSSDIconMap.get((Object)storageIconState);
    }

    public void setForegroundIconBackground(@DrawableRes int resourceId) {
        this.storageStatusOverlayImageView.setBackgroundResource(resourceId);
    }

    public void setForegroundIconBackground(@Nullable Drawable drawable2) {
        this.storageStatusOverlayImageView.setBackground(drawable2);
    }

    public Drawable getForegroundIconBackground() {
        return this.storageStatusOverlayImageView.getBackground();
    }

    public void setVideoTimerTextBackground(@DrawableRes int resourceId) {
        this.videoTimerTextView.setBackgroundResource(resourceId);
    }

    public void setVideoTimerTextBackground(@Nullable Drawable drawable2) {
        this.videoTimerTextView.setBackground(drawable2);
    }

    @Nullable
    public ColorStateList getVideoTimerTextColors() {
        return this.videoTimerTextView.getTextColors();
    }

    public void setVideoTimerTextColors(@Nullable ColorStateList colorStateList) {
        this.videoTimerTextView.setTextColor(colorStateList);
    }

    @ColorInt
    public int getVideoTimerTextColor() {
        return this.videoTimerTextView.getCurrentTextColor();
    }

    public void setVideoTimerTextColor(@ColorInt int color2) {
        this.videoTimerTextView.setTextColor(color2);
    }

    @Dimension
    public float getVideoTimerTextSize() {
        return this.videoTimerTextView.getTextSize();
    }

    public void setVideoTimerTextSize(@Dimension float textSize) {
        this.videoTimerTextView.setTextSize(textSize);
    }

    public void setTimerTextAppearance(@StyleRes int textAppearance) {
        this.videoTimerTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    public static enum StorageIconState {
        SLOW,
        FULL,
        NOT_INSERTED;

    }
}

