/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.gmap.annotations;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Polyline;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.gmap.utils.GoogleUtils;
import java.util.ArrayList;
import java.util.List;

public class GPolyline
implements DJIPolyline {
    private Polyline mPolyline;

    public GPolyline(@NonNull Polyline polyline) {
        this.mPolyline = polyline;
    }

    @Override
    public void remove() {
        this.mPolyline.remove();
    }

    @Override
    public void setWidth(float width) {
        this.mPolyline.setWidth(width);
    }

    @Override
    public float getWidth() {
        return this.mPolyline.getWidth();
    }

    @Override
    public void setPoints(List<DJILatLng> points) {
        ArrayList<LatLng> gPoints = new ArrayList<LatLng>(points.size());
        for (DJILatLng latLng : points) {
            gPoints.add(GoogleUtils.fromDJILatLng(latLng));
        }
        this.mPolyline.setPoints(gPoints);
    }

    @Override
    public List<DJILatLng> getPoints() {
        ArrayList<DJILatLng> djiPoints = new ArrayList<DJILatLng>(this.mPolyline.getPoints().size());
        for (LatLng latLng : this.mPolyline.getPoints()) {
            djiPoints.add(GoogleUtils.fromLatLng(latLng));
        }
        return djiPoints;
    }

    @Override
    public void setColor(@ColorInt int color2) {
        this.mPolyline.setColor(color2);
    }

    @Override
    @ColorInt
    public int getColor() {
        return this.mPolyline.getColor();
    }

    public DJIPolylineOptions getOptions() {
        DJIPolylineOptions options = new DJIPolylineOptions();
        return options;
    }

    @Override
    public void setZIndex(float zIndex) {
        this.mPolyline.setZIndex(zIndex);
    }

    @Override
    public float getZIndex() {
        return this.mPolyline.getZIndex();
    }

    public void setOptions(DJIPolylineOptions options) {
        List<DJILatLng> latLngs = options.getPoints();
        ArrayList<LatLng> points = new ArrayList<LatLng>(latLngs.size());
        for (DJILatLng latLng : latLngs) {
            points.add(GoogleUtils.fromDJILatLng(latLng));
        }
        this.mPolyline.setPoints(points);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GPolyline gPolyline = (GPolyline)o;
        return this.mPolyline.equals((Object)gPolyline.mPolyline);
    }

    public int hashCode() {
        return this.mPolyline.hashCode();
    }
}

