/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.utils.douglas;

import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.utils.DJIGpsUtils;
import dji.v5.ux.mapkit.core.utils.douglas.LatLngPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DouglasUtils {
    private static final int DEFAULT_THRESHOL = 50;

    private DouglasUtils() {
    }

    public static List<DJILatLng> compress(List<DJILatLng> points, double threshold) {
        int start = 0;
        int end = points.size() - 1;
        int size = points.size();
        ArrayList<LatLngPoint> originPoints = new ArrayList<LatLngPoint>(size);
        for (int i = 0; i < size; ++i) {
            originPoints.add(new LatLngPoint(i, points.get(i)));
        }
        ArrayList<LatLngPoint> lineFilter = new ArrayList<LatLngPoint>();
        List<LatLngPoint> latLngPoints = DouglasUtils.compressLine(originPoints.toArray(new LatLngPoint[size]), lineFilter, start, end, threshold);
        latLngPoints.add((LatLngPoint)originPoints.get(0));
        latLngPoints.add((LatLngPoint)originPoints.get(size - 1));
        Collections.sort(latLngPoints, (o1, o2) -> o1.compareTo((LatLngPoint)o2));
        ArrayList<DJILatLng> latLngs = new ArrayList<DJILatLng>();
        for (LatLngPoint point : latLngPoints) {
            latLngs.add(point.latLng);
        }
        return latLngs;
    }

    public static List<DJILatLng> compress(List<DJILatLng> points) {
        return DouglasUtils.compress(points, 50.0);
    }

    private static List<LatLngPoint> compressLine(LatLngPoint[] originalLatLngs, List<LatLngPoint> finalLatLngs, int start, int end, double dmax) {
        if (start < end) {
            double maxDis = 0.0;
            int currentIndex = 0;
            for (int i = start + 1; i < end; ++i) {
                double currentDist = DouglasUtils.distToSegment(originalLatLngs[start], originalLatLngs[end], originalLatLngs[i]);
                if (!(currentDist > maxDis)) continue;
                maxDis = currentDist;
                currentIndex = i;
            }
            if (maxDis >= dmax) {
                finalLatLngs.add(originalLatLngs[currentIndex]);
                DouglasUtils.compressLine(originalLatLngs, finalLatLngs, start, currentIndex, dmax);
                DouglasUtils.compressLine(originalLatLngs, finalLatLngs, currentIndex, end, dmax);
            }
        }
        return finalLatLngs;
    }

    private static double distToSegment(LatLngPoint start, LatLngPoint end, LatLngPoint mid) {
        double a = Math.abs(DJIGpsUtils.distance(start.latLng, end.latLng));
        double b = Math.abs(DJIGpsUtils.distance(start.latLng, mid.latLng));
        double c = Math.abs(DJIGpsUtils.distance(mid.latLng, end.latLng));
        double p = (a + b + c) / 2.0;
        double s = Math.sqrt(Math.abs(p * (p - a) * (p - b) * (p - c)));
        double d = s * 2.0 / a;
        return d;
    }
}

