/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.manager.aircraft.perception.data.ObstacleAvoidanceType;
import dji.v5.manager.aircraft.perception.data.PerceptionInfo;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.ui.hsi.HSIContract;
import dji.v5.ux.core.ui.hsi.HSIMarkerLayer;
import dji.v5.ux.core.ui.hsi.HSIPerceptionLayer;
import dji.v5.ux.core.ui.hsi.HSIWidgetModel;
import dji.v5.ux.core.ui.hsi.dashboard.FpvStrokeConfig;
import dji.v5.ux.core.util.DrawUtils;
import dji.v5.ux.core.util.MatrixUtils;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.lang.ref.WeakReference;
import java.util.Locale;

public class HSIView
extends View
implements HSIContract.HSIContainer {
    public static final Rect RECT = new Rect();
    public static final Rect RECT2 = new Rect();
    public static final Path mPath = new Path();
    public static final int HSI_VISIBLE_DISTANCE_IN_METERS = 16;
    private static final int MAX_GIMBAL_COUNT = 3;
    public static final int INVALIDATE_INTERVAL_TIME = 200;
    private static final int MSG_INVALIDATE = 1;
    public static final String VIEW_DEBUG_CATEGORY_DJI = "dji";
    public static final String VIEW_DEBUG_PREFIX_MARKER = "hsi_marker_";
    public static final String VIEW_DEBUG_PREFIX_PERCEPTION = "hsi_perception_";
    private static final String APAS_TEXT = "APAS";
    @NonNull
    private final Handler.Callback mCallback = msg -> {
        if (msg.what == 1) {
            this.postInvalidate();
            return true;
        }
        return false;
    };
    @Nullable
    private Handler mHandler;
    @ViewDebug.ExportedProperty(category="hsi")
    private float mCurrentDegree;
    private String mCurrentDegreeText;
    private boolean[] mGimbalConnected = new boolean[3];
    private float[] mGimbalCurrentDegree = new float[3];
    private boolean mIsRadarConnected;
    private boolean mIsRadarAvailable;
    private boolean isHideGimbalDrawable = false;
    private float mAircraftHeadingOffsetDistanceX;
    private float mAircraftHeadingOffsetDistanceY;
    @ViewDebug.ExportedProperty(category="hsi")
    private final int mGimbalIndicatorMaxScope;
    @ViewDebug.ExportedProperty(category="hsi")
    private final int mAircraftIndicatorSize;
    @ViewDebug.ExportedProperty(category="hsi")
    private final int mDegreeIndicatorTextSize;
    @ViewDebug.ExportedProperty(category="hsi")
    private final int mDegreeIndicatorTextHeight;
    @ViewDebug.ExportedProperty(category="hsi")
    private final int mCompassMargin;
    @ViewDebug.ExportedProperty(category="hsi")
    private final int mDegreeIndicatorHeight;
    @ViewDebug.ExportedProperty(category="hsi")
    private final float mDegreeIndicatorHeightInCompass;
    @ViewDebug.ExportedProperty(category="hsi")
    private final float mDegreeIndicatorWidth;
    @ViewDebug.ExportedProperty(category="hsi", formatToHexString=true)
    private final int mDegreeIndicatorColor;
    @ViewDebug.ExportedProperty(category="hsi")
    private final int mHeadingLineWidth;
    @ViewDebug.ExportedProperty(category="hsi")
    private float mYaw;
    @ViewDebug.ExportedProperty(category="hsi", formatToHexString=true)
    private float mRoll;
    @ViewDebug.ExportedProperty(category="hsi", formatToHexString=true)
    private float mPitch;
    @ViewDebug.ExportedProperty(category="hsi", formatToHexString=true)
    private float mSpeedX;
    @ViewDebug.ExportedProperty(category="hsi", formatToHexString=true)
    private float mSpeedY;
    @ViewDebug.ExportedProperty(category="hsi", formatToHexString=true)
    private float mSpeedZ;
    private final int mBitmapOffset;
    @NonNull
    private final Paint mPaint;
    @Nullable
    private final Bitmap mCompassBitmap;
    @NonNull
    private final Bitmap mAircraftBitmap;
    @NonNull
    private final Bitmap mRadarAvailableBitmap;
    @NonNull
    private final Bitmap mRadarUnavailableBitmap;
    @NonNull
    private final GradientDrawable mAircraftHeadingLineDrawable;
    @ViewDebug.ExportedProperty(category="dji", prefix="hsi_marker_", deepExport=true)
    @NonNull
    private final HSIContract.HSILayer mMarkerLayer;
    @ViewDebug.ExportedProperty(category="dji", prefix="hsi_perception_", deepExport=true)
    @NonNull
    private final HSIContract.HSILayer mPerceptionLayer;
    FpvStrokeConfig mStrokeConfig;
    private boolean isApasMode = false;
    private float mApasTextLength = 0.0f;
    private float mApasTextHeight = 0.0f;
    private float mApasTextSize = AndUtil.getDimension((int)R.dimen.uxsdk_6_dp);
    private float mApasTextStrokeWith = AndUtil.getDimension((int)R.dimen.uxsdk_1_dp);
    private int mApasTextColor = AndUtil.getResColor((int)R.color.uxsdk_white);
    private int mApasTextStrokeColor = AndUtil.getResColor((int)R.color.uxsdk_black_60_percent);
    @Nullable
    private Disposable mDisposable;
    private HSIWidgetModel widgetModel;
    @Nullable
    private OnAircraftAttitudeChangeListener mListener;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();

    public HSIView(Context context) {
        this(context, null);
    }

    public HSIView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HSIView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.widgetModel = new HSIWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.HSIView);
        this.mBitmapOffset = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_bitmap_offset, 0);
        this.mAircraftIndicatorSize = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_aircraft_indicator_size, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_10_dp));
        this.mGimbalIndicatorMaxScope = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_gimbal_indicator_max_scope, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_10_dp));
        this.mDegreeIndicatorHeight = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_degree_indicator_width, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_5_dp));
        this.mDegreeIndicatorTextSize = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_degree_indicator_text_size, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_text_size_normal));
        this.mDegreeIndicatorTextHeight = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_degree_indicator_height, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_11_dp));
        this.mCompassMargin = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_compass_margin, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_5_dp));
        this.mDegreeIndicatorColor = typedArray.getColor(R.styleable.HSIView_uxsdk_hsi_degree_indicator_color, this.getResources().getColor(R.color.uxsdk_green_in_dark));
        this.mAircraftHeadingOffsetDistanceX = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_aircraft_heading_offset_x, 0);
        this.mAircraftHeadingOffsetDistanceY = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_aircraft_heading_offset_y, 0);
        this.mHeadingLineWidth = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_heading_line_width, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_1_dp));
        typedArray.recycle();
        this.mDegreeIndicatorHeightInCompass = this.getResources().getDimension(R.dimen.uxsdk_1_dp);
        this.mDegreeIndicatorWidth = DisplayUtil.dip2px((Context)context, (float)1.4f);
        this.mPaint = new Paint(5);
        this.mPaint.setStrokeWidth((float)this.getResources().getDimensionPixelSize(R.dimen.uxsdk_1_dp));
        Typeface typeface = Typeface.create((String)"sans-serif-condensed", (int)1);
        this.mPaint.setTypeface(typeface);
        this.mCompassBitmap = this.getBitmap(R.drawable.uxsdk_fpv_hsi_compass_list);
        this.mAircraftBitmap = this.getBitmap(R.drawable.uxsdk_fpv_hsi_aircraft);
        this.mRadarAvailableBitmap = this.getBitmap(R.drawable.uxsdk_hsi_aircraft_radar_normal);
        this.mRadarUnavailableBitmap = this.getBitmap(R.drawable.uxsdk_hsi_aircraft_radar_disable);
        this.mAircraftHeadingLineDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{this.getResources().getColor(R.color.uxsdk_white_30_percent), this.getResources().getColor(R.color.uxsdk_white)});
        this.mAircraftHeadingLineDrawable.setGradientType(0);
        this.mAircraftHeadingLineDrawable.setShape(0);
        this.mAircraftHeadingLineDrawable.setCornerRadius((float)this.getResources().getDimensionPixelSize(R.dimen.uxsdk_1_dp));
        this.mMarkerLayer = new HSIMarkerLayer(context, attrs, this, this.widgetModel);
        this.mPerceptionLayer = new HSIPerceptionLayer(context, attrs, this, this.widgetModel);
        this.mStrokeConfig = new FpvStrokeConfig(this.getContext());
        this.initApasParam();
    }

    private void initApasParam() {
        this.mPaint.setTextSize(this.getContext().getResources().getDimension(R.dimen.uxsdk_6_dp));
        this.mApasTextLength = this.mPaint.measureText(APAS_TEXT);
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        this.mApasTextHeight = fontMetrics.bottom - fontMetrics.top;
    }

    private Bitmap getBitmap(int resId) {
        if (this.isInEditMode()) {
            return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return DrawUtils.drawableRes2Bitmap(resId);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        this.widgetModel.setup();
        this.mHandler = new Handler(Looper.getMainLooper(), this.mCallback);
        this.mMarkerLayer.onStart();
        this.mPerceptionLayer.onStart();
        this.mCompositeDisposable.add(this.widgetModel.getProductTypeDataProcessor().toFlowable().subscribe(productType -> {
            this.isHideGimbalDrawable = productType == ProductType.DJI_MAVIC_3_ENTERPRISE_SERIES;
        }));
        this.mCompositeDisposable.add(this.widgetModel.getRadarInformationDataProcessor().toFlowable().subscribe(info -> {
            this.mIsRadarConnected = info.isConnected();
            this.mIsRadarAvailable = info.isHorizontalObstacleAvoidanceEnabled();
            this.updateWidget();
        }));
        this.mCompositeDisposable.add(this.widgetModel.getPerceptionInformationDataProcessor().toFlowable().subscribe((Consumer)new Consumer<PerceptionInfo>(){

            public void accept(PerceptionInfo info) throws Throwable {
                HSIView.this.isApasMode = info.getObstacleAvoidanceType() == ObstacleAvoidanceType.BYPASS;
            }
        }));
        this.mDisposable = Observable.create((ObservableOnSubscribe)new ObservableSource(this)).observeOn(Schedulers.computation()).map(data -> HSIView.updateSpeedVectorMark(data[0], data[1], data[2], data[3], data[4], data[5])).observeOn(AndroidSchedulers.mainThread()).subscribe(p -> {
            this.mAircraftHeadingOffsetDistanceX = p[0];
            this.mAircraftHeadingOffsetDistanceY = p[1];
            this.updateWidget();
        });
        this.mCompositeDisposable.add(this.widgetModel.getVelocityProcessor().toFlowable().subscribe(velocity3D -> {
            this.mSpeedX = velocity3D.getX().floatValue();
            this.mSpeedY = velocity3D.getY().floatValue();
            this.mSpeedZ = velocity3D.getZ().floatValue();
            this.recalculateAndInvalidate();
        }));
        this.mCompositeDisposable.add(this.widgetModel.getAircraftAttitudeProcessor().toFlowable().subscribe(attitude -> {
            this.mYaw = attitude.getYaw().floatValue();
            this.mCurrentDegree = this.mYaw + (this.mYaw < 0.0f ? 359.0f : 0.0f);
            this.mCurrentDegreeText = String.format(Locale.ENGLISH, "%03.0f", Float.valueOf(this.mCurrentDegree));
            this.mRoll = attitude.getRoll().floatValue();
            this.mPitch = attitude.getPitch().floatValue();
            this.recalculateAndInvalidate();
        }));
        this.mCompositeDisposable.add(Flowable.fromArray((Object[])new Integer[]{0, 1, 2}).flatMap(cameraIndex -> Flowable.combineLatest(this.widgetModel.getGimbalConnectionProcessorList().get((int)cameraIndex).toFlowable(), this.widgetModel.getGimbalYawInDegreesProcessorList().get((int)cameraIndex).toFlowable(), (isConnected, yaw) -> {
            this.mGimbalConnected[cameraIndex.intValue()] = isConnected;
            this.mGimbalCurrentDegree[cameraIndex.intValue()] = yaw.floatValue();
            return true;
        })).subscribeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> this.updateWidget()));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mMarkerLayer.onStop();
        this.mPerceptionLayer.onStop();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
        }
        this.mCompositeDisposable.dispose();
        this.widgetModel.cleanup();
    }

    public void enterFpvMode(boolean fpv) {
        this.mMarkerLayer.enterFpvMode(fpv);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.translate((float)this.getWidth() / 2.0f, 0.0f);
        int textHeight = this.mDegreeIndicatorTextHeight;
        int compassHeight = this.getHeight() - textHeight - this.mCompassMargin * 2;
        int compassWidth = this.getWidth() - this.mCompassMargin * 2;
        int compassSize = Math.min(compassWidth, compassHeight);
        this.drawDegreeIndicator(canvas);
        int compassStartY = textHeight + this.mCompassMargin;
        canvas.translate(0.0f, (float)compassStartY);
        this.drawCompass(canvas, compassSize);
        this.drawDegreeLine(canvas);
        this.drawGimbalIndicators(canvas, compassSize);
        this.drawAircraftHeadingLine(canvas, compassSize, this.mAircraftHeadingOffsetDistanceX, this.mAircraftHeadingOffsetDistanceY);
        this.drawAircraftIndicator(canvas, compassSize);
        this.drawApasModeText(canvas, compassSize);
        this.mPerceptionLayer.draw(canvas, this.mPaint, compassSize);
        this.mMarkerLayer.draw(canvas, this.mPaint, compassSize);
    }

    private void drawDegreeLine(Canvas canvas) {
        this.mPaint.setColor(this.getResources().getColor(R.color.uxsdk_green_in_dark));
        float width = this.mDegreeIndicatorWidth;
        this.mPaint.setStrokeWidth(width);
        this.mPaint.setStyle(Paint.Style.FILL);
        float top = (float)(-this.mDegreeIndicatorHeight) + this.mDegreeIndicatorHeightInCompass;
        canvas.drawLine(0.0f, top, 0.0f, (float)this.mDegreeIndicatorHeight + top, this.mPaint);
        float strokeWidth = this.mStrokeConfig.getStrokeThinWidth();
        this.mPaint.setStrokeWidth(strokeWidth);
        this.mPaint.setColor(this.mStrokeConfig.getStrokeShallowColor());
        this.mPaint.setStyle(Paint.Style.STROKE);
        float halfWidth = width / 2.0f;
        float halfStrokeWidth = strokeWidth / 2.0f;
        float bottom = top + (float)this.mDegreeIndicatorHeight + halfStrokeWidth;
        canvas.drawRect(-halfWidth - halfStrokeWidth, top - halfStrokeWidth, halfStrokeWidth + halfWidth, bottom, this.mPaint);
    }

    private void drawDegreeIndicator(Canvas canvas) {
        if (this.mCurrentDegreeText == null) {
            return;
        }
        canvas.save();
        this.mPaint.setTextSize((float)this.mDegreeIndicatorTextSize);
        String degree = this.mCurrentDegreeText;
        this.mPaint.getTextBounds(degree, 0, degree.length(), RECT);
        Paint.FontMetricsInt fontMetrics = this.mPaint.getFontMetricsInt();
        float baseline = (float)(this.mDegreeIndicatorTextHeight - fontMetrics.bottom + fontMetrics.top) / 2.0f - (float)fontMetrics.top;
        this.mPaint.setTextAlign(Paint.Align.LEFT);
        this.drawTextWithStroke(canvas, degree, -((float)RECT.width()) / 2.0f, baseline, this.mStrokeConfig.getStrokeBoldWidth(), this.mStrokeConfig.getStrokeDeepColor(), this.mDegreeIndicatorColor);
        canvas.restore();
    }

    private void drawCompass(Canvas canvas, int compassSize) {
        if (this.mCompassBitmap == null) {
            return;
        }
        int flag = this.mPaint.getFlags();
        this.mPaint.setFlags(flag | 2);
        canvas.save();
        canvas.translate((float)(-compassSize) / 2.0f, 0.0f);
        RECT.set(0, 0, this.mCompassBitmap.getWidth(), this.mCompassBitmap.getHeight());
        RECT2.set(0, 0, compassSize, compassSize);
        canvas.save();
        canvas.translate((float)compassSize / 2.0f, (float)compassSize / 2.0f);
        canvas.rotate(-this.mCurrentDegree);
        canvas.translate((float)(-compassSize) / 2.0f, (float)(-compassSize) / 2.0f);
        canvas.drawBitmap(this.mCompassBitmap, RECT, RECT2, this.mPaint);
        canvas.restore();
        this.mPaint.setFlags(flag);
        canvas.restore();
    }

    private void drawAircraftIndicator(Canvas canvas, int compassSize) {
        canvas.save();
        canvas.translate(-((float)compassSize) / 2.0f, 0.0f);
        Bitmap marker = this.mAircraftBitmap;
        if (this.mIsRadarConnected) {
            marker = this.mIsRadarAvailable ? this.mRadarAvailableBitmap : this.mRadarUnavailableBitmap;
        }
        this.drawMarker(canvas, marker, this.mAircraftIndicatorSize, this.mAircraftIndicatorSize, (float)compassSize / 2.0f, (float)compassSize / 2.0f, this.mPaint);
        canvas.restore();
    }

    private void drawApasModeText(Canvas canvas, int compassSize) {
        if (!this.isApasMode) {
            return;
        }
        this.mPaint.setColor(this.mApasTextStrokeColor);
        this.mPaint.setTextSize(this.mApasTextSize);
        this.mPaint.setStrokeWidth(this.mApasTextStrokeWith);
        float offX = -this.mApasTextLength / 2.0f;
        float offY = (float)compassSize / 2.0f + (float)this.mAircraftIndicatorSize / 2.0f + this.mApasTextHeight;
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.drawText(APAS_TEXT, offX, offY, this.mPaint);
        this.mPaint.setColor(this.mApasTextColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawText(APAS_TEXT, offX, offY, this.mPaint);
    }

    private void drawGimbalIndicators(Canvas canvas, int compassSize) {
        if (this.isHideGimbalDrawable) {
            return;
        }
        canvas.save();
        canvas.translate(0.0f, 0.0f);
        Drawable drawable2 = DrawUtils.getDrawable(R.drawable.uxsdk_fpv_hsi_outer_guide_gimbal_3);
        float gimbalPadding = (float)(this.mGimbalIndicatorMaxScope - drawable2.getMinimumHeight()) / 2.0f;
        this.drawEachGimbalIndicator(canvas, this.getGimbalYawDegreeWithAircraft(this.mGimbalCurrentDegree[0], this.mYaw), this.mGimbalConnected[0], (float)compassSize / 2.0f, this.mBitmapOffset, R.drawable.uxsdk_fpv_hsi_outer_guide_gimbal_3);
        this.drawEachGimbalIndicator(canvas, this.getGimbalYawDegreeWithAircraft(this.mGimbalCurrentDegree[1], this.mYaw), this.mGimbalConnected[1], (float)compassSize / 2.0f, (float)this.mBitmapOffset + gimbalPadding, R.drawable.uxsdk_fpv_hsi_outer_guide_gimbal_1);
        this.drawEachGimbalIndicator(canvas, this.getGimbalYawDegreeWithAircraft(this.mGimbalCurrentDegree[2], this.mYaw), this.mGimbalConnected[2], (float)compassSize / 2.0f, (float)this.mBitmapOffset + gimbalPadding * 2.0f, R.drawable.uxsdk_fpv_hsi_outer_guide_gimbal_2);
        canvas.restore();
    }

    private float getGimbalYawDegreeWithAircraft(float gimbalYaw, float aircraftYaw) {
        return gimbalYaw - aircraftYaw;
    }

    private void drawEachGimbalIndicator(Canvas canvas, float yawDegree, boolean isConnected, float centerY, float offsetY, int gimbalDrawable) {
        if (this.isInEditMode() || isConnected) {
            canvas.save();
            canvas.translate(0.0f, centerY);
            canvas.rotate(yawDegree);
            Drawable drawable2 = DrawUtils.getDrawable(gimbalDrawable);
            int width = drawable2.getMinimumWidth();
            int height = drawable2.getMinimumHeight();
            float halfWidth = (float)width / 2.0f;
            canvas.translate(-halfWidth, offsetY - centerY);
            drawable2.setBounds(0, 0, width, height);
            drawable2.draw(canvas);
            canvas.restore();
        }
    }

    private void drawAircraftHeadingLine(Canvas canvas, int compassSize, float distanceX, float distanceY) {
        double atan;
        float angle;
        canvas.save();
        int radius = compassSize / 2 - this.mGimbalIndicatorMaxScope - this.mBitmapOffset;
        float offsetX = distanceX / 16.0f * (float)radius;
        float offsetY = distanceY / 16.0f * (float)radius;
        int lineHeight = (int)Math.sqrt(Math.pow(offsetX, 2.0) + Math.pow(offsetY, 2.0));
        if (lineHeight > radius) {
            lineHeight = radius;
        }
        if (!Float.isNaN(angle = (float)((atan = Math.atan(offsetY / offsetX)) * 180.0 / Math.PI)) && distanceX < 0.0f) {
            angle += 180.0f;
        }
        canvas.translate(0.0f, (float)compassSize / 2.0f);
        canvas.rotate(angle);
        this.mPaint.setColor(-1);
        this.mPaint.setStrokeWidth((float)this.mHeadingLineWidth);
        canvas.drawLine(0.0f, (float)(-lineHeight), 0.0f, 0.0f, this.mPaint);
        canvas.restore();
    }

    private void drawMarker(Canvas canvas, Bitmap marker, int markerWidth, int markerHeight, float offsetMiddleX, float offsetMiddleY, Paint paint) {
        int flag = paint.getFlags();
        paint.setFlags(flag | 2);
        canvas.save();
        canvas.translate(offsetMiddleX - (float)markerWidth / 2.0f, offsetMiddleY - (float)markerHeight / 2.0f);
        RECT.set(0, 0, marker.getWidth(), marker.getHeight());
        RECT2.set(0, 0, markerWidth, markerHeight);
        canvas.drawBitmap(marker, RECT, RECT2, paint);
        canvas.restore();
        paint.setFlags(flag);
    }

    protected void drawTextWithStroke(Canvas canvas, String currentValueString, float textOffset, float baseline, float strokeWidth, int strokeColor, int textColor) {
        this.mPaint.setStrokeWidth(strokeWidth);
        this.mPaint.setColor(strokeColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.drawText(currentValueString, textOffset, baseline, this.mPaint);
        this.mPaint.setColor(textColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawText(currentValueString, textOffset, baseline, this.mPaint);
    }

    private void setListener(@Nullable OnAircraftAttitudeChangeListener listener2) {
        this.mListener = listener2;
    }

    private void recalculateAndInvalidate() {
        if (this.mListener != null) {
            this.mListener.onAttitudeChanged(this.mPitch, this.mYaw, this.mRoll, this.mSpeedX, this.mSpeedY, this.mSpeedZ);
        }
    }

    @Override
    public float getCurrentDegree() {
        return this.mCurrentDegree;
    }

    @Override
    public int getAircraftSize() {
        return this.mAircraftIndicatorSize;
    }

    @Override
    public int getVisibleDistanceInHsiInMeters() {
        return 16;
    }

    @Override
    public float getCalibrationAreaWidth() {
        return this.mGimbalIndicatorMaxScope;
    }

    @Override
    public float getDegreeIndicatorHeight() {
        return this.mDegreeIndicatorHeight;
    }

    @Override
    public float getCompassBitmapOffset() {
        return this.mBitmapOffset;
    }

    @Override
    public void updateWidget() {
        if (this.mHandler != null && !this.mHandler.hasMessages(1)) {
            this.mHandler.sendEmptyMessageDelayed(1, 200L);
        }
    }

    @Override
    public View getView() {
        return this;
    }

    @NonNull
    private static float[] updateSpeedVectorMark(float pitch, float yaw, float roll, float speedX, float speedY, float speedZ) {
        float[] i2gMat = MatrixUtils.createRotationMatrix(yaw, pitch, roll);
        float[] g2iMat = MatrixUtils.transposeMatrix(i2gMat);
        float[] speedVector = new float[]{speedX, speedY, speedZ};
        float[] vi = MatrixUtils.rotateVector(speedVector, g2iMat);
        return MatrixUtils.multiple(vi, 2.0f);
    }

    private static final class ObservableSource
    implements ObservableOnSubscribe<float[]> {
        private final WeakReference<HSIView> mReference;

        public ObservableSource(HSIView view) {
            this.mReference = new WeakReference<HSIView>(view);
        }

        public void subscribe(ObservableEmitter<float[]> e) throws Exception {
            HSIView view = (HSIView)this.mReference.get();
            if (view == null) {
                return;
            }
            OnAircraftAttitudeChangeListener listener2 = (pitch, yaw, roll, speedX, speedY, speedZ) -> {
                if (!e.isDisposed()) {
                    e.onNext((Object)new float[]{pitch, yaw, roll, speedX, speedY, speedZ});
                }
            };
            e.setCancellable(() -> view.setListener(null));
            view.setListener(listener2);
        }
    }

    private static interface OnAircraftAttitudeChangeListener {
        public void onAttitudeChanged(float var1, float var2, float var3, float var4, float var5, float var6);
    }
}

