/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.charts.model;

import dji.v5.ux.core.base.charts.model.ValueShape;
import dji.v5.ux.core.base.charts.util.ChartUtils;
import java.util.Arrays;

public class BubbleValue {
    private float x;
    private float y;
    private float z;
    private float originX;
    private float originY;
    private float originZ;
    private float diffX;
    private float diffY;
    private float diffZ;
    private int color = ChartUtils.DEFAULT_COLOR;
    private int darkenColor = ChartUtils.DEFAULT_DARKEN_COLOR;
    private ValueShape shape = ValueShape.CIRCLE;
    private char[] label;

    public BubbleValue() {
        this.set(0.0f, 0.0f, 0.0f);
    }

    public BubbleValue(float x, float y, float z) {
        this.set(x, y, z);
    }

    public BubbleValue(float x, float y, float z, int color2) {
        this.set(x, y, z);
        this.setColor(color2);
    }

    public BubbleValue(BubbleValue bubbleValue) {
        this.set(bubbleValue.x, bubbleValue.y, bubbleValue.z);
        this.setColor(bubbleValue.color);
        this.label = bubbleValue.label;
    }

    public void update(float scale) {
        this.x = this.originX + this.diffX * scale;
        this.y = this.originY + this.diffY * scale;
        this.z = this.originZ + this.diffZ * scale;
    }

    public void finish() {
        this.set(this.originX + this.diffX, this.originY + this.diffY, this.originZ + this.diffZ);
    }

    public BubbleValue set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.diffX = 0.0f;
        this.diffY = 0.0f;
        this.diffZ = 0.0f;
        return this;
    }

    public BubbleValue setTarget(float targetX, float targetY, float targetZ) {
        this.set(this.x, this.y, this.z);
        this.diffX = targetX - this.originX;
        this.diffY = targetY - this.originY;
        this.diffZ = targetZ - this.originZ;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public int getColor() {
        return this.color;
    }

    public BubbleValue setColor(int color2) {
        this.color = color2;
        this.darkenColor = ChartUtils.darkenColor(color2);
        return this;
    }

    public int getDarkenColor() {
        return this.darkenColor;
    }

    public ValueShape getShape() {
        return this.shape;
    }

    public BubbleValue setShape(ValueShape shape) {
        this.shape = shape;
        return this;
    }

    @Deprecated
    public char[] getLabel() {
        return this.label;
    }

    public BubbleValue setLabel(String label) {
        this.label = label.toCharArray();
        return this;
    }

    public char[] getLabelAsChars() {
        return this.label;
    }

    @Deprecated
    public BubbleValue setLabel(char[] label) {
        this.label = label;
        return this;
    }

    public String toString() {
        return "BubbleValue [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BubbleValue that = (BubbleValue)o;
            if (this.color != that.color) {
                return false;
            }
            if (this.darkenColor != that.darkenColor) {
                return false;
            }
            if (Float.compare(that.diffX, this.diffX) != 0) {
                return false;
            }
            if (Float.compare(that.diffY, this.diffY) != 0) {
                return false;
            }
            if (Float.compare(that.diffZ, this.diffZ) != 0) {
                return false;
            }
            if (Float.compare(that.originX, this.originX) != 0) {
                return false;
            }
            if (Float.compare(that.originY, this.originY) != 0) {
                return false;
            }
            if (Float.compare(that.originZ, this.originZ) != 0) {
                return false;
            }
            if (Float.compare(that.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(that.y, this.y) != 0) {
                return false;
            }
            if (Float.compare(that.z, this.z) != 0) {
                return false;
            }
            if (!Arrays.equals(this.label, that.label)) {
                return false;
            }
            return this.shape == that.shape;
        }
        return false;
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
        result = 31 * result + (this.originX != 0.0f ? Float.floatToIntBits(this.originX) : 0);
        result = 31 * result + (this.originY != 0.0f ? Float.floatToIntBits(this.originY) : 0);
        result = 31 * result + (this.originZ != 0.0f ? Float.floatToIntBits(this.originZ) : 0);
        result = 31 * result + (this.diffX != 0.0f ? Float.floatToIntBits(this.diffX) : 0);
        result = 31 * result + (this.diffY != 0.0f ? Float.floatToIntBits(this.diffY) : 0);
        result = 31 * result + (this.diffZ != 0.0f ? Float.floatToIntBits(this.diffZ) : 0);
        result = 31 * result + this.color;
        result = 31 * result + this.darkenColor;
        result = 31 * result + (this.shape != null ? this.shape.hashCode() : 0);
        result = 31 * result + (this.label != null ? Arrays.hashCode(this.label) : 0);
        return result;
    }
}

