/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.remotecontroller;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.remotecontroller.RcCalibrateState;
import dji.v5.common.utils.RxUtil;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.LogPath;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.remotecontroller.calibration.SmartControllerCalibrationInfo;
import dji.v5.ux.remotecontroller.calibration.stick.StickState;
import dji.v5.ux.remotecontroller.calibration.stick.StickValue;
import io.reactivex.rxjava3.core.Flowable;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public class RcCalibrationWidgetModel
extends WidgetModel {
    protected boolean isStart = false;
    public DataProcessor<RcCalibrateState> rcCalibrateStateDataProcessor = DataProcessor.create(RcCalibrateState.UNKNOWN);
    public DataProcessor<SmartControllerCalibrationInfo> calibrationInfoDataProcessor = DataProcessor.create(new SmartControllerCalibrationInfo());
    public DataProcessor<Boolean> connectDataProcessor = DataProcessor.create(false);
    public DataProcessor<Boolean> isCalibrateStartProcessor = DataProcessor.create(false);
    public DataProcessor<StickState> stickStateDataProcessor = DataProcessor.create(new StickState());
    public DataProcessor<StickValue> leftStickValueDataProcessor = DataProcessor.create(new StickValue());
    public DataProcessor<StickValue> rightStickValueDataProcessor = DataProcessor.create(new StickValue());
    protected RcCalibrateState rcMode = RcCalibrateState.UNKNOWN;

    public RcCalibrationWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyConnection, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.connectDataProcessor);
        this.addDisposable(Flowable.combineLatest((Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyConnection, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyLeftDial), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRightDial), (Object)this), (connect, leftGyroValue, rightGyroValue) -> new SmartControllerCalibrationInfo((boolean)connect, this.rcCalibrateStateDataProcessor.getValue(), (int)leftGyroValue, (int)rightGyroValue)).subscribe(smartControllerCalibrationInfo -> {
            if (smartControllerCalibrationInfo != null) {
                this.calibrationInfoDataProcessor.onNext((SmartControllerCalibrationInfo)smartControllerCalibrationInfo);
            }
        }));
        this.addDisposable(Flowable.combineLatest((Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateNumberOfSegment), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateAAxisStatus), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateBAxisStatus), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateCAxisStatus), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateDAxisStatus), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateEAxisStatus), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateFAxisStatus), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateGAxisStatus), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcCalibrateHAxisStatus), (Object)this), (segmentNum, aAxis, bAxis, cAxis, dAxis, eAxis, fAxis, gAxis, hAxis) -> {
            StickState state = new StickState();
            state.calibrationState = this.rcCalibrateStateDataProcessor.getValue();
            state.isConnection = this.connectDataProcessor.getValue();
            state.segmentNum = segmentNum;
            state.rightTop = aAxis;
            state.rightBottom = bAxis;
            state.rightRight = cAxis;
            state.rightLeft = dAxis;
            state.leftTop = eAxis;
            state.leftBottom = fAxis;
            state.leftRight = gAxis;
            state.leftLeft = hAxis;
            return state;
        }).subscribe(stickState -> {
            if (stickState != null) {
                this.stickStateDataProcessor.onNext((StickState)stickState);
            }
        }));
        this.addDisposable(Flowable.combineLatest((Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyStickLeftVertical), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyStickLeftHorizontal), (Object)this), StickValue::new).subscribe(stickValue -> this.leftStickValueDataProcessor.onNext((StickValue)stickValue)));
        this.addDisposable(Flowable.combineLatest((Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyStickRightVertical), (Object)this), (Publisher)RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyStickRightHorizontal), (Object)this), StickValue::new).subscribe(stickValue -> this.rightStickValueDataProcessor.onNext((StickValue)stickValue)));
    }

    @Override
    protected void inCleanup() {
        KeyManager.getInstance().cancelListen((Object)this);
    }

    public void setRcCalibrateChannels(RcCalibrateState rcCalibrateState, boolean isDelay) {
        this.addDisposable(RxUtil.performActionSingWithResult((DJIKey.ActionKey)KeyTools.createKey((DJIActionKeyInfo)RemoteControllerKey.KeyRcCalibrateChannels), (Object)rcCalibrateState).delay(isDelay ? 500L : 0L, TimeUnit.MILLISECONDS).subscribe(rcCalibrateState1 -> {
            if (rcCalibrateState1 != null) {
                this.updateRcMode((RcCalibrateState)rcCalibrateState1);
            } else {
                this.doNext(true);
            }
        }, throwable -> LogUtils.e((LogPath)LogPath.COMMON, (Object[])new Object[]{throwable.getMessage()})));
    }

    public void startCalibration() {
        this.doNext(false);
    }

    public void finishCalibration() {
        if (this.rcMode == RcCalibrateState.EXIT) {
            this.doNext(false);
        }
    }

    private void doNext(boolean isAuto) {
        LogUtils.d((String)this.tag, (Object[])new Object[]{"doNext with Mode = " + this.rcMode + "\uff0cisAuto=" + isAuto});
        if (this.rcMode == RcCalibrateState.UNKNOWN) {
            if (!isAuto) {
                this.isStart = true;
                this.setRcCalibrateChannels(RcCalibrateState.NORMAL, false);
            }
        } else if (this.rcMode == RcCalibrateState.NORMAL) {
            if (this.isStart) {
                this.setRcCalibrateChannels(RcCalibrateState.RECORDCENTER, false);
            } else {
                this.rcMode = RcCalibrateState.UNKNOWN;
            }
        } else if (this.rcMode == RcCalibrateState.RECORDCENTER) {
            this.isStart = false;
            this.setRcCalibrateChannels(RcCalibrateState.LIMITVALUE, true);
        } else if (this.rcMode == RcCalibrateState.LIMITVALUE) {
            this.setRcCalibrateChannels(RcCalibrateState.LIMITVALUE, true);
        } else if (this.rcMode == RcCalibrateState.EXIT) {
            if (!isAuto) {
                this.setRcCalibrateChannels(RcCalibrateState.EXIT, false);
            } else {
                this.setRcCalibrateChannels(RcCalibrateState.EXIT, true);
            }
        }
        LogUtils.d((String)this.tag, (Object[])new Object[]{"doNext finish\uff0c Mode = " + this.rcMode});
        if (this.isCalibrateStartProcessor.getValue() != this.isStart) {
            this.isCalibrateStartProcessor.onNext(this.isStart);
        }
    }

    protected void updateRcMode(RcCalibrateState mode) {
        RcCalibrateState prevMode = this.rcMode;
        this.rcMode = mode;
        if (prevMode == this.rcMode || this.rcMode == RcCalibrateState.LIMITVALUE || prevMode == RcCalibrateState.NORMAL && this.rcMode == RcCalibrateState.RECORDCENTER || prevMode == RcCalibrateState.EXIT && this.rcMode == RcCalibrateState.NORMAL || this.isStart) {
            this.doNext(true);
        }
        if (this.rcMode != prevMode) {
            this.rcCalibrateStateDataProcessor.onNext(this.rcMode);
        }
    }
}

