/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.training.simulatorcontrol.preset;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import dji.v5.ux.R;
import dji.v5.ux.training.simulatorcontrol.preset.OnLoadPresetListener;
import dji.v5.ux.training.simulatorcontrol.preset.SimulatorPresetData;
import dji.v5.ux.training.util.SimulatorPresetUtils;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0012\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldji/v5/ux/training/simulatorcontrol/preset/PresetListDialog;", "Landroid/app/Dialog;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "loadPresetListener", "Ldji/v5/ux/training/simulatorcontrol/preset/OnLoadPresetListener;", "dialogHeight", "", "<init>", "(Landroid/content/Context;Ldji/v5/ux/training/simulatorcontrol/preset/OnLoadPresetListener;I)V", "presetListContainerLinearLayout", "Landroid/widget/LinearLayout;", "emptyPresetListTextView", "Landroid/widget/TextView;", "confirmDeleteTextView", "cancelDialogTextView", "deletePresetYesTextView", "deletePresetNoTextView", "keyToDelete", "", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onClick", "v", "Landroid/view/View;", "populatePresetList", "resetListUI", "deletePreset", "showDeleteConfirmation", "key", "sendPresetEvent", "data", "insertView", "value", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nPresetListDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PresetListDialog.kt\ndji/v5/ux/training/simulatorcontrol/preset/PresetListDialog\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,183:1\n37#2,2:184\n*S KotlinDebug\n*F\n+ 1 PresetListDialog.kt\ndji/v5/ux/training/simulatorcontrol/preset/PresetListDialog\n*L\n153#1:184,2\n*E\n"})
public final class PresetListDialog
extends Dialog
implements View.OnClickListener {
    @NotNull
    private final OnLoadPresetListener loadPresetListener;
    private final int dialogHeight;
    @NotNull
    private final LinearLayout presetListContainerLinearLayout;
    @NotNull
    private final TextView emptyPresetListTextView;
    @NotNull
    private final TextView confirmDeleteTextView;
    @NotNull
    private final TextView cancelDialogTextView;
    @NotNull
    private final TextView deletePresetYesTextView;
    @NotNull
    private final TextView deletePresetNoTextView;
    @Nullable
    private String keyToDelete;

    @JvmOverloads
    public PresetListDialog(@NotNull Context context, @NotNull OnLoadPresetListener loadPresetListener, int dialogHeight) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)loadPresetListener, (String)"loadPresetListener");
        super(context);
        this.loadPresetListener = loadPresetListener;
        this.dialogHeight = dialogHeight;
        this.setContentView(R.layout.uxsdk_dialog_simulator_load_preset);
        this.presetListContainerLinearLayout = (LinearLayout)this.findViewById(R.id.linear_layout_preset_list_container);
        this.emptyPresetListTextView = (TextView)this.findViewById(R.id.textview_empty_list);
        this.confirmDeleteTextView = (TextView)this.findViewById(R.id.textview_confirmation_delete);
        this.cancelDialogTextView = (TextView)this.findViewById(R.id.textview_cancel_simulator_dialog);
        this.deletePresetYesTextView = (TextView)this.findViewById(R.id.textview_delete_yes);
        this.deletePresetNoTextView = (TextView)this.findViewById(R.id.textview_delete_no);
        this.cancelDialogTextView.setOnClickListener((View.OnClickListener)this);
        this.deletePresetYesTextView.setOnClickListener((View.OnClickListener)this);
        this.deletePresetNoTextView.setOnClickListener((View.OnClickListener)this);
        this.resetListUI();
        this.setCancelable(true);
    }

    public /* synthetic */ PresetListDialog(Context context, OnLoadPresetListener onLoadPresetListener, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = (int)context.getResources().getDimension(R.dimen.uxsdk_simulator_dialog_height);
        }
        this(context, onLoadPresetListener, n);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        block0: {
            super.onCreate(savedInstanceState);
            Window window = this.getWindow();
            if (window == null) break block0;
            window.setBackgroundDrawableResource(R.drawable.uxsdk_background_dialog_rounded_corners);
        }
    }

    public void onClick(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (v instanceof TextView) {
            if (v.getId() == R.id.textview_cancel_simulator_dialog) {
                this.dismiss();
            } else if (v.getId() == R.id.textview_delete_yes) {
                this.deletePreset();
            } else if (v.getId() == R.id.textview_delete_no) {
                this.resetListUI();
            } else {
                Object object = v.getTag();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this.sendPresetEvent((String)object);
            }
        } else {
            Object object = v.getTag();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            this.showDeleteConfirmation((String)object);
        }
    }

    private final void populatePresetList() {
        block4: {
            this.presetListContainerLinearLayout.removeAllViews();
            Map<String, ?> simulatorPresetList = SimulatorPresetUtils.INSTANCE.getPresetList();
            if (!simulatorPresetList.isEmpty()) {
                this.emptyPresetListTextView.setVisibility(8);
                this.presetListContainerLinearLayout.setVisibility(0);
                for (Map.Entry<String, ?> entry : simulatorPresetList.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
                    this.insertView(key, (String)value);
                }
            } else {
                this.emptyPresetListTextView.setVisibility(0);
                this.presetListContainerLinearLayout.setVisibility(8);
            }
            if (this.getWindow() == null) break block4;
            Window window = this.getWindow();
            if (window != null) {
                window.setLayout((int)this.getContext().getResources().getDimension(R.dimen.uxsdk_simulator_dialog_width), this.dialogHeight);
            }
        }
    }

    private final void resetListUI() {
        this.keyToDelete = null;
        this.confirmDeleteTextView.setVisibility(8);
        this.deletePresetYesTextView.setVisibility(8);
        this.presetListContainerLinearLayout.setVisibility(0);
        this.deletePresetNoTextView.setVisibility(8);
        this.cancelDialogTextView.setVisibility(0);
        this.populatePresetList();
    }

    private final void deletePreset() {
        SimulatorPresetUtils.INSTANCE.deletePreset(this.keyToDelete);
        this.resetListUI();
    }

    private final void showDeleteConfirmation(String key) {
        block1: {
            this.keyToDelete = key;
            this.confirmDeleteTextView.setVisibility(0);
            this.deletePresetYesTextView.setVisibility(0);
            this.presetListContainerLinearLayout.setVisibility(8);
            this.deletePresetNoTextView.setVisibility(0);
            this.cancelDialogTextView.setVisibility(8);
            Object[] objectArray = new Object[]{key};
            this.confirmDeleteTextView.setText((CharSequence)this.getContext().getResources().getString(R.string.uxsdk_simulator_save_preset_delete, objectArray));
            if (this.getWindow() == null) break block1;
            Window window = this.getWindow();
            if (window != null) {
                window.setLayout((int)this.getContext().getResources().getDimension(R.dimen.uxsdk_simulator_dialog_width), -2);
            }
        }
    }

    private final void sendPresetEvent(String data) {
        if (data != null) {
            String[] stringArray = new String[]{" "};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] dataParts = thisCollection$iv.toArray(new String[0]);
            double latitude = Double.parseDouble(dataParts[0]);
            double longitude = Double.parseDouble(dataParts[1]);
            int satelliteCount = Integer.parseInt(dataParts[2]);
            int frequency = Integer.parseInt(dataParts[3]);
            this.loadPresetListener.onLoadPreset(new SimulatorPresetData(latitude, longitude, satelliteCount, frequency));
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getResources().getString(R.string.uxsdk_simulator_preset_error), (int)0).show();
        }
        this.dismiss();
    }

    @SuppressLint(value={"InflateParams"})
    private final void insertView(String key, String value) {
        View presetRow = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.uxsdk_layout_simulator_preset_row, null);
        this.presetListContainerLinearLayout.addView(presetRow, this.presetListContainerLinearLayout.getChildCount());
        TextView presetNameTextView = (TextView)presetRow.findViewById(R.id.textview_preset_name);
        presetNameTextView.setText((CharSequence)key);
        presetNameTextView.setTag((Object)value);
        presetNameTextView.setOnClickListener((View.OnClickListener)this);
        ImageView deleteImage = (ImageView)presetRow.findViewById(R.id.imageview_preset_delete);
        deleteImage.setTag((Object)key);
        deleteImage.setOnClickListener((View.OnClickListener)this);
    }

    @JvmOverloads
    public PresetListDialog(@NotNull Context context, @NotNull OnLoadPresetListener loadPresetListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)loadPresetListener, (String)"loadPresetListener");
        this(context, loadPresetListener, 0, 4, null);
    }
}

