/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.amap.place;

import android.content.Context;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.core.PoiItem;
import com.amap.api.services.geocoder.GeocodeResult;
import com.amap.api.services.geocoder.GeocodeSearch;
import com.amap.api.services.geocoder.RegeocodeAddress;
import com.amap.api.services.geocoder.RegeocodeQuery;
import com.amap.api.services.geocoder.RegeocodeResult;
import com.amap.api.services.poisearch.PoiResult;
import com.amap.api.services.poisearch.PoiSearch;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.places.DJIPlacesClient;
import dji.v5.ux.mapkit.core.places.DJIPoiItem;
import dji.v5.ux.mapkit.core.places.DJIPoiSearchQuery;
import dji.v5.ux.mapkit.core.places.DJIRegeocodeResult;
import dji.v5.ux.mapkit.core.places.IInternalPlacesClient;
import dji.v5.ux.mapkit.core.utils.DJIGpsUtils;
import java.util.ArrayList;

public class AMapPlaceDelegate
implements IInternalPlacesClient,
PoiSearch.OnPoiSearchListener {
    private static final int AMAP_SEARCH_SUCCESS_CODE = 1000;
    private Context context;
    private PoiSearch poiSearch;
    private PoiSearch.Query query;
    private DJIPlacesClient.OnPoiSearchListener onPoiSearchListener;
    private DJIPlacesClient.OnRegeocodeSearchListener onRegeocodeSearchListener;

    public AMapPlaceDelegate(Context context) {
        this.context = context;
        this.query = new PoiSearch.Query("", "", "");
        this.query.setPageSize(10);
        this.poiSearch = new PoiSearch(context, this.query);
    }

    @Override
    public void setPoiSearchQuery(DJIPoiSearchQuery poiSearchQuery) {
        this.query = new PoiSearch.Query(poiSearchQuery.keyWord(), "");
        this.poiSearch.setQuery(this.query);
    }

    @Override
    public void setOnRegeocodeSearchListener(DJIPlacesClient.OnRegeocodeSearchListener onRegeocodeSearchListener) {
        this.onRegeocodeSearchListener = onRegeocodeSearchListener;
    }

    @Override
    public void setOnPoiSearchListener(DJIPlacesClient.OnPoiSearchListener onPoiSearchListener) {
        this.onPoiSearchListener = onPoiSearchListener;
    }

    @Override
    public void searchPOIAsyn(DJILatLng latLng) {
        this.searchPOIAsyn(latLng, 300);
    }

    @Override
    public void searchPOIAsyn(DJILatLng latLng, int radius) {
        DJILatLng gcjLatLng = DJIGpsUtils.wgs2gcjInChina(latLng);
        this.poiSearch.setOnPoiSearchListener((PoiSearch.OnPoiSearchListener)this);
        this.poiSearch.setBound(new PoiSearch.SearchBound(new LatLonPoint(gcjLatLng.getLatitude(), gcjLatLng.getLongitude()), radius));
        this.poiSearch.searchPOIAsyn();
    }

    public void onPoiSearched(PoiResult poiResult, int i) {
        if (i == 1000) {
            ArrayList pois = poiResult.getPois();
            ArrayList<DJIPoiItem> poiList = new ArrayList<DJIPoiItem>(pois.size());
            for (PoiItem poiItem : pois) {
                LatLonPoint latLonPoint = poiItem.getLatLonPoint();
                DJILatLng wgsLatLng = DJIGpsUtils.gcj2wgsInChina(new DJILatLng(latLonPoint.getLatitude(), latLonPoint.getLongitude()));
                DJIPoiItem item = new DJIPoiItem(poiItem.getTitle(), poiItem.getSnippet(), wgsLatLng);
                poiList.add(item);
            }
            if (this.onPoiSearchListener != null) {
                this.onPoiSearchListener.onPoiSearched(poiList);
            }
        } else if (this.onPoiSearchListener != null) {
            this.onPoiSearchListener.onPoiSearchFailed();
        }
    }

    public void onPoiItemSearched(PoiItem poiItem, int i) {
    }

    @Override
    public void regeocodeSearchAsyn(DJILatLng latLng) {
        RegeocodeQuery querys = new RegeocodeQuery(new LatLonPoint(latLng.getLatitude(), latLng.getLongitude()), 300.0f, "autonavi");
        GeocodeSearch geoCoderSearch = new GeocodeSearch(this.context);
        geoCoderSearch.setOnGeocodeSearchListener(new GeocodeSearch.OnGeocodeSearchListener(){

            public void onRegeocodeSearched(RegeocodeResult regeocodeResult, int resultId) {
                if (resultId == 1000) {
                    RegeocodeAddress regeocodeAddress = regeocodeResult.getRegeocodeAddress();
                    DJIRegeocodeResult result = new DJIRegeocodeResult();
                    result.setCountry("\u4e2d\u56fd");
                    result.setRegion(regeocodeAddress.getProvince());
                    result.setCity(regeocodeAddress.getCity());
                    result.setDistrict(regeocodeAddress.getDistrict());
                    result.setStreet(regeocodeAddress.getTownship());
                    result.setSubStreet(regeocodeAddress.getStreetNumber() != null ? regeocodeAddress.getStreetNumber().getStreet() : null);
                    result.setAddress(regeocodeAddress.getFormatAddress());
                    if (AMapPlaceDelegate.this.onRegeocodeSearchListener != null) {
                        AMapPlaceDelegate.this.onRegeocodeSearchListener.onSearched(result);
                    }
                } else if (AMapPlaceDelegate.this.onRegeocodeSearchListener != null) {
                    AMapPlaceDelegate.this.onRegeocodeSearchListener.onSearched(null);
                }
            }

            public void onGeocodeSearched(GeocodeResult geocodeResult, int i) {
            }
        });
        geoCoderSearch.getFromLocationAsyn(querys);
    }
}

