/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.videosignal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.StyleRes;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.core.widget.videosignal.VideoSignalWidget;
import dji.v5.ux.core.widget.videosignal.VideoSignalWidgetModel;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.PublishProcessor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 ]2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\\]B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010A\u001a\u00020B2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010C\u001a\u00020BH\u0014J\b\u0010D\u001a\u00020BH\u0014J\b\u0010E\u001a\u00020BH\u0014J\u0012\u0010F\u001a\u00020B2\b\b\u0001\u0010G\u001a\u00020\bH\u0002J\u0010\u0010H\u001a\u00020B2\u0006\u0010I\u001a\u00020JH\u0002J\b\u0010K\u001a\u00020BH\u0002J\u0010\u0010L\u001a\u00020B2\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020PH\u0002J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\bH\u0002J\n\u0010T\u001a\u0004\u0018\u00010UH\u0016J\u0010\u0010#\u001a\u00020B2\b\b\u0001\u0010V\u001a\u00020\bJ\u0010\u0010'\u001a\u00020B2\b\b\u0001\u0010V\u001a\u00020\bJ\u0010\u0010*\u001a\u00020B2\b\b\u0001\u0010V\u001a\u00020\bJ\u0010\u0010-\u001a\u00020B2\b\b\u0001\u0010V\u001a\u00020\bJ\u0010\u0010W\u001a\u00020B2\b\b\u0001\u0010X\u001a\u00020\bJ\u0018\u0010Y\u001a\u00020B2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u000e\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00020[H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0017\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R(\u0010%\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R(\u0010(\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R(\u0010+\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$R(\u0010/\u001a\u0004\u0018\u00010.2\b\u0010\u0016\u001a\u0004\u0018\u00010.8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R&\u00104\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u0019\"\u0004\b6\u0010\u001bR&\u00107\u001a\u0002082\b\b\u0001\u00107\u001a\u0002088G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R(\u0010>\u001a\u0004\u0018\u00010\u001f2\b\u0010=\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010\"\"\u0004\b@\u0010$\u00a8\u0006^"}, d2={"Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "videoIconImageView", "Landroid/widget/ImageView;", "videoSignalImageView", "frequencyBandTextView", "Landroid/widget/TextView;", "widgetModel", "Ldji/v5/ux/core/widget/videosignal/VideoSignalWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/core/widget/videosignal/VideoSignalWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "value", "connectedStateIconColor", "getConnectedStateIconColor", "()I", "setConnectedStateIconColor", "(I)V", "disconnectedStateIconColor", "getDisconnectedStateIconColor", "setDisconnectedStateIconColor", "Landroid/graphics/drawable/Drawable;", "videoIcon", "getVideoIcon", "()Landroid/graphics/drawable/Drawable;", "setVideoIcon", "(Landroid/graphics/drawable/Drawable;)V", "videoIconBackground", "getVideoIconBackground", "setVideoIconBackground", "videoSignalIcon", "getVideoSignalIcon", "setVideoSignalIcon", "videoSignalIconBackground", "getVideoSignalIconBackground", "setVideoSignalIconBackground", "Landroid/content/res/ColorStateList;", "textColors", "getTextColors", "()Landroid/content/res/ColorStateList;", "setTextColors", "(Landroid/content/res/ColorStateList;)V", "textColor", "getTextColor", "setTextColor", "textSize", "", "getTextSize", "()F", "setTextSize", "(F)V", "drawable", "textBackground", "getTextBackground", "setTextBackground", "initView", "", "onAttachedToWindow", "onDetachedFromWindow", "reactToModelChanges", "updateVideoSignal", "videoSignalQuality", "updateIconColor", "isConnected", "", "checkAndUpdateIconColor", "updateWifiFrequencyBandText", "frequencyBandType", "Ldji/sdk/keyvalue/value/airlink/FrequencyBand;", "reactToOcuSyncFrequencyStateChange", "Lio/reactivex/rxjava3/disposables/Disposable;", "getAutoFrequencyBandStr", "", "ocuFrequencyPoint", "getIdealDimensionRatioString", "", "resourceId", "setTextAppearance", "textAppearance", "initAttributes", "getWidgetStateUpdate", "Lio/reactivex/rxjava3/core/Flowable;", "ModelState", "Companion", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nVideoSignalWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoSignalWidget.kt\ndji/v5/ux/core/widget/videosignal/VideoSignalWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 4 TypedArrayExtensions.kt\ndji/v5/ux/core/extension/TypedArrayExtensions\n*L\n1#1,413:1\n1#2:414\n1#2:418\n1#2:422\n1#2:441\n233#3:415\n234#3,2:443\n101#4,2:416\n103#4:419\n101#4,2:420\n103#4:423\n125#4,5:424\n88#4,5:429\n64#4,5:434\n101#4,2:439\n103#4:442\n*S KotlinDebug\n*F\n+ 1 VideoSignalWidget.kt\ndji/v5/ux/core/widget/videosignal/VideoSignalWidget\n*L\n336#1:418\n340#1:422\n356#1:441\n335#1:415\n335#1:443,2\n336#1:416,2\n336#1:419\n340#1:420,2\n340#1:423\n344#1:424,5\n348#1:429,5\n352#1:434,5\n356#1:439,2\n356#1:442\n*E\n"})
public class VideoSignalWidget
extends ConstraintLayoutWidget<ModelState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageView videoIconImageView;
    @NotNull
    private final ImageView videoSignalImageView;
    @NotNull
    private final TextView frequencyBandTextView;
    @NotNull
    private final Lazy widgetModel$delegate;
    private int connectedStateIconColor;
    private int disconnectedStateIconColor;
    @NotNull
    private static final String TAG = "VideoSignalWidget";
    @NotNull
    private static final String FREQUENCY_BAND_2_DOT_4_GHZ = "2.4G";
    @NotNull
    private static final String FREQUENCY_BAND_5_GHZ = "5G";
    @NotNull
    private static final String FREQUENCY_BAND_5_DOT_7_GHZ = "5.7G";
    @NotNull
    private static final String FREQUENCY_BAND_5_DOT_8_GHZ = "5.8G";

    @JvmOverloads
    public VideoSignalWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, attrs, defStyleAttr);
            View view = this.findViewById(R.id.imageview_video_icon);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
            this.videoIconImageView = (ImageView)view;
            View view2 = this.findViewById(R.id.imageview_video_signal);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
            this.videoSignalImageView = (ImageView)view2;
            View view3 = this.findViewById(R.id.textview_frequency_band);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
            this.frequencyBandTextView = (TextView)view3;
            this.widgetModel$delegate = LazyKt.lazy(VideoSignalWidget::widgetModel_delegate$lambda$0);
            this.connectedStateIconColor = ViewExtensions.getColor((View)this, R.color.uxsdk_white);
            this.disconnectedStateIconColor = ViewExtensions.getColor((View)this, R.color.uxsdk_gray_58);
            AttributeSet attributeSet = attrs;
            if (attributeSet == null) break block0;
            AttributeSet it = attributeSet;
            boolean bl = false;
            this.initAttributes(context, it);
        }
    }

    public /* synthetic */ VideoSignalWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final VideoSignalWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (VideoSignalWidgetModel)lazy.getValue();
    }

    @ColorInt
    public final int getConnectedStateIconColor() {
        return this.connectedStateIconColor;
    }

    public final void setConnectedStateIconColor(@ColorInt int value) {
        this.connectedStateIconColor = value;
        this.checkAndUpdateIconColor();
    }

    @ColorInt
    public final int getDisconnectedStateIconColor() {
        return this.disconnectedStateIconColor;
    }

    public final void setDisconnectedStateIconColor(@ColorInt int value) {
        this.disconnectedStateIconColor = value;
        this.checkAndUpdateIconColor();
    }

    @Nullable
    public final Drawable getVideoIcon() {
        return ViewExtensions.getImageDrawable(this.videoIconImageView);
    }

    public final void setVideoIcon(@Nullable Drawable value) {
        ViewExtensions.setImageDrawable(this.videoIconImageView, value);
    }

    @Nullable
    public final Drawable getVideoIconBackground() {
        return this.videoIconImageView.getBackground();
    }

    public final void setVideoIconBackground(@Nullable Drawable value) {
        this.videoIconImageView.setBackground(value);
    }

    @Nullable
    public final Drawable getVideoSignalIcon() {
        return ViewExtensions.getImageDrawable(this.videoSignalImageView);
    }

    public final void setVideoSignalIcon(@Nullable Drawable value) {
        ViewExtensions.setImageDrawable(this.videoSignalImageView, value);
    }

    @Nullable
    public final Drawable getVideoSignalIconBackground() {
        return this.videoSignalImageView.getBackground();
    }

    public final void setVideoSignalIconBackground(@Nullable Drawable value) {
        this.videoSignalImageView.setBackground(value);
    }

    @Nullable
    public final ColorStateList getTextColors() {
        return ViewExtensions.getTextColorStateList(this.frequencyBandTextView);
    }

    public final void setTextColors(@Nullable ColorStateList value) {
        ViewExtensions.setTextColorStateList(this.frequencyBandTextView, value);
    }

    @ColorInt
    public final int getTextColor() {
        return ViewExtensions.getTextColor(this.frequencyBandTextView);
    }

    public final void setTextColor(@ColorInt int value) {
        ViewExtensions.setTextColor(this.frequencyBandTextView, value);
    }

    @Dimension
    public final float getTextSize() {
        return this.frequencyBandTextView.getTextSize();
    }

    public final void setTextSize(@Dimension float textSize) {
        this.frequencyBandTextView.setTextSize(textSize);
    }

    @Nullable
    public final Drawable getTextBackground() {
        return this.frequencyBandTextView.getBackground();
    }

    public final void setTextBackground(@Nullable Drawable drawable2) {
        this.frequencyBandTextView.setBackground(drawable2);
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        View.inflate((Context)context, (int)R.layout.uxsdk_widget_video_signal, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ VideoSignalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                VideoSignalWidget.access$updateIconColor(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().getVideoSignalQuality().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ VideoSignalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Integer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                VideoSignalWidget.access$updateVideoSignal(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.getWidgetModel().getAirlinkFrequencyBand().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ VideoSignalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(FrequencyBand it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                VideoSignalWidget.access$updateWifiFrequencyBandText(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
        this.addReaction(this.reactToOcuSyncFrequencyStateChange());
    }

    private final void updateVideoSignal(@IntRange(from=0L, to=100L) int videoSignalQuality) {
        this.getWidgetStateDataProcessor().onNext((Object)new ModelState.VideoSignalQualityUpdated(videoSignalQuality));
        this.videoSignalImageView.setImageLevel(videoSignalQuality);
    }

    private final void updateIconColor(boolean isConnected) {
        this.getWidgetStateDataProcessor().onNext((Object)new ModelState.ProductConnected(isConnected));
        if (isConnected) {
            this.videoIconImageView.setColorFilter(this.connectedStateIconColor, PorterDuff.Mode.SRC_IN);
        } else {
            this.videoIconImageView.setColorFilter(this.disconnectedStateIconColor, PorterDuff.Mode.SRC_IN);
            this.frequencyBandTextView.setText((CharSequence)"");
        }
    }

    private final void checkAndUpdateIconColor() {
        if (!this.isInEditMode()) {
            Disposable disposable = this.getWidgetModel().getProductConnection().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(arg_0 -> VideoSignalWidget.checkAndUpdateIconColor$lambda$2(this, arg_0), UxErrorHandle.logErrorConsumer(TAG, "Update Icon Color "));
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
            this.addDisposable(disposable);
        }
    }

    private final void updateWifiFrequencyBandText(FrequencyBand frequencyBandType) {
        this.getWidgetStateDataProcessor().onNext((Object)new ModelState.AirlinkFrequencyBandUpdated(frequencyBandType));
        if (frequencyBandType != FrequencyBand.UNKNOWN) {
            this.frequencyBandTextView.setText((CharSequence)(switch (WhenMappings.$EnumSwitchMapping$0[frequencyBandType.ordinal()]) {
                case 1 -> FREQUENCY_BAND_2_DOT_4_GHZ;
                case 2 -> FREQUENCY_BAND_2_DOT_4_GHZ;
                case 3 -> FREQUENCY_BAND_5_GHZ;
                default -> "";
            }));
        }
    }

    private final Disposable reactToOcuSyncFrequencyStateChange() {
        Disposable disposable = Flowable.combineLatest((Publisher)((Publisher)this.getWidgetModel().getAirlinkFrequencyBand()), (Publisher)((Publisher)this.getWidgetModel().getOcuSyncFrequencyPointIndex()), (BiFunction)reactToOcuSyncFrequencyStateChange.1.INSTANCE).observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ VideoSignalWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Pair<FrequencyBand, Integer> values) {
                PublishProcessor publishProcessor = VideoSignalWidget.access$getWidgetStateDataProcessor(this.this$0);
                Object object = values.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                publishProcessor.onNext((Object)new ModelState.AirlinkFrequencyBandUpdated((FrequencyBand)object));
                if (values.first != FrequencyBand.UNKNOWN) {
                    TextView textView = VideoSignalWidget.access$getFrequencyBandTextView$p(this.this$0);
                    FrequencyBand frequencyBand = (FrequencyBand)values.first;
                    textView.setText((CharSequence)(switch (frequencyBand == null ? -1 : reactToOcuSyncFrequencyStateChange.WhenMappings.$EnumSwitchMapping$0[frequencyBand.ordinal()]) {
                        case 1 -> "2.4G";
                        case 2 -> "5.8G";
                        case 3 -> {
                            Object v5 = values.second;
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"second");
                            yield VideoSignalWidget.access$getAutoFrequencyBandStr(this.this$0, ((Number)v5).intValue());
                        }
                        default -> "";
                    }));
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        return disposable;
    }

    private final String getAutoFrequencyBandStr(int ocuFrequencyPoint) {
        return ocuFrequencyPoint > 2400 && ocuFrequencyPoint < 5470 ? FREQUENCY_BAND_2_DOT_4_GHZ : (ocuFrequencyPoint > 5470 ? FREQUENCY_BAND_5_DOT_8_GHZ : "");
    }

    @Nullable
    public Void getIdealDimensionRatioString() {
        return null;
    }

    public final void setVideoIcon(@DrawableRes int resourceId) {
        this.setVideoIcon(ViewExtensions.getDrawable((View)this, resourceId));
    }

    public final void setVideoIconBackground(@DrawableRes int resourceId) {
        this.setVideoIconBackground(ViewExtensions.getDrawable((View)this, resourceId));
    }

    public final void setVideoSignalIcon(@DrawableRes int resourceId) {
        this.setVideoSignalIcon(ViewExtensions.getDrawable((View)this, resourceId));
    }

    public final void setVideoSignalIconBackground(@DrawableRes int resourceId) {
        this.setVideoSignalIconBackground(ViewExtensions.getDrawable((View)this, resourceId));
    }

    public final void setTextAppearance(@StyleRes int textAppearance) {
        this.frequencyBandTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @SuppressLint(value={"Recycle"})
    private final void initAttributes(Context context, AttributeSet attrs) {
        Unit unit;
        TypedArray $this$getColorAndUse$iv;
        TypedArray $this$getDimensionAndUse$iv;
        TypedArray $this$getResourceIdAndUse$iv;
        Drawable it;
        boolean bl;
        Drawable it$iv;
        TypedArray $this$getDrawableAndUse$iv;
        Drawable drawable$iv;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.VideoSignalWidget);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl2 = false;
        TypedArray typedArray3 = typedArray2;
        int index$iv = R.styleable.VideoSignalWidget_uxsdk_videoIcon;
        boolean $i$f$getDrawableAndUse = false;
        Drawable drawable2 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable2 != null) {
            it$iv = drawable2;
            bl = false;
            it = drawable$iv;
            boolean bl3 = false;
            this.setVideoIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.VideoSignalWidget_uxsdk_videoSignalIcon;
        $i$f$getDrawableAndUse = false;
        Drawable drawable3 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable3 != null) {
            it$iv = drawable3;
            bl = false;
            it = drawable$iv;
            boolean bl4 = false;
            this.setVideoSignalIcon(it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.VideoSignalWidget_uxsdk_frequencyBandTextAppearance;
        boolean $i$f$getResourceIdAndUse = false;
        int resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it2 = resourceId$iv;
            boolean bl5 = false;
            this.setTextAppearance(it2);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.VideoSignalWidget_uxsdk_frequencyBandTextSize;
        boolean $i$f$getDimensionAndUse = false;
        float dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            float it3 = dimension$iv;
            boolean bl6 = false;
            this.setTextSize(DisplayUtil.pxToSp((Context)context, (float)it3));
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.VideoSignalWidget_uxsdk_frequencyBandTextColor;
        boolean $i$f$getColorAndUse = false;
        int colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it4 = colorInt$iv;
            boolean bl7 = false;
            this.setTextColor(it4);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.VideoSignalWidget_uxsdk_frequencyBandBackgroundDrawable;
        $i$f$getDrawableAndUse = false;
        Drawable drawable4 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable4 != null) {
            Drawable it$iv2 = drawable4;
            bl = false;
            it = drawable$iv;
            boolean bl8 = false;
            this.setTextBackground(it);
        }
        this.setConnectedStateIconColor(typedArray2.getColor(R.styleable.VideoSignalWidget_uxsdk_connectedStateIconColor, this.connectedStateIconColor));
        this.setDisconnectedStateIconColor(typedArray2.getColor(R.styleable.VideoSignalWidget_uxsdk_disconnectedStateIconColor, this.disconnectedStateIconColor));
        Unit it$iv3 = unit = Unit.INSTANCE;
        boolean bl9 = false;
        $this$use$iv.recycle();
    }

    @Override
    @NotNull
    public Flowable<ModelState> getWidgetStateUpdate() {
        return super.getWidgetStateUpdate();
    }

    @JvmOverloads
    public VideoSignalWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public VideoSignalWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final VideoSignalWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new VideoSignalWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final void checkAndUpdateIconColor$lambda$2(VideoSignalWidget this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateIconColor(it);
    }

    public static final /* synthetic */ void access$updateIconColor(VideoSignalWidget $this, boolean isConnected) {
        $this.updateIconColor(isConnected);
    }

    public static final /* synthetic */ void access$updateVideoSignal(VideoSignalWidget $this, int videoSignalQuality) {
        $this.updateVideoSignal(videoSignalQuality);
    }

    public static final /* synthetic */ void access$updateWifiFrequencyBandText(VideoSignalWidget $this, FrequencyBand frequencyBandType) {
        $this.updateWifiFrequencyBandText(frequencyBandType);
    }

    public static final /* synthetic */ PublishProcessor access$getWidgetStateDataProcessor(VideoSignalWidget $this) {
        return $this.getWidgetStateDataProcessor();
    }

    public static final /* synthetic */ TextView access$getFrequencyBandTextView$p(VideoSignalWidget $this) {
        return $this.frequencyBandTextView;
    }

    public static final /* synthetic */ String access$getAutoFrequencyBandStr(VideoSignalWidget $this, int ocuFrequencyPoint) {
        return $this.getAutoFrequencyBandStr(ocuFrequencyPoint);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$Companion;", "", "<init>", "()V", "TAG", "", "FREQUENCY_BAND_2_DOT_4_GHZ", "FREQUENCY_BAND_5_GHZ", "FREQUENCY_BAND_5_DOT_7_GHZ", "FREQUENCY_BAND_5_DOT_8_GHZ", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState;", "", "<init>", "()V", "ProductConnected", "VideoSignalQualityUpdated", "AirlinkFrequencyBandUpdated", "Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState$AirlinkFrequencyBandUpdated;", "Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState$VideoSignalQualityUpdated;", "android-sdk-v5-uxsdk_release"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState$AirlinkFrequencyBandUpdated;", "Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState;", "frequencyBandType", "Ldji/sdk/keyvalue/value/airlink/FrequencyBand;", "<init>", "(Ldji/sdk/keyvalue/value/airlink/FrequencyBand;)V", "getFrequencyBandType", "()Ldji/sdk/keyvalue/value/airlink/FrequencyBand;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class AirlinkFrequencyBandUpdated
        extends ModelState {
            @NotNull
            private final FrequencyBand frequencyBandType;

            public AirlinkFrequencyBandUpdated(@NotNull FrequencyBand frequencyBandType) {
                Intrinsics.checkNotNullParameter((Object)frequencyBandType, (String)"frequencyBandType");
                super(null);
                this.frequencyBandType = frequencyBandType;
            }

            @NotNull
            public final FrequencyBand getFrequencyBandType() {
                return this.frequencyBandType;
            }

            @NotNull
            public final FrequencyBand component1() {
                return this.frequencyBandType;
            }

            @NotNull
            public final AirlinkFrequencyBandUpdated copy(@NotNull FrequencyBand frequencyBandType) {
                Intrinsics.checkNotNullParameter((Object)frequencyBandType, (String)"frequencyBandType");
                return new AirlinkFrequencyBandUpdated(frequencyBandType);
            }

            public static /* synthetic */ AirlinkFrequencyBandUpdated copy$default(AirlinkFrequencyBandUpdated airlinkFrequencyBandUpdated, FrequencyBand frequencyBand, int n, Object object) {
                if ((n & 1) != 0) {
                    frequencyBand = airlinkFrequencyBandUpdated.frequencyBandType;
                }
                return airlinkFrequencyBandUpdated.copy(frequencyBand);
            }

            @NotNull
            public String toString() {
                return "AirlinkFrequencyBandUpdated(frequencyBandType=" + this.frequencyBandType + ")";
            }

            public int hashCode() {
                return this.frequencyBandType.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AirlinkFrequencyBandUpdated)) {
                    return false;
                }
                AirlinkFrequencyBandUpdated airlinkFrequencyBandUpdated = (AirlinkFrequencyBandUpdated)other;
                return this.frequencyBandType == airlinkFrequencyBandUpdated.frequencyBandType;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState;", "isConnected", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class ProductConnected
        extends ModelState {
            private final boolean isConnected;

            public ProductConnected(boolean isConnected) {
                super(null);
                this.isConnected = isConnected;
            }

            public final boolean isConnected() {
                return this.isConnected;
            }

            public final boolean component1() {
                return this.isConnected;
            }

            @NotNull
            public final ProductConnected copy(boolean isConnected) {
                return new ProductConnected(isConnected);
            }

            public static /* synthetic */ ProductConnected copy$default(ProductConnected productConnected, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = productConnected.isConnected;
                }
                return productConnected.copy(bl);
            }

            @NotNull
            public String toString() {
                return "ProductConnected(isConnected=" + this.isConnected + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isConnected);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProductConnected)) {
                    return false;
                }
                ProductConnected productConnected = (ProductConnected)other;
                return this.isConnected == productConnected.isConnected;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState$VideoSignalQualityUpdated;", "Ldji/v5/ux/core/widget/videosignal/VideoSignalWidget$ModelState;", "signalQuality", "", "<init>", "(I)V", "getSignalQuality", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class VideoSignalQualityUpdated
        extends ModelState {
            private final int signalQuality;

            public VideoSignalQualityUpdated(int signalQuality) {
                super(null);
                this.signalQuality = signalQuality;
            }

            public final int getSignalQuality() {
                return this.signalQuality;
            }

            public final int component1() {
                return this.signalQuality;
            }

            @NotNull
            public final VideoSignalQualityUpdated copy(int signalQuality) {
                return new VideoSignalQualityUpdated(signalQuality);
            }

            public static /* synthetic */ VideoSignalQualityUpdated copy$default(VideoSignalQualityUpdated videoSignalQualityUpdated, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = videoSignalQualityUpdated.signalQuality;
                }
                return videoSignalQualityUpdated.copy(n);
            }

            @NotNull
            public String toString() {
                return "VideoSignalQualityUpdated(signalQuality=" + this.signalQuality + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.signalQuality);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VideoSignalQualityUpdated)) {
                    return false;
                }
                VideoSignalQualityUpdated videoSignalQualityUpdated = (VideoSignalQualityUpdated)other;
                return this.signalQuality == videoSignalQualityUpdated.signalQuality;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FrequencyBand.values().length];
            try {
                nArray[FrequencyBand.BAND_2_DOT_4G.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrequencyBand.BAND_1_DOT_4G.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrequencyBand.BAND_MULTI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

