/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.ContextUtil;
import dji.v5.utils.common.StringUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.setting.ui.MenuFragment;
import dji.v5.ux.obstacle.PrecisionLandingWidget;
import dji.v5.ux.obstacle.VisionPositionWidget;

public class OmniPerceptionMenuFragment
extends MenuFragment {
    private PrecisionLandingWidget precisionLandingWidget;
    private boolean isDownwardVisionSystemOpen;

    @Override
    protected String getPreferencesTitle() {
        return StringUtils.getResStr((Context)ContextUtil.getContext(), (int)R.string.uxsdk_setting_menu_title_perception, (Object[])new Object[0]);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.uxsdk_fragemnt_setting_menu_omni_perception_layout;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        VisionPositionWidget visionPositionWidget = (VisionPositionWidget)view.findViewById(R.id.omni_vision_position_widget);
        this.precisionLandingWidget = (PrecisionLandingWidget)view.findViewById(R.id.omni_vision_precision_landing_widget);
        visionPositionWidget.setSwitchStateListener(check -> {
            this.isDownwardVisionSystemOpen = check;
            this.updatePrecisionWidgetVisible();
        });
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), (Object)this, (oldValue, newValue) -> this.updatePrecisionWidgetVisible());
    }

    public void onResume() {
        super.onResume();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        KeyManager.getInstance().cancelListen((Object)this);
    }

    private void updatePrecisionWidgetVisible() {
        if (this.precisionLandingWidget == null) {
            return;
        }
        if (this.isDownwardVisionSystemOpen && !ProductUtil.isM3EProduct() && !ProductUtil.isM4EProduct() && !ProductUtil.isM4DProduct()) {
            this.precisionLandingWidget.setVisibility(0);
        } else {
            this.precisionLandingWidget.setVisibility(8);
        }
    }
}

