/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.videosignal;

import dji.sdk.keyvalue.key.AirLinkKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u001cH\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0014R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016\u00a8\u0006\""}, d2={"Ldji/v5/ux/core/widget/videosignal/VideoSignalWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;)V", "tag", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "videoSignalQualityProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "airlinkFrequencyBandProcessor", "Ldji/sdk/keyvalue/value/airlink/FrequencyBand;", "signalValue", "ocuFrequencyPointIndexProcessor", "videoSignalQuality", "Lio/reactivex/rxjava3/core/Flowable;", "getVideoSignalQuality", "()Lio/reactivex/rxjava3/core/Flowable;", "ocuSyncFrequencyPointIndex", "getOcuSyncFrequencyPointIndex", "airlinkFrequencyBand", "getAirlinkFrequencyBand", "inSetup", "", "inCleanup", "updateStates", "onProductConnectionChanged", "isConnected", "", "android-sdk-v5-uxsdk_debug"})
public final class VideoSignalWidgetModel
extends WidgetModel {
    private final String tag;
    @NotNull
    private final DataProcessor<Integer> videoSignalQualityProcessor;
    @NotNull
    private final DataProcessor<FrequencyBand> airlinkFrequencyBandProcessor;
    private int signalValue;
    @NotNull
    private final DataProcessor<Integer> ocuFrequencyPointIndexProcessor;

    public VideoSignalWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.tag = LogUtils.getTag((String)"VideoSignalWidgetModel");
        DataProcessor<Integer> dataProcessor = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.videoSignalQualityProcessor = dataProcessor;
        DataProcessor<FrequencyBand> dataProcessor2 = DataProcessor.create(FrequencyBand.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.airlinkFrequencyBandProcessor = dataProcessor2;
        DataProcessor<Integer> dataProcessor3 = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.ocuFrequencyPointIndexProcessor = dataProcessor3;
    }

    @NotNull
    public final Flowable<Integer> getVideoSignalQuality() {
        Flowable<Integer> flowable = this.videoSignalQualityProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<Integer> getOcuSyncFrequencyPointIndex() {
        Flowable<Integer> flowable = this.ocuFrequencyPointIndexProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<FrequencyBand> getAirlinkFrequencyBand() {
        Flowable<FrequencyBand> flowable = this.airlinkFrequencyBandProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyPoint), this.ocuFrequencyPointIndexProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyDownLinkQualityRaw), this.videoSignalQualityProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyBand), this.airlinkFrequencyBandProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
    }

    @Override
    protected void onProductConnectionChanged(boolean isConnected) {
        if (!isConnected) {
            this.signalValue = 0;
        }
    }
}

