/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.focusmode;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraFocusMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.SettingDefinitions;
import dji.v5.ux.core.util.UxErrorHandle;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class FocusModeWidgetModel
extends WidgetModel
implements ICameraIndex {
    private final DataProcessor<Boolean> isFocusModeSupportedDataProcessor;
    private final DataProcessor<CameraFocusMode> focusModeDataProcessor;
    private final DataProcessor<Boolean> isAFCSupportedProcessor;
    private final DataProcessor<Boolean> isAFCEnabledKeyProcessor;
    private final DataProcessor<Boolean> isAFCEnabledProcessor;
    private final DataProcessor<SettingDefinitions.ControlMode> controlModeProcessor;
    private final ObservableInMemoryKeyedStore keyedStore;
    private final GlobalPreferencesInterface preferencesManager;
    private DJIKey<CameraFocusMode> focusModeKey;
    private UXKey controlModeKey;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public FocusModeWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        super(djiSdkModel, keyedStore);
        this.focusModeDataProcessor = DataProcessor.create(CameraFocusMode.UNKNOWN);
        this.isAFCSupportedProcessor = DataProcessor.create(false);
        this.isAFCEnabledKeyProcessor = DataProcessor.create(false);
        this.isAFCEnabledProcessor = DataProcessor.create(false);
        this.isFocusModeSupportedDataProcessor = DataProcessor.create(false);
        this.controlModeProcessor = DataProcessor.create(SettingDefinitions.ControlMode.SPOT_METER);
        if (preferencesManager != null) {
            this.isAFCEnabledKeyProcessor.onNext(preferencesManager.getAFCEnabled());
            this.updateAFCEnabledProcessor();
            this.controlModeProcessor.onNext(preferencesManager.getControlMode());
        }
        this.preferencesManager = preferencesManager;
        this.keyedStore = keyedStore;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraFocusMode, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.focusModeDataProcessor);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyIsAFCSupported, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.isAFCSupportedProcessor);
        UXKey afcEnabledKey = UXKeys.create("AFCEnabled");
        this.bindDataProcessor(afcEnabledKey, this.isAFCEnabledKeyProcessor);
        this.controlModeKey = UXKeys.create("ControlMode");
        this.bindDataProcessor(this.controlModeKey, this.controlModeProcessor);
        this.focusModeKey = KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraFocusMode, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType);
        if (this.preferencesManager != null) {
            this.preferencesManager.setUpListener();
        }
    }

    @Override
    protected void inCleanup() {
        if (this.preferencesManager != null) {
            this.preferencesManager.cleanup();
        }
    }

    @Override
    protected void updateStates() {
        this.updateAFCEnabledProcessor();
    }

    private void updateAFCEnabledProcessor() {
        this.isAFCEnabledProcessor.onNext(this.isAFCEnabledKeyProcessor.getValue() != false && this.isAFCSupportedProcessor.getValue() != false);
    }

    @Override
    protected void onProductConnectionChanged(boolean isConnected) {
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Completable toggleFocusMode() {
        CameraFocusMode currentFocusMode = this.focusModeDataProcessor.getValue();
        CameraFocusMode nextFocusMode = this.getNextFocusMode(currentFocusMode);
        return this.djiSdkModel.setValue(this.focusModeKey, nextFocusMode).doOnComplete(() -> this.onFocusModeUpdate(nextFocusMode)).doOnError(error -> this.focusModeDataProcessor.onNext(currentFocusMode));
    }

    private CameraFocusMode getNextFocusMode(CameraFocusMode currentFocusMode) {
        CameraFocusMode nextFocusMode = currentFocusMode == CameraFocusMode.MANUAL ? (this.isAFCEnabledProcessor.getValue().booleanValue() ? CameraFocusMode.AFC : CameraFocusMode.AF) : CameraFocusMode.MANUAL;
        return nextFocusMode;
    }

    public Flowable<CameraFocusMode> getFocusMode() {
        return this.focusModeDataProcessor.toFlowable();
    }

    public Flowable<Boolean> isAFCEnabled() {
        return this.isAFCEnabledProcessor.toFlowable();
    }

    public Flowable<Boolean> isFocusModeChangeSupported() {
        return this.isFocusModeSupportedDataProcessor.toFlowable();
    }

    private void onFocusModeUpdate(CameraFocusMode focusMode) {
        if (this.controlModeProcessor.getValue() == SettingDefinitions.ControlMode.SPOT_METER || this.controlModeProcessor.getValue() == SettingDefinitions.ControlMode.CENTER_METER) {
            return;
        }
        switch (focusMode) {
            case AF: {
                this.preferencesManager.setControlMode(SettingDefinitions.ControlMode.AUTO_FOCUS);
                this.addDisposable(this.keyedStore.setValue(this.controlModeKey, (Object)SettingDefinitions.ControlMode.AUTO_FOCUS).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(this.tag, "setControlModeAutoFocus: ")));
                break;
            }
            case AFC: {
                this.preferencesManager.setControlMode(SettingDefinitions.ControlMode.AUTO_FOCUS_CONTINUE);
                this.addDisposable(this.keyedStore.setValue(this.controlModeKey, (Object)SettingDefinitions.ControlMode.AUTO_FOCUS_CONTINUE).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(this.tag, "setControlModeAutoFocusContinuous: ")));
                break;
            }
            case MANUAL: {
                this.preferencesManager.setControlMode(SettingDefinitions.ControlMode.MANUAL_FOCUS);
                this.addDisposable(this.keyedStore.setValue(this.controlModeKey, (Object)SettingDefinitions.ControlMode.MANUAL_FOCUS).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(this.tag, "setControlModeManualFocus: ")));
                break;
            }
        }
    }
}

