/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.ev;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraExposureCompensation;
import dji.sdk.keyvalue.value.camera.CameraExposureMode;
import dji.sdk.keyvalue.value.camera.CameraExposureSettings;
import dji.sdk.keyvalue.value.camera.ExposureSensitivityMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;

public class CameraConfigEVWidgetModel
extends WidgetModel
implements ICameraIndex {
    private DataProcessor<CameraExposureSettings> exposureSettingsProcessor;
    private DataProcessor<CameraExposureMode> exposureModeProcessor;
    private DataProcessor<CameraExposureCompensation> exposureCompensationProcessor;
    private DataProcessor<ExposureSensitivityMode> exposureSensitivityModeProcessor;
    private DataProcessor<CameraExposureCompensation> consolidatedExposureCompensationProcessor;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public CameraConfigEVWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.exposureSettingsProcessor = DataProcessor.create(new CameraExposureSettings());
        this.exposureModeProcessor = DataProcessor.create(CameraExposureMode.UNKNOWN);
        this.exposureCompensationProcessor = DataProcessor.create(CameraExposureCompensation.UNKNOWN);
        this.exposureSensitivityModeProcessor = DataProcessor.create(ExposureSensitivityMode.UNKNOWN);
        this.consolidatedExposureCompensationProcessor = DataProcessor.create(CameraExposureCompensation.UNKNOWN);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Flowable<ExposureSensitivityMode> getExposureSensitivityMode() {
        return this.exposureSensitivityModeProcessor.toFlowable();
    }

    public Flowable<CameraExposureCompensation> getExposureCompensation() {
        return this.consolidatedExposureCompensationProcessor.toFlowable();
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureSettings, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.exposureSettingsProcessor);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureMode, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.exposureModeProcessor);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureCompensation, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.exposureCompensationProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyExposureSensitivityMode, (ComponentIndexType)this.cameraIndex), this.exposureSensitivityModeProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
        this.updateConsolidatedExposureCompensationValue();
    }

    private void updateConsolidatedExposureCompensationValue() {
        if (this.exposureModeProcessor.getValue() != CameraExposureMode.MANUAL && this.exposureCompensationProcessor.getValue() != CameraExposureCompensation.FIXED) {
            this.consolidatedExposureCompensationProcessor.onNext(this.exposureCompensationProcessor.getValue());
        } else {
            CameraExposureCompensation exposureCompensation = this.exposureSettingsProcessor.getValue().getExposureCompensation();
            if (exposureCompensation != null) {
                if (exposureCompensation == CameraExposureCompensation.FIXED) {
                    this.consolidatedExposureCompensationProcessor.onNext(CameraExposureCompensation.NEG_0EV);
                } else {
                    this.consolidatedExposureCompensationProcessor.onNext(exposureCompensation);
                }
            }
        }
    }
}

