/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.remotecontroller.calibration.wheel;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import dji.sdk.keyvalue.value.remotecontroller.RcCalibrateState;
import dji.v5.ux.R;
import dji.v5.ux.remotecontroller.RcCalibrationWidgetModel;
import dji.v5.ux.remotecontroller.calibration.DJICalProgressBar;
import dji.v5.ux.remotecontroller.calibration.IRcCalibrationView;
import dji.v5.ux.remotecontroller.calibration.OnCalibrationListener;
import io.reactivex.rxjava3.disposables.CompositeDisposable;

public class WheelCalibrationView
extends LinearLayout
implements IRcCalibrationView {
    protected RcCalibrationWidgetModel rcCalibrationWidgetModel;
    private static final int ITEM_LEFT = 0;
    private static final int ITEM_RIGHT = 1;
    protected DJICalProgressBar mLeftWheelPgb;
    protected DJICalProgressBar mRightWheelPgb;
    private RcCalibrateState mCalibrationModeNow = RcCalibrateState.UNKNOWN;
    private OnCalibrationListener mListener = null;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();

    public WheelCalibrationView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.mLeftWheelPgb = (DJICalProgressBar)this.findViewById(R.id.fpv_rcsetting_cele_item_pgb);
        this.mRightWheelPgb = (DJICalProgressBar)this.findViewById(R.id.fpv_rcsetting_cele_item_right_wheel_pgb);
        this.mLeftWheelPgb.setValue(0, 0);
        this.mRightWheelPgb.setValue(0, 0);
    }

    private int transformValue(int value) {
        return (int)((float)value / 6.6f);
    }

    private void updateWheel(int item, int gyro) {
        int gPgb = this.transformValue(gyro);
        DJICalProgressBar pgb = 0 == item ? this.mLeftWheelPgb : this.mRightWheelPgb;
        pgb.setValue(gPgb < 0 ? -gPgb : 0, gPgb > 0 ? gPgb : 0);
    }

    @Override
    public void updateViewByMode(RcCalibrateState mode) {
        this.mCalibrationModeNow = mode;
        if (this.isCalibrated() && this.mListener != null) {
            this.mListener.onCalibrationFinished(2);
        }
    }

    @Override
    public void setListener(OnCalibrationListener listener2) {
        this.mListener = listener2;
    }

    public void setViewModel(RcCalibrationWidgetModel rcCalibrationWidgetModel) {
        this.rcCalibrationWidgetModel = rcCalibrationWidgetModel;
        this.mCompositeDisposable.add(rcCalibrationWidgetModel.calibrationInfoDataProcessor.toFlowableOnUI().subscribe(smartControllerCalibrationInfo -> {
            this.updateWheel(0, smartControllerCalibrationInfo.leftGyroValue);
            this.updateWheel(1, smartControllerCalibrationInfo.rightGyroValue);
            if (this.isCalibrated()) {
                return;
            }
            if (RcCalibrateState.LIMITVALUE == smartControllerCalibrationInfo.calibrationState || RcCalibrateState.EXIT == smartControllerCalibrationInfo.calibrationState) {
                if (this.isCalibrated() && this.mListener != null) {
                    this.mListener.onCalibrationFinished(2);
                }
                this.updateViewByMode(smartControllerCalibrationInfo.calibrationState);
            }
        }));
    }

    @Override
    public void removeListener() {
        this.mListener = null;
    }

    @Override
    public void reset() {
        this.mCalibrationModeNow = RcCalibrateState.UNKNOWN;
        if (this.mListener != null) {
            this.mListener.onCalibrationCanceled(2);
        }
    }

    @Override
    public boolean isCalibrated() {
        return this.mCalibrationModeNow == RcCalibrateState.EXIT;
    }

    protected void onDetachedFromWindow() {
        this.mCompositeDisposable.dispose();
        super.onDetachedFromWindow();
    }
}

