/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptorFactory;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.maplibre.map.MaplibreMapDelegate;
import dji.v5.ux.mapkit.maplibre.utils.MaplibreUtils;

public class MSymbolLayerMarker
extends DJIMarker {
    private MapboxMap mapboxMap;
    private GeoJsonSource source;
    private SymbolLayer symbolLayer;
    private Context context;
    private MaplibreMapDelegate maplibreMapDelegate;
    private DJIBitmapDescriptor bitmapDescriptor;
    private Marker shadowMarker;
    private boolean isInfoWindowClosed;
    private boolean draggable;
    private boolean visibleCache = true;
    private String title;
    private String sourceId;
    private String layerId;
    private DJIMarkerOptions markerOptions;

    public MSymbolLayerMarker(MaplibreMapDelegate maplibreMapDelegate, MapboxMap mapboxMap, GeoJsonSource geoJsonSource, SymbolLayer symbolLayer, Marker shadowMarker, Context context, DJIMarkerOptions markerOptions) {
        this.mapboxMap = mapboxMap;
        this.source = geoJsonSource;
        this.symbolLayer = symbolLayer;
        this.context = context;
        this.maplibreMapDelegate = maplibreMapDelegate;
        this.shadowMarker = shadowMarker;
        this.sourceId = this.source.getId();
        this.layerId = this.symbolLayer.getId();
        this.markerOptions = markerOptions;
    }

    public void updateSourceLayer() {
        this.source = new GeoJsonSource(this.sourceId);
        this.setPosition(this.positionCache);
        this.symbolLayer = new SymbolLayer(this.layerId, this.sourceId);
        this.mapboxMap.getStyle().addSource((Source)this.source);
        this.setIcon(this.bitmapDescriptor);
        this.setRotation(this.markerOptions.getRotation());
        this.setTitle(this.markerOptions.getTitle());
        this.setAnchor(this.markerOptions.getAnchorU(), this.markerOptions.getAnchorV());
        this.setVisible(this.visibleCache);
        this.maplibreMapDelegate.updateLayerByZIndex(this.markerOptions.getZIndex(), (Layer)this.symbolLayer);
    }

    public Marker getShadowMarker() {
        return this.shadowMarker;
    }

    @Override
    public void setPosition(DJILatLng latLng) {
        this.markerOptions.position(latLng);
        this.setPositionCache(latLng);
        if (this.source == null) {
            return;
        }
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        Point point = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude(), (double)latLng.getAltitude());
        this.source.setGeoJson((Geometry)point);
        this.shadowMarker.setPosition(MaplibreUtils.fromDJILatLng(latLng));
    }

    @Override
    public void setRotation(float rotate) {
        this.setRotationCache(rotate);
        this.markerOptions.rotation(rotate);
        if (this.symbolLayer == null) {
            return;
        }
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.symbolLayer.setProperties(new PropertyValue[]{PropertyFactory.iconRotate((Float)Float.valueOf(rotate))});
    }

    @Override
    public void setIcon(DJIBitmapDescriptor icon) {
        if (this.symbolLayer == null) {
            return;
        }
        if (icon == this.bitmapDescriptor) {
            this.symbolLayer.setProperties(new PropertyValue[]{PropertyFactory.iconImage((String)icon.getId())});
            this.symbolLayer.setProperties(new PropertyValue[]{PropertyFactory.iconAllowOverlap((Boolean)true)});
            return;
        }
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            if (this.bitmapDescriptor == null) {
                this.bitmapDescriptor = icon;
            }
            return;
        }
        if (this.bitmapDescriptor != null) {
            this.mapboxMap.getStyle().removeImage(this.bitmapDescriptor.getId());
        } else {
            this.bitmapDescriptor = DJIBitmapDescriptorFactory.fromBitmap(icon.getBitmap());
        }
        String bitmapId = this.maplibreMapDelegate.genMarkerBitmapId();
        icon.setId(bitmapId);
        this.bitmapDescriptor.setId(bitmapId);
        this.markerOptions.icon(this.bitmapDescriptor);
        Icon i = MaplibreUtils.fromDJIBitmapDescriptor(this.context, icon);
        this.bitmapDescriptor.updateBitmap(i.getBitmap());
        this.mapboxMap.getStyle().addImage(icon.getId(), i.getBitmap());
        this.symbolLayer.setProperties(new PropertyValue[]{PropertyFactory.iconImage((String)icon.getId())});
        this.symbolLayer.setProperties(new PropertyValue[]{PropertyFactory.iconAllowOverlap((Boolean)true)});
    }

    @Override
    public void setAnchor(float u, float v) {
        if (this.symbolLayer == null) {
            return;
        }
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.markerOptions.anchor(u, v);
        if (this.bitmapDescriptor != null) {
            Bitmap bitmap = this.bitmapDescriptor.getBitmap();
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Bitmap translatedBitmap = Bitmap.createBitmap((int)(width * 2), (int)(height * 2), (Bitmap.Config)bitmap.getConfig());
            Canvas canvas = new Canvas(translatedBitmap);
            canvas.drawColor(0);
            canvas.drawBitmap(bitmap, (float)width - (float)width * u, (float)height - (float)height * v, null);
            this.mapboxMap.getStyle().removeImage(this.bitmapDescriptor.getId());
            this.mapboxMap.getStyle().addImage(this.bitmapDescriptor.getId(), translatedBitmap);
            this.symbolLayer.setProperties(new PropertyValue[]{PropertyFactory.iconImage((String)this.bitmapDescriptor.getId())});
        }
    }

    @Override
    public void setTitle(String title) {
        this.markerOptions.title(title);
        if (this.symbolLayer == null) {
            return;
        }
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setVisible(boolean visible) {
        this.markerOptions.visible(visible);
        if (this.symbolLayer == null) {
            return;
        }
        this.visibleCache = visible;
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        if (visible) {
            this.symbolLayer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)"visible")});
        } else {
            this.symbolLayer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)"none")});
        }
    }

    @Override
    public boolean isVisible() {
        PropertyValue visible = this.symbolLayer.getVisibility();
        return ((String)visible.getValue()).equals("visible");
    }

    @Override
    public void showInfoWindow() {
        this.mapboxMap.selectMarker(this.shadowMarker);
        this.isInfoWindowClosed = false;
    }

    @Override
    public void hideInfoWindow() {
        this.mapboxMap.deselectMarker(this.shadowMarker);
        this.isInfoWindowClosed = true;
    }

    @Override
    public boolean isInfoWindowShown() {
        return !this.isInfoWindowClosed;
    }

    @Override
    public void remove() {
        this.mapboxMap.removeMarker(this.shadowMarker);
        this.maplibreMapDelegate.onMarkerRemove(this.shadowMarker);
    }

    @Override
    public void setDraggable(boolean b) {
        this.draggable = b;
    }

    @Override
    public boolean isDraggable() {
        return this.draggable;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public void setSource(GeoJsonSource source) {
        this.source = source;
    }

    public void setSymbolLayer(SymbolLayer symbolLayer) {
        this.symbolLayer = symbolLayer;
    }
}

