/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.maplibre.utils.MaplibreUtils;
import java.util.ArrayList;
import java.util.List;

public class MPolyline
implements DJIPolyline {
    Polyline polyline;
    DJIPolylineOptions mDJIPolylineOptions;
    MapboxMap mapboxMap;

    public MPolyline(Polyline polyline, DJIPolylineOptions options, MapboxMap mapboxMap) {
        this.polyline = polyline;
        this.mDJIPolylineOptions = options;
        this.mapboxMap = mapboxMap;
    }

    @Override
    public void remove() {
        this.mapboxMap.removePolyline(this.polyline);
    }

    @Override
    public void setWidth(float width) {
        this.polyline.setWidth(width / 5.0f);
    }

    @Override
    public float getWidth() {
        return this.polyline.getWidth();
    }

    @Override
    public void setPoints(List<DJILatLng> points) {
        ArrayList<LatLng> mPoints = new ArrayList<LatLng>(points.size());
        for (DJILatLng latLng : points) {
            mPoints.add(MaplibreUtils.fromDJILatLng(latLng));
        }
        this.polyline.setPoints(mPoints);
    }

    @Override
    public List<DJILatLng> getPoints() {
        ArrayList<DJILatLng> djiPoints = new ArrayList<DJILatLng>(this.polyline.getPoints().size());
        for (LatLng latLng : this.polyline.getPoints()) {
            djiPoints.add(MaplibreUtils.fromLatLng(latLng));
        }
        return djiPoints;
    }

    @Override
    public void setColor(int color2) {
        this.polyline.setColor(color2);
    }

    @Override
    public int getColor() {
        return this.polyline.getColor();
    }

    @Override
    public void setZIndex(float zIndex) {
    }

    @Override
    public float getZIndex() {
        return 0.0f;
    }

    public DJIPolylineOptions getOptions() {
        return this.mDJIPolylineOptions;
    }

    public void setOptions(DJIPolylineOptions options) {
        List<DJILatLng> latLngs = options.getPoints();
        ArrayList<LatLng> points = new ArrayList<LatLng>(latLngs.size());
        for (DJILatLng latLng : latLngs) {
            points.add(MaplibreUtils.fromDJILatLng(latLng));
        }
        this.polyline.setColor(options.getColor());
        this.polyline.setWidth(options.getWidth() / 5.0f);
        this.polyline.setPoints(points);
    }
}

