/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.layers.FillLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.maplibre.map.MaplibreMapDelegate;
import dji.v5.ux.mapkit.maplibre.utils.MaplibreUtils;
import java.util.ArrayList;
import java.util.List;

public class MCircle
implements DJICircle {
    private static final float NO_ALPHA = 0.0f;
    private MapboxMap mapboxMap;
    private FillLayer singleCircleLayer;
    private GeoJsonSource source;
    private MaplibreMapDelegate maplibreMapDelegate;
    private DJICircleOptions options;
    private Polyline border;
    private float borderAlpha;
    private String sourceId;
    private String layerId;

    public MCircle(MaplibreMapDelegate maplibreMapDelegate, MapboxMap mapboxMap, FillLayer singleCircleLayer, GeoJsonSource source, DJICircleOptions options) {
        this.maplibreMapDelegate = maplibreMapDelegate;
        this.mapboxMap = mapboxMap;
        this.singleCircleLayer = singleCircleLayer;
        this.source = source;
        this.sourceId = source.getId();
        this.layerId = singleCircleLayer.getId();
        this.options = options;
    }

    public void updateSourceLayer() {
        this.source = new GeoJsonSource(this.sourceId);
        this.setCircle(this.options.getCenter(), this.options.getRadius());
        this.mapboxMap.getStyle().addSource((Source)this.source);
        this.singleCircleLayer = new FillLayer(this.layerId, this.sourceId);
        this.setFillColor(this.options.getFillColor());
        this.setStrokeColor(this.options.getStrokeColor());
        this.maplibreMapDelegate.updateLayerByZIndex((int)this.options.getZIndex(), (Layer)this.singleCircleLayer);
    }

    @Override
    public void remove() {
        this.maplibreMapDelegate.onSingleCircleRemove(this);
        if (this.border != null) {
            this.mapboxMap.removePolyline(this.border);
        }
    }

    @Override
    public void setCircle(DJILatLng center, Double radius) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.center(center);
        this.options.radius(radius);
        Point point = Point.fromLngLat((double)center.getLongitude(), (double)center.getLatitude(), (double)center.getAltitude());
        Polygon polygon = MaplibreUtils.getCircle(point, radius);
        this.source.setGeoJson((Geometry)polygon);
        ArrayList<LatLng> pointsList = new ArrayList<LatLng>();
        for (int i = 0; i < 64; ++i) {
            LatLng latLng = new LatLng();
            latLng.setLatitude(((Point)((List)polygon.coordinates().get(0)).get(i)).latitude());
            latLng.setLongitude(((Point)((List)polygon.coordinates().get(0)).get(i)).longitude());
            pointsList.add(latLng);
        }
        PolylineOptions polylineOptions = new PolylineOptions();
        polylineOptions.addAll(pointsList).add((LatLng)pointsList.get(0)).color(this.options.getStrokeColor()).width(this.options.getStrokeWidth() / 5.0f);
        this.borderAlpha = polylineOptions.getAlpha();
        this.border = this.mapboxMap.addPolyline(polylineOptions);
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        if (this.border != null) {
            this.border.setWidth(strokeWidth);
        }
    }

    @Override
    public float getStrokeWidth() {
        if (this.border != null) {
            return this.border.getWidth();
        }
        return 0.0f;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        if (visible) {
            this.singleCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)"visible")});
            if (this.border != null) {
                this.border.setAlpha(this.borderAlpha);
            }
        } else {
            this.singleCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)"none")});
            if (this.border != null) {
                this.border.setAlpha(0.0f);
            }
        }
    }

    @Override
    public boolean isVisible() {
        boolean visible = ((String)this.singleCircleLayer.getVisibility().value).equals("visible");
        return visible;
    }

    @Override
    public void setCenter(DJILatLng center) {
        this.options.center(center);
        this.setCircle(center, this.getRadius());
    }

    @Override
    public DJILatLng getCenter() {
        return this.options.getCenter();
    }

    @Override
    public void setRadius(double radius) {
        this.options.radius(radius);
        this.setCircle(this.getCenter(), radius);
    }

    @Override
    public double getRadius() {
        return this.options.getRadius();
    }

    @Override
    public void setFillColor(@ColorInt int color2) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        int fillColor = Color.rgb((int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
        float alpha = (float)Color.alpha((int)color2) / 255.0f;
        this.singleCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.fillColor((int)fillColor), PropertyFactory.fillOpacity((Float)Float.valueOf(alpha))});
    }

    @Override
    public int getFillColor() {
        return this.singleCircleLayer.getFillColorAsInt();
    }

    @Override
    public void setStrokeColor(@ColorInt int color2) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.singleCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.fillOutlineColor((int)color2)});
        if (this.border != null) {
            this.border.setColor(color2);
        }
    }

    @Override
    public int getStrokeColor() {
        if (this.border != null) {
            return this.border.getColor();
        }
        return this.singleCircleLayer.getFillOutlineColorAsInt();
    }

    @Override
    public void setZIndex(float zIndex) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.zIndex(zIndex);
        this.maplibreMapDelegate.updateLayerByZIndex((int)zIndex, (Layer)this.singleCircleLayer);
    }

    @Override
    public float getZIndex() {
        return this.options.getZIndex();
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getLayerId() {
        return this.layerId;
    }
}

