/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.map;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.core.graphics.ColorUtils;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneCategory;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneInformation;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneLicenseInfo;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneShape;
import dji.v5.manager.aircraft.flysafe.info.MultiPolygonFlyZoneInformation;
import dji.v5.manager.aircraft.flysafe.info.MultiPolygonFlyZoneShape;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.map.FlyZoneActionListener;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptorFactory;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygon;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FlyZoneMapHelper {
    protected static final float DEFAULT_BORDER_WIDTH = 5.0f;
    private static final int DEFAULT_ALPHA = 26;
    private static final float DEFAULT_ANCHOR = 0.5f;
    private final String tag = LogUtils.getTag((Object)this);
    private Context context;
    private DJIMap map;
    private Map<String, DJICircle> authorizationDJICircleMap = new ConcurrentHashMap<String, DJICircle>();
    private Map<String, DJIPolygon> authorizationDJIPolygonMap = new ConcurrentHashMap<String, DJIPolygon>();
    private Map<String, DJICircle> warningDJICircleMap = new ConcurrentHashMap<String, DJICircle>();
    private Map<String, DJIPolygon> warningDJIPolygonMap = new ConcurrentHashMap<String, DJIPolygon>();
    private Map<String, DJICircle> enhancedWarningDJICircleMap = new ConcurrentHashMap<String, DJICircle>();
    private Map<String, DJIPolygon> enhancedWarningDJIPolygonMap = new ConcurrentHashMap<String, DJIPolygon>();
    private Map<String, DJICircle> restrictedDJICircleMap = new ConcurrentHashMap<String, DJICircle>();
    private Map<String, DJIPolygon> restrictedDJIPolygonMap = new ConcurrentHashMap<String, DJIPolygon>();
    private Map<String, DJIMarker> flyZoneLockedMarkerMap = new ConcurrentHashMap<String, DJIMarker>();
    private Map<String, DJIMarker> flyZoneUnlockedMarkerMap = new ConcurrentHashMap<String, DJIMarker>();
    private Map<String, FlyZoneLicenseInfo> customUnlockZonesOnAircraft = new ConcurrentHashMap<String, FlyZoneLicenseInfo>();
    private Map<String, FlyZoneInformation> flyZoneMarkerInformationMap = new ConcurrentHashMap<String, FlyZoneInformation>();
    private Set<DJIMarker> customUnlockMarkersSet = new HashSet<DJIMarker>();
    private Map<String, DJICircle> customUnlockCircleMap = new ConcurrentHashMap<String, DJICircle>();
    private Set<String> maximumHeightShapeFlyZoneId = new HashSet<String>();
    private Set<String> selfUnlockFlyZoneId = new HashSet<String>();
    private Set<String> customUnlockFlyZoneShapeId = new HashSet<String>();
    private Set<String> customUnlockFlyZoneOnAircraftShapeId = new HashSet<String>();
    private Set<String> customUnlockFlyZoneEnabledShapeId = new HashSet<String>();
    @ColorInt
    private int customUnlockColor;
    private int customUnlockColorAlpha;
    @ColorInt
    private int customUnlockSentToAircraftColor;
    private int customUnlockSentToAircraftColorAlpha;
    @ColorInt
    private int customUnlockEnabledColor;
    private int customUnlockEnabledColorAlpha;
    private DJIBitmapDescriptor customUnlockEnabledImg;
    private float customUnlockImgEnabledXAnchor;
    private float customUnlockImgEnabledYAnchor;
    private DJIBitmapDescriptor customUnlockSentToAircraftImg;
    private float customUnlockSentToAircraftImgXAnchor;
    private float customUnlockSentToAircraftImgYAnchor;
    private Map<FlyZoneCategory, Integer> flyZoneColorMap = new ConcurrentHashMap<FlyZoneCategory, Integer>();
    private Map<FlyZoneCategory, Integer> flyZoneAlphaMap = new ConcurrentHashMap<FlyZoneCategory, Integer>();
    private float flyZoneBorderWidth = 2.0f;
    @ColorInt
    private int maximumHeightColor;
    private int maximumHeightAlpha;
    @ColorInt
    private int selfUnlockColor;
    private int selfUnlockAlpha;
    private DJIBitmapDescriptor selfUnlockedImg;
    private float selfUnlockedImgXAnchor;
    private float selfUnlockedImgYAnchor;
    private boolean isFlyZoneUnlockingEnabled = true;
    private DJIBitmapDescriptor selfLockedImg;
    private float selfLockedImgXAnchor;
    private float selfLockedImgYAnchor;
    private int alertDialogTheme = R.style.UXSDKMapWidgetTheme;
    private AlertDialog alertDialog;
    private FlyZoneActionListener flyZoneActionListener;
    private boolean customUnlockZonesVisibility;

    public FlyZoneMapHelper(@NonNull Context context, FlyZoneActionListener flyZoneActionListener) {
        this.context = context;
        this.flyZoneActionListener = flyZoneActionListener;
        this.initDefaults();
    }

    public void initializeMap(@NonNull DJIMap map) {
        this.map = map;
    }

    public void onFlyZoneListUpdate(@NonNull List<FlyZoneInformation> flyZoneList) {
        if (this.map == null) {
            return;
        }
        this.removeFlyZonesOffMap();
        for (FlyZoneInformation flyZoneInformation : flyZoneList) {
            this.drawFlyZone(flyZoneInformation);
        }
    }

    public boolean isFlyZoneMarkerId(@NonNull String flyZoneId) {
        return this.flyZoneMarkerInformationMap.containsKey(flyZoneId) || this.customUnlockZonesOnAircraft.containsKey(flyZoneId);
    }

    public void onFlyZoneMarkerClick(@NonNull String flyZoneId) {
        if (this.flyZoneMarkerInformationMap.get(flyZoneId) != null) {
            FlyZoneInformation flyZoneInformation = this.flyZoneMarkerInformationMap.get(flyZoneId);
            if (this.flyZoneLockedMarkerMap.containsKey(flyZoneId)) {
                this.unlockFlyZone(flyZoneInformation);
            }
        } else if (this.customUnlockZonesOnAircraft.get(flyZoneId) != null) {
            FlyZoneLicenseInfo flyZoneInformation = this.customUnlockZonesOnAircraft.get(flyZoneId);
            if (flyZoneInformation.isEnabled()) {
                this.flyZoneActionListener.requestDisableFlyZone();
            } else {
                this.verifyCustomUnlockFlyZoneCanBeEnabled(flyZoneInformation);
            }
        }
    }

    public void onCustomUnlockZoneUpdate(@NonNull Map<Integer, FlyZoneLicenseInfo> customUnlockZoneMap, @NonNull List<FlyZoneLicenseInfo> customUnlockZoneList) {
        if (this.map == null) {
            return;
        }
        this.removeCustomFlyZones();
        for (Map.Entry<Integer, FlyZoneLicenseInfo> entry : customUnlockZoneMap.entrySet()) {
            this.customUnlockZonesOnAircraft.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        for (FlyZoneLicenseInfo customUnlockZone : customUnlockZoneList) {
            this.drawCustomUnlockFlyZones(customUnlockZone);
        }
    }

    private void verifyCustomUnlockFlyZoneCanBeEnabled(FlyZoneLicenseInfo customUnlockEnableZone) {
        boolean isFlyZoneEnabled = false;
        String enabledZone = "";
        for (FlyZoneLicenseInfo customUnlockZone : this.customUnlockZonesOnAircraft.values()) {
            if (!customUnlockZone.isEnabled()) continue;
            isFlyZoneEnabled = true;
            enabledZone = customUnlockZone.getDescription();
            break;
        }
        if (isFlyZoneEnabled) {
            AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this.context, this.alertDialogTheme);
            alertDialogBuilder.setTitle((CharSequence)this.context.getResources().getString(R.string.uxsdk_fly_zone_warning));
            alertDialogBuilder.setMessage((CharSequence)this.context.getResources().getString(R.string.uxsdk_custom_fly_zone_duplicate, new Object[]{enabledZone, customUnlockEnableZone.getDescription()}));
            alertDialogBuilder.setCancelable(false);
            alertDialogBuilder.setNegativeButton((CharSequence)this.context.getResources().getString(R.string.uxsdk_app_cancel), (dialog, which) -> dialog.cancel());
            alertDialogBuilder.setPositiveButton((CharSequence)this.context.getResources().getString(R.string.uxsdk_fly_zone_unlock), (dialog, which) -> this.flyZoneActionListener.requestEnableFlyZone(customUnlockEnableZone));
            this.alertDialog = alertDialogBuilder.create();
            this.alertDialog.show();
        } else {
            this.flyZoneActionListener.requestEnableFlyZone(customUnlockEnableZone);
        }
    }

    private void drawCustomUnlockFlyZones(FlyZoneLicenseInfo customUnlockZone) {
        DJILatLng zoneCoordinates = new DJILatLng(customUnlockZone.getCylinderLatitude(), customUnlockZone.getCylinderLongitude());
        String customUnlockZoneId = String.valueOf(customUnlockZone.getLicenseId());
        DJICircleOptions zoneCircle = new DJICircleOptions().radius(customUnlockZone.getCylinderRadius()).center(zoneCoordinates).strokeWidth(this.flyZoneBorderWidth);
        DJIMarkerOptions markerOptions = new DJIMarkerOptions().position(new DJILatLng(customUnlockZone.getCylinderLatitude(), customUnlockZone.getCylinderLongitude())).title(customUnlockZoneId);
        if (customUnlockZone.isEnabled()) {
            zoneCircle.strokeColor(this.customUnlockEnabledColor).fillColor(ColorUtils.setAlphaComponent((int)this.customUnlockEnabledColor, (int)this.customUnlockEnabledColorAlpha));
            markerOptions.icon(this.customUnlockEnabledImg).anchor(this.customUnlockImgEnabledXAnchor, this.customUnlockImgEnabledYAnchor);
            this.customUnlockFlyZoneEnabledShapeId.add(customUnlockZoneId);
        } else {
            zoneCircle.strokeColor(this.customUnlockSentToAircraftColor).fillColor(ColorUtils.setAlphaComponent((int)this.customUnlockSentToAircraftColor, (int)this.customUnlockSentToAircraftColorAlpha));
            markerOptions.icon(this.customUnlockSentToAircraftImg).anchor(this.customUnlockSentToAircraftImgXAnchor, this.customUnlockSentToAircraftImgYAnchor);
            this.customUnlockFlyZoneOnAircraftShapeId.add(customUnlockZoneId);
        }
        DJIMarker marker = this.map.addMarker(markerOptions);
        this.customUnlockMarkersSet.add(marker);
        marker.setVisible(this.customUnlockZonesVisibility);
        DJICircle circle = this.map.addSingleCircle(zoneCircle);
        if (circle != null) {
            circle.setVisible(this.customUnlockZonesVisibility);
            this.customUnlockCircleMap.put(customUnlockZoneId, circle);
        }
    }

    private void removeCustomFlyZones() {
        if (this.customUnlockCircleMap != null) {
            for (DJICircle djiCircle : this.customUnlockCircleMap.values()) {
                djiCircle.remove();
            }
            this.customUnlockCircleMap = new ConcurrentHashMap<String, DJICircle>();
        }
        if (this.customUnlockMarkersSet != null) {
            for (DJIMarker djiMarker : this.customUnlockMarkersSet) {
                djiMarker.remove();
            }
            this.customUnlockMarkersSet = new HashSet<DJIMarker>();
        }
        this.customUnlockFlyZoneShapeId.clear();
        this.customUnlockFlyZoneOnAircraftShapeId.clear();
        this.customUnlockFlyZoneEnabledShapeId.clear();
    }

    private void removeFlyZonesOffMap() {
        this.removeFlyZoneCircleAndClearMap(this.restrictedDJICircleMap);
        this.removeFlyZoneCircleAndClearMap(this.authorizationDJICircleMap);
        this.removeFlyZoneCircleAndClearMap(this.enhancedWarningDJICircleMap);
        this.removeFlyZoneCircleAndClearMap(this.warningDJICircleMap);
        this.removeFlyZonePolygonAndClearMap(this.restrictedDJIPolygonMap);
        this.removeFlyZonePolygonAndClearMap(this.authorizationDJIPolygonMap);
        this.removeFlyZonePolygonAndClearMap(this.enhancedWarningDJIPolygonMap);
        this.removeFlyZonePolygonAndClearMap(this.warningDJIPolygonMap);
        for (DJIMarker marker : this.flyZoneLockedMarkerMap.values()) {
            marker.remove();
        }
        this.flyZoneLockedMarkerMap.clear();
        for (DJIMarker marker : this.flyZoneUnlockedMarkerMap.values()) {
            marker.remove();
        }
        this.flyZoneUnlockedMarkerMap.clear();
        this.selfUnlockFlyZoneId.clear();
        this.maximumHeightShapeFlyZoneId.clear();
    }

    private void removeFlyZoneCircleAndClearMap(Map<String, DJICircle> map) {
        for (DJICircle flyZone : map.values()) {
            flyZone.remove();
        }
        map.clear();
    }

    private void removeFlyZonePolygonAndClearMap(Map<String, DJIPolygon> map) {
        for (DJIPolygon flyZone : map.values()) {
            flyZone.remove();
        }
        map.clear();
    }

    public void hideShowFlyZoneOfMap(FlyZoneCategory flyZoneCategory, boolean isVisible) {
        switch (flyZoneCategory) {
            case RESTRICTED: {
                this.hideShowFlyZoneCircle(this.restrictedDJICircleMap, isVisible);
                this.hideShowFlyZonePolygon(this.restrictedDJIPolygonMap, isVisible);
                break;
            }
            case AUTHORIZATION: {
                this.hideShowFlyZoneCircle(this.authorizationDJICircleMap, isVisible);
                this.hideShowFlyZonePolygon(this.authorizationDJIPolygonMap, isVisible);
                this.hideShowFlyZoneMarker(isVisible);
                break;
            }
            case ENHANCED_WARNING: {
                this.hideShowFlyZoneCircle(this.enhancedWarningDJICircleMap, isVisible);
                this.hideShowFlyZonePolygon(this.enhancedWarningDJIPolygonMap, isVisible);
                break;
            }
            case WARNING: {
                this.hideShowFlyZoneCircle(this.warningDJICircleMap, isVisible);
                this.hideShowFlyZonePolygon(this.warningDJIPolygonMap, isVisible);
                break;
            }
        }
    }

    private void hideShowFlyZoneMarker(boolean isVisible) {
        for (DJIMarker marker : this.flyZoneLockedMarkerMap.values()) {
            marker.setVisible(isVisible);
        }
        for (DJIMarker marker : this.flyZoneUnlockedMarkerMap.values()) {
            marker.setVisible(isVisible);
        }
    }

    private void hideShowFlyZoneCircle(Map<String, DJICircle> circleMap, boolean isVisible) {
        for (DJICircle flyZone : circleMap.values()) {
            flyZone.setVisible(isVisible);
        }
    }

    private void hideShowFlyZonePolygon(Map<String, DJIPolygon> polygonMap, boolean isVisible) {
        for (DJIPolygon flyZone : polygonMap.values()) {
            flyZone.setVisible(isVisible);
        }
    }

    private int getColor(int id2) {
        return this.context.getResources().getColor(id2);
    }

    private void initDefaults() {
        this.flyZoneColorMap = new HashMap<FlyZoneCategory, Integer>();
        this.flyZoneColorMap.put(FlyZoneCategory.WARNING, this.getColor(R.color.uxsdk_zone_warning));
        this.flyZoneColorMap.put(FlyZoneCategory.ENHANCED_WARNING, this.getColor(R.color.uxsdk_zone_warning_enhanced));
        this.flyZoneColorMap.put(FlyZoneCategory.AUTHORIZATION, this.getColor(R.color.uxsdk_zone_authorization));
        this.flyZoneColorMap.put(FlyZoneCategory.RESTRICTED, this.getColor(R.color.uxsdk_zone_restricted));
        this.flyZoneAlphaMap = new HashMap<FlyZoneCategory, Integer>();
        this.flyZoneAlphaMap.put(FlyZoneCategory.WARNING, 26);
        this.flyZoneAlphaMap.put(FlyZoneCategory.ENHANCED_WARNING, 26);
        this.flyZoneAlphaMap.put(FlyZoneCategory.AUTHORIZATION, 26);
        this.flyZoneAlphaMap.put(FlyZoneCategory.RESTRICTED, 26);
        this.maximumHeightColor = this.getColor(R.color.uxsdk_zone_altitude);
        this.maximumHeightAlpha = 26;
        this.selfUnlockColor = this.getColor(R.color.uxsdk_unlocked_border);
        this.selfUnlockedImg = DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.context.getResources().getDrawable(R.drawable.uxsdk_ic_flyzone_unlocked)));
        this.selfLockedImg = DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.context.getResources().getDrawable(R.drawable.uxsdk_ic_flyzone_locked)));
        this.selfUnlockedImgXAnchor = 0.5f;
        this.selfUnlockedImgYAnchor = 0.5f;
        this.selfLockedImgXAnchor = 0.5f;
        this.selfLockedImgYAnchor = 0.5f;
        this.selfUnlockAlpha = 26;
        this.customUnlockColor = this.getColor(R.color.uxsdk_custom_unlock_not_sent);
        this.customUnlockSentToAircraftColor = this.getColor(R.color.uxsdk_custom_unlock_sent);
        this.customUnlockEnabledColor = this.getColor(R.color.uxsdk_custom_unlock_enabled);
        this.customUnlockColorAlpha = 26;
        this.customUnlockSentToAircraftColorAlpha = 26;
        this.customUnlockEnabledColorAlpha = 26;
        this.customUnlockImgEnabledXAnchor = 0.5f;
        this.customUnlockImgEnabledYAnchor = 0.5f;
        this.customUnlockSentToAircraftImgXAnchor = 0.5f;
        this.customUnlockSentToAircraftImgYAnchor = 0.5f;
        this.customUnlockEnabledImg = DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.context.getResources().getDrawable(R.drawable.uxsdk_ic_flyzone_unlocked)));
        this.customUnlockSentToAircraftImg = DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(this.context.getResources().getDrawable(R.drawable.uxsdk_ic_flyzone_locked)));
    }

    private void drawFlyZone(FlyZoneInformation zone) {
        String zoneID = String.valueOf(zone.getFlyZoneID());
        LocationCoordinate2D zoneLocation = zone.getCircleCenter();
        double zoneRadius = zone.getCircleRadius();
        DJILatLng zoneCoordinates = new DJILatLng(zoneLocation.getLatitude(), zoneLocation.getLongitude());
        if (zone.getShape() == FlyZoneShape.CIRCLE) {
            DJICircleOptions zoneCircle = new DJICircleOptions().radius(zoneRadius).center(zoneCoordinates).strokeColor(this.getFlyZoneColor(zone.getCategory())).strokeWidth(this.flyZoneBorderWidth).fillColor(ColorUtils.setAlphaComponent((int)this.getFlyZoneColor(zone.getCategory()), (int)this.getFlyZoneAlpha(zone.getCategory())));
            DJICircle circle = this.map.addSingleCircle(zoneCircle);
            this.addCircleToMap(zone, circle, zoneID);
        } else if (zone.getShape() == FlyZoneShape.MULTI_POLYGON) {
            this.drawSubFlyZones(zone);
        }
        this.flyZoneMarkerInformationMap.put(String.valueOf(zone.getFlyZoneID()), zone);
    }

    private void drawSubFlyZones(FlyZoneInformation zone) {
        if (zone.getMultiPolygonFlyZoneInformation() != null) {
            for (MultiPolygonFlyZoneInformation subZone : zone.getMultiPolygonFlyZoneInformation()) {
                DJIPolygon geoPolygon;
                String zoneSubZoneId = zone.getFlyZoneID() + "_" + subZone.getFlyZoneID();
                if (subZone.getShape() == MultiPolygonFlyZoneShape.CYLINDER) {
                    LocationCoordinate2D subZoneLocation = zone.getCircleCenter();
                    double subZoneRadius = zone.getCircleRadius();
                    DJILatLng subZoneCoordinates = new DJILatLng(subZoneLocation.getLatitude(), subZoneLocation.getLongitude());
                    DJICircleOptions mapCircleOptions = new DJICircleOptions().radius(subZoneRadius).center(subZoneCoordinates).strokeWidth(this.flyZoneBorderWidth).strokeColor(this.getFlyZoneColor(zone.getCategory())).fillColor(ColorUtils.setAlphaComponent((int)this.getFlyZoneColor(zone.getCategory()), (int)this.getFlyZoneAlpha(zone.getCategory())));
                    DJICircle circle = this.map.addSingleCircle(mapCircleOptions);
                    if (circle != null) {
                        this.addCircleToMap(zone, circle, zoneSubZoneId);
                        continue;
                    }
                    LogUtils.e((String)this.tag, (Object[])new Object[]{"Invalid flyzone not added to map: " + zone.getFlyZoneID() + "_" + subZone.getFlyZoneID()});
                    continue;
                }
                if (subZone.getShape() != MultiPolygonFlyZoneShape.POLYGON) continue;
                List verticesLocations = subZone.getPolygonPoints();
                DJIPolygonOptions geoPolygonOptions = new DJIPolygonOptions();
                for (LocationCoordinate2D vertex : verticesLocations) {
                    DJILatLng verticesCoordinate = new DJILatLng(vertex.getLatitude(), vertex.getLongitude());
                    geoPolygonOptions.add(verticesCoordinate);
                }
                geoPolygonOptions.strokeWidth(this.flyZoneBorderWidth).strokeColor(this.getFlyZoneColor(zone.getCategory())).fillColor(ColorUtils.setAlphaComponent((int)this.getFlyZoneColor(zone.getCategory()), (int)this.getFlyZoneAlpha(zone.getCategory())));
                if (subZone.getLimitedHeight() != 0) {
                    geoPolygonOptions.fillColor(ColorUtils.setAlphaComponent((int)this.maximumHeightColor, (int)this.maximumHeightAlpha)).strokeColor(this.maximumHeightColor);
                    this.maximumHeightShapeFlyZoneId.add(zoneSubZoneId);
                }
                if ((geoPolygon = this.map.addPolygon(geoPolygonOptions)) != null) {
                    this.addPolygonToMap(zone, geoPolygon, zoneSubZoneId);
                    continue;
                }
                LogUtils.e((String)this.tag, (Object[])new Object[]{"Invalid flyzone not added to map: " + zone.getFlyZoneID() + "_" + subZone.getFlyZoneID()});
            }
        }
    }

    public void showSingleButtonDialog(String title, String message) {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this.context, this.alertDialogTheme);
        alertDialogBuilder.setTitle((CharSequence)title);
        alertDialogBuilder.setMessage((CharSequence)message);
        alertDialogBuilder.setCancelable(false);
        alertDialogBuilder.setPositiveButton((CharSequence)this.context.getResources().getString(R.string.uxsdk_app_ok), (dialog, which) -> dialog.cancel());
        this.alertDialog = alertDialogBuilder.create();
        this.alertDialog.show();
    }

    private void addCircleToMap(FlyZoneInformation zone, DJICircle circle, String zoneId) {
        if (zone == null || circle == null || zoneId == null) {
            return;
        }
        switch (zone.getCategory()) {
            case RESTRICTED: {
                this.restrictedDJICircleMap.put(zoneId, circle);
                break;
            }
            case AUTHORIZATION: {
                this.authorizationDJICircleMap.put(zoneId, circle);
                break;
            }
            case ENHANCED_WARNING: {
                this.enhancedWarningDJICircleMap.put(zoneId, circle);
                break;
            }
            case WARNING: {
                this.warningDJICircleMap.put(zoneId, circle);
                break;
            }
        }
    }

    private void addPolygonToMap(FlyZoneInformation zone, DJIPolygon polygon, String zoneId) {
        switch (zone.getCategory()) {
            case RESTRICTED: {
                this.restrictedDJIPolygonMap.put(zoneId, polygon);
                break;
            }
            case AUTHORIZATION: {
                this.authorizationDJIPolygonMap.put(zoneId, polygon);
                break;
            }
            case ENHANCED_WARNING: {
                this.enhancedWarningDJIPolygonMap.put(zoneId, polygon);
                break;
            }
            case WARNING: {
                this.warningDJIPolygonMap.put(zoneId, polygon);
                break;
            }
        }
    }

    private void unlockFlyZone(FlyZoneInformation flyZoneInformation) {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this.context, this.alertDialogTheme);
        alertDialogBuilder.setTitle((CharSequence)this.context.getResources().getString(R.string.uxsdk_fly_zone_unlock_zone, new Object[]{flyZoneInformation.getName()}));
        alertDialogBuilder.setMessage((CharSequence)this.context.getResources().getString(R.string.uxsdk_fly_zone_unlock_confirmation));
        alertDialogBuilder.setCancelable(false);
        alertDialogBuilder.setNegativeButton((CharSequence)this.context.getResources().getString(R.string.uxsdk_app_cancel), (dialog, which) -> dialog.cancel());
        alertDialogBuilder.setPositiveButton((CharSequence)this.context.getResources().getString(R.string.uxsdk_fly_zone_unlock), (dialog, which) -> {
            if (this.flyZoneActionListener != null) {
                ArrayList<Integer> flyZoneArrayList = new ArrayList<Integer>();
                flyZoneArrayList.add(flyZoneInformation.getFlyZoneID());
                this.flyZoneActionListener.requestSelfUnlock(flyZoneArrayList);
            }
        });
        this.alertDialog = alertDialogBuilder.create();
        this.alertDialog.show();
    }

    private void updateFlyZoneViews(FlyZoneCategory category) {
        Map<String, DJICircle> circleMap = null;
        Map<String, DJIPolygon> polygonMap = null;
        switch (category) {
            case RESTRICTED: {
                circleMap = this.restrictedDJICircleMap;
                polygonMap = this.restrictedDJIPolygonMap;
                break;
            }
            case AUTHORIZATION: {
                circleMap = this.authorizationDJICircleMap;
                polygonMap = this.authorizationDJIPolygonMap;
                break;
            }
            case ENHANCED_WARNING: {
                circleMap = this.enhancedWarningDJICircleMap;
                polygonMap = this.enhancedWarningDJIPolygonMap;
                break;
            }
            case WARNING: {
                circleMap = this.warningDJICircleMap;
                polygonMap = this.warningDJIPolygonMap;
                break;
            }
        }
        int flyZoneCategoryColor = ColorUtils.setAlphaComponent((int)this.flyZoneColorMap.get(category), (int)this.flyZoneAlphaMap.get(category));
        int maxHeightColor = ColorUtils.setAlphaComponent((int)this.maximumHeightColor, (int)this.maximumHeightAlpha);
        int selfUnlockZoneColor = ColorUtils.setAlphaComponent((int)this.selfUnlockColor, (int)this.selfUnlockAlpha);
        if (circleMap != null) {
            for (Map.Entry<String, Object> entry : circleMap.entrySet()) {
                DJICircle flyZoneCircle;
                if (this.maximumHeightShapeFlyZoneId.contains(entry.getKey())) {
                    flyZoneCircle = (DJICircle)entry.getValue();
                    flyZoneCircle.setFillColor(maxHeightColor);
                    flyZoneCircle.setStrokeColor(this.maximumHeightColor);
                    continue;
                }
                if (this.selfUnlockFlyZoneId.contains(entry.getKey())) {
                    flyZoneCircle = (DJICircle)entry.getValue();
                    flyZoneCircle.setFillColor(selfUnlockZoneColor);
                    flyZoneCircle.setStrokeColor(this.selfUnlockColor);
                    continue;
                }
                flyZoneCircle = (DJICircle)entry.getValue();
                flyZoneCircle.setFillColor(flyZoneCategoryColor);
                flyZoneCircle.setStrokeColor(this.flyZoneColorMap.get(category));
            }
        }
        if (polygonMap != null) {
            for (Map.Entry<String, Object> entry : polygonMap.entrySet()) {
                DJIPolygon flyZonePolygon;
                if (this.maximumHeightShapeFlyZoneId.contains(entry.getKey())) {
                    flyZonePolygon = (DJIPolygon)entry.getValue();
                    flyZonePolygon.setFillColor(maxHeightColor);
                    flyZonePolygon.setStrokeColor(this.maximumHeightColor);
                    continue;
                }
                if (this.selfUnlockFlyZoneId.contains(entry.getKey())) {
                    flyZonePolygon = (DJIPolygon)entry.getValue();
                    flyZonePolygon.setFillColor(selfUnlockZoneColor);
                    flyZonePolygon.setStrokeColor(this.selfUnlockColor);
                    continue;
                }
                flyZonePolygon = (DJIPolygon)entry.getValue();
                flyZonePolygon.setFillColor(flyZoneCategoryColor);
                flyZonePolygon.setStrokeColor(this.flyZoneColorMap.get(category));
            }
        }
    }

    private void updateFlyZoneBorders() {
        for (DJICircle djiCircle : this.warningDJICircleMap.values()) {
            djiCircle.setStrokeWidth(this.flyZoneBorderWidth);
        }
        for (DJIPolygon djiPolygon : this.warningDJIPolygonMap.values()) {
            djiPolygon.setStrokeWidth(this.flyZoneBorderWidth);
        }
        for (DJICircle djiCircle : this.enhancedWarningDJICircleMap.values()) {
            djiCircle.setStrokeWidth(this.flyZoneBorderWidth);
        }
        for (DJIPolygon djiPolygon : this.enhancedWarningDJIPolygonMap.values()) {
            djiPolygon.setStrokeWidth(this.flyZoneBorderWidth);
        }
        for (DJICircle djiCircle : this.authorizationDJICircleMap.values()) {
            djiCircle.setStrokeWidth(this.flyZoneBorderWidth);
        }
        for (DJIPolygon djiPolygon : this.authorizationDJIPolygonMap.values()) {
            djiPolygon.setStrokeWidth(this.flyZoneBorderWidth);
        }
        for (DJICircle djiCircle : this.restrictedDJICircleMap.values()) {
            djiCircle.setStrokeWidth(this.flyZoneBorderWidth);
        }
        for (DJIPolygon djiPolygon : this.restrictedDJIPolygonMap.values()) {
            djiPolygon.setStrokeWidth(this.flyZoneBorderWidth);
        }
        for (DJICircle djiCircle : this.customUnlockCircleMap.values()) {
            djiCircle.setStrokeWidth(this.flyZoneBorderWidth);
        }
    }

    private void updateCustomFlyZoneViews() {
        for (Map.Entry<String, DJICircle> entry : this.customUnlockCircleMap.entrySet()) {
            int zoneColor;
            int strokeColor;
            if (this.customUnlockFlyZoneShapeId.contains(entry.getKey())) {
                strokeColor = this.customUnlockColor;
                zoneColor = ColorUtils.setAlphaComponent((int)this.customUnlockColor, (int)this.customUnlockColorAlpha);
            } else if (this.customUnlockFlyZoneOnAircraftShapeId.contains(entry.getKey())) {
                strokeColor = this.customUnlockSentToAircraftColor;
                zoneColor = ColorUtils.setAlphaComponent((int)this.customUnlockSentToAircraftColor, (int)this.customUnlockSentToAircraftColorAlpha);
            } else {
                strokeColor = this.customUnlockEnabledColor;
                zoneColor = ColorUtils.setAlphaComponent((int)this.customUnlockEnabledColor, (int)this.customUnlockEnabledColorAlpha);
            }
            DJICircle flyZoneCircle = entry.getValue();
            flyZoneCircle.setFillColor(zoneColor);
            flyZoneCircle.setStrokeColor(strokeColor);
        }
    }

    public void updateLegendColor(ImageView imageView, int color2) {
        Drawable background = imageView.getBackground();
        if (background instanceof ShapeDrawable) {
            ((ShapeDrawable)background).getPaint().setColor(color2);
        } else if (background instanceof GradientDrawable) {
            ((GradientDrawable)background).setColor(color2);
        } else if (background instanceof ColorDrawable) {
            ((ColorDrawable)background).setColor(color2);
        }
    }

    public int getSelfUnlockAlpha() {
        return this.selfUnlockAlpha;
    }

    public void setSelfUnlockAlpha(int selfUnlockAlpha) {
        this.selfUnlockAlpha = selfUnlockAlpha;
        this.updateFlyZoneViews(FlyZoneCategory.AUTHORIZATION);
    }

    @ColorInt
    public int getSelfUnlockColor() {
        return this.selfUnlockColor;
    }

    public void setSelfUnlockColor(@ColorInt int selfUnlockColor) {
        this.selfUnlockColor = selfUnlockColor;
        this.updateFlyZoneViews(FlyZoneCategory.AUTHORIZATION);
    }

    public void setFlyZoneColor(@NonNull FlyZoneCategory category, @ColorInt int color2) {
        this.flyZoneColorMap.put(category, color2);
        this.updateFlyZoneViews(category);
    }

    @ColorInt
    public int getFlyZoneColor(@NonNull FlyZoneCategory category) {
        Integer color2 = this.flyZoneColorMap.get(category);
        return color2 != null ? color2 : 0;
    }

    public void setFlyZoneAlpha(@NonNull FlyZoneCategory category, @IntRange(from=0L, to=255L) int alpha) {
        this.flyZoneAlphaMap.put(category, alpha);
        this.updateFlyZoneViews(category);
    }

    @IntRange(from=0L, to=255L)
    public int getFlyZoneAlpha(@NonNull FlyZoneCategory category) {
        Integer alpha = this.flyZoneAlphaMap.get(category);
        return alpha != null ? alpha : 26;
    }

    public float getFlyZoneBorderWidth() {
        return this.flyZoneBorderWidth;
    }

    public void setFlyZoneBorderWidth(float width) {
        this.flyZoneBorderWidth = width;
        this.updateFlyZoneBorders();
    }

    @ColorInt
    public int getCustomUnlockFlyZoneColor() {
        return this.customUnlockColor;
    }

    public void setCustomUnlockFlyZoneColor(@ColorInt int customUnlockColor) {
        this.customUnlockColor = customUnlockColor;
        this.updateCustomFlyZoneViews();
    }

    @ColorInt
    public int getCustomUnlockFlyZoneSentToAircraftColor() {
        return this.customUnlockSentToAircraftColor;
    }

    public void setCustomUnlockFlyZoneSentToAircraftColor(@ColorInt int customUnlockSentToAircraftColor) {
        this.customUnlockSentToAircraftColor = customUnlockSentToAircraftColor;
        this.updateCustomFlyZoneViews();
    }

    @ColorInt
    public int getCustomUnlockFlyZoneEnabledColor() {
        return this.customUnlockEnabledColor;
    }

    public void setCustomUnlockFlyZoneEnabledColor(@ColorInt int customUnlockEnabledColor) {
        this.customUnlockEnabledColor = customUnlockEnabledColor;
        this.updateCustomFlyZoneViews();
    }

    public int getCustomUnlockFlyZoneAlpha() {
        return this.customUnlockColorAlpha;
    }

    public void setCustomUnlockFlyZoneAlpha(@IntRange(from=0L, to=255L) int customUnlockColorAlpha) {
        this.customUnlockColorAlpha = customUnlockColorAlpha;
        this.updateCustomFlyZoneViews();
    }

    public int getCustomUnlockFlyZoneSentToAircraftAlpha() {
        return this.customUnlockSentToAircraftColorAlpha;
    }

    public void setCustomUnlockFlyZoneSentToAircraftAlpha(@IntRange(from=0L, to=255L) int customUnlockSentToAircraftColorAlpha) {
        this.customUnlockSentToAircraftColorAlpha = customUnlockSentToAircraftColorAlpha;
        this.updateCustomFlyZoneViews();
    }

    public int getCustomUnlockFlyZoneEnabledAlpha() {
        return this.customUnlockEnabledColorAlpha;
    }

    public void setCustomUnlockFlyZoneEnabledAlpha(@IntRange(from=0L, to=255L) int customUnlockEnabledColorAlpha) {
        this.customUnlockEnabledColorAlpha = customUnlockEnabledColorAlpha;
        this.updateCustomFlyZoneViews();
    }

    @ColorInt
    public int getMaximumHeightColor() {
        return this.maximumHeightColor;
    }

    public void setMaximumHeightColor(@ColorInt int color2) {
        this.maximumHeightColor = color2;
        this.updateFlyZoneViews(FlyZoneCategory.WARNING);
        this.updateFlyZoneViews(FlyZoneCategory.ENHANCED_WARNING);
        this.updateFlyZoneViews(FlyZoneCategory.AUTHORIZATION);
        this.updateFlyZoneViews(FlyZoneCategory.RESTRICTED);
    }

    @IntRange(from=0L, to=255L)
    public int getMaximumHeightAlpha() {
        return this.maximumHeightAlpha;
    }

    public void setMaximumHeightAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.maximumHeightAlpha = alpha;
        this.updateFlyZoneViews(FlyZoneCategory.WARNING);
        this.updateFlyZoneViews(FlyZoneCategory.ENHANCED_WARNING);
        this.updateFlyZoneViews(FlyZoneCategory.AUTHORIZATION);
        this.updateFlyZoneViews(FlyZoneCategory.RESTRICTED);
    }

    public void setCustomUnlockSentToAircraftMarkerIcon(@NonNull Drawable drawable2) {
        this.customUnlockSentToAircraftImg = DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(drawable2));
        for (DJIMarker djiMarker : this.customUnlockMarkersSet) {
            djiMarker.setIcon(this.customUnlockSentToAircraftImg);
            djiMarker.setAnchor(this.customUnlockSentToAircraftImgXAnchor, this.customUnlockSentToAircraftImgYAnchor);
        }
    }

    public void setCustomUnlockSentToAircraftMarkerIcon(@NonNull Drawable drawable2, float x, float y) {
        this.customUnlockSentToAircraftImgXAnchor = x;
        this.customUnlockSentToAircraftImgYAnchor = y;
        this.setCustomUnlockSentToAircraftMarkerIcon(drawable2);
    }

    public void setCustomUnlockEnabledMarkerIcon(@NonNull Drawable drawable2) {
        this.customUnlockEnabledImg = DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(drawable2));
        for (DJIMarker djiMarker : this.customUnlockMarkersSet) {
            FlyZoneLicenseInfo customUnlockZone = this.customUnlockZonesOnAircraft.get(djiMarker.getTitle());
            if (!customUnlockZone.isEnabled()) continue;
            djiMarker.setIcon(this.customUnlockEnabledImg);
            djiMarker.setAnchor(this.customUnlockImgEnabledXAnchor, this.customUnlockImgEnabledYAnchor);
        }
    }

    public void setCustomUnlockEnabledMarkerIcon(@NonNull Drawable drawable2, float x, float y) {
        this.customUnlockImgEnabledXAnchor = x;
        this.customUnlockImgEnabledYAnchor = y;
        this.setCustomUnlockEnabledMarkerIcon(drawable2);
    }

    public void setSelfUnlockedMarkerIcon(@NonNull Drawable drawable2) {
        this.selfUnlockedImg = DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(drawable2));
        for (DJIMarker djiMarker : this.flyZoneUnlockedMarkerMap.values()) {
            djiMarker.setAnchor(this.selfUnlockedImgXAnchor, this.selfUnlockedImgYAnchor);
            djiMarker.setIcon(this.selfUnlockedImg);
        }
    }

    public void setSelfUnlockedMarkerIcon(@NonNull Drawable drawable2, float x, float y) {
        this.selfUnlockedImgXAnchor = x;
        this.selfUnlockedImgYAnchor = y;
        this.setSelfUnlockedMarkerIcon(drawable2);
    }

    public void setSelfLockedMarkerIcon(@NonNull Drawable drawable2) {
        this.selfLockedImg = DJIBitmapDescriptorFactory.fromBitmap(ViewUtil.getBitmapFromVectorDrawable(drawable2));
        for (DJIMarker djiMarker : this.flyZoneLockedMarkerMap.values()) {
            djiMarker.setAnchor(this.selfLockedImgXAnchor, this.selfLockedImgYAnchor);
            djiMarker.setIcon(this.selfLockedImg);
        }
    }

    public void setSelfLockedMarkerIcon(@NonNull Drawable drawable2, float x, float y) {
        this.selfLockedImgXAnchor = x;
        this.selfLockedImgYAnchor = y;
        this.setSelfLockedMarkerIcon(drawable2);
    }

    public boolean isTapToUnlockEnabled() {
        return this.isFlyZoneUnlockingEnabled;
    }

    public void setTapToUnlockEnabled(boolean isFlyZonesUnlockingEnabled) {
        this.isFlyZoneUnlockingEnabled = isFlyZonesUnlockingEnabled;
        for (DJIMarker flyZone : this.flyZoneLockedMarkerMap.values()) {
            flyZone.setVisible(isFlyZonesUnlockingEnabled);
        }
        for (DJIMarker flyZone : this.flyZoneUnlockedMarkerMap.values()) {
            flyZone.setVisible(isFlyZonesUnlockingEnabled);
        }
    }

    public boolean isCustomUnlockZonesVisible() {
        return this.customUnlockZonesVisibility;
    }

    public void setCustomUnlockZonesVisible(boolean isVisible) {
        this.customUnlockZonesVisibility = isVisible;
        for (DJICircle circle : this.customUnlockCircleMap.values()) {
            circle.setVisible(isVisible);
        }
        for (DJIMarker djiMarker : this.customUnlockMarkersSet) {
            djiMarker.setVisible(isVisible);
        }
    }
}

