/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.location;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.v5.utils.common.LocationUtil;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0015H\u0014R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Ldji/v5/ux/core/widget/location/LocationWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;)V", "aircraftLocationProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/sdk/keyvalue/value/common/LocationCoordinate2D;", "kotlin.jvm.PlatformType", "getAircraftLocationProcessor", "()Ldji/v5/ux/core/util/DataProcessor;", "locationStateProcessor", "Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState;", "locationState", "Lio/reactivex/rxjava3/core/Flowable;", "getLocationState", "()Lio/reactivex/rxjava3/core/Flowable;", "inSetup", "", "updateStates", "inCleanup", "LocationState", "android-sdk-v5-uxsdk_release"})
public final class LocationWidgetModel
extends WidgetModel {
    @NotNull
    private final DataProcessor<LocationCoordinate2D> aircraftLocationProcessor;
    @NotNull
    private final DataProcessor<LocationState> locationStateProcessor;

    public LocationWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        DataProcessor<LocationCoordinate2D> dataProcessor = DataProcessor.create(new LocationCoordinate2D(Double.valueOf(Double.NaN), Double.valueOf(Double.NaN)));
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.aircraftLocationProcessor = dataProcessor;
        DataProcessor<LocationState.ProductDisconnected> dataProcessor2 = DataProcessor.create(LocationState.ProductDisconnected.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.locationStateProcessor = dataProcessor2;
    }

    @NotNull
    public final DataProcessor<LocationCoordinate2D> getAircraftLocationProcessor() {
        return this.aircraftLocationProcessor;
    }

    @NotNull
    public final Flowable<LocationState> getLocationState() {
        Flowable<LocationState> flowable = this.locationStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftLocation), this.aircraftLocationProcessor);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void updateStates() {
        if (!((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            this.locationStateProcessor.onNext(LocationState.ProductDisconnected.INSTANCE);
            return;
        }
        Double d = this.aircraftLocationProcessor.getValue().getLatitude();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getLatitude(...)");
        if (LocationUtil.checkLatitude((double)((Number)d).doubleValue())) {
            Double d2 = this.aircraftLocationProcessor.getValue().getLongitude();
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"getLongitude(...)");
            if (LocationUtil.checkLongitude((double)((Number)d2).doubleValue())) {
                Double d3 = this.aircraftLocationProcessor.getValue().getLatitude();
                Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"getLatitude(...)");
                double d4 = ((Number)d3).doubleValue();
                Double d5 = this.aircraftLocationProcessor.getValue().getLongitude();
                Intrinsics.checkNotNullExpressionValue((Object)d5, (String)"getLongitude(...)");
                this.locationStateProcessor.onNext(new LocationState.CurrentLocation(d4, ((Number)d5).doubleValue()));
                return;
            }
        }
        this.locationStateProcessor.onNext(LocationState.LocationUnavailable.INSTANCE);
    }

    @Override
    protected void inCleanup() {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState;", "", "<init>", "()V", "ProductDisconnected", "LocationUnavailable", "CurrentLocation", "Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState$CurrentLocation;", "Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState$LocationUnavailable;", "Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState$ProductDisconnected;", "android-sdk-v5-uxsdk_release"})
    public static abstract class LocationState {
        private LocationState() {
        }

        public /* synthetic */ LocationState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState$CurrentLocation;", "Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState;", "latitude", "", "longitude", "<init>", "(DD)V", "getLatitude", "()D", "getLongitude", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class CurrentLocation
        extends LocationState {
            private final double latitude;
            private final double longitude;

            public CurrentLocation(double latitude, double longitude) {
                super(null);
                this.latitude = latitude;
                this.longitude = longitude;
            }

            public final double getLatitude() {
                return this.latitude;
            }

            public final double getLongitude() {
                return this.longitude;
            }

            public final double component1() {
                return this.latitude;
            }

            public final double component2() {
                return this.longitude;
            }

            @NotNull
            public final CurrentLocation copy(double latitude, double longitude) {
                return new CurrentLocation(latitude, longitude);
            }

            public static /* synthetic */ CurrentLocation copy$default(CurrentLocation currentLocation, double d, double d2, int n, Object object) {
                if ((n & 1) != 0) {
                    d = currentLocation.latitude;
                }
                if ((n & 2) != 0) {
                    d2 = currentLocation.longitude;
                }
                return currentLocation.copy(d, d2);
            }

            @NotNull
            public String toString() {
                return "CurrentLocation(latitude=" + this.latitude + ", longitude=" + this.longitude + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.latitude);
                result = result * 31 + Double.hashCode(this.longitude);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CurrentLocation)) {
                    return false;
                }
                CurrentLocation currentLocation = (CurrentLocation)other;
                if (Double.compare(this.latitude, currentLocation.latitude) != 0) {
                    return false;
                }
                return Double.compare(this.longitude, currentLocation.longitude) == 0;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState$LocationUnavailable;", "Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState;", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
        public static final class LocationUnavailable
        extends LocationState {
            @NotNull
            public static final LocationUnavailable INSTANCE = new LocationUnavailable();

            private LocationUnavailable() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState$ProductDisconnected;", "Ldji/v5/ux/core/widget/location/LocationWidgetModel$LocationState;", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
        public static final class ProductDisconnected
        extends LocationState {
            @NotNull
            public static final ProductDisconnected INSTANCE = new ProductDisconnected();

            private ProductDisconnected() {
                super(null);
            }
        }
    }
}

