/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.horizontalvelocity;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.common.Velocity3D;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferenceKeys;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.MathExtensions;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UnitConversionUtil;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0016H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "preferencesManager", "Ldji/v5/ux/core/communication/GlobalPreferencesInterface;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/communication/GlobalPreferencesInterface;)V", "aircraftVelocityProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/sdk/keyvalue/value/common/Velocity3D;", "unitTypeDataProcessor", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "horizontalVelocityStateProcessor", "Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel$HorizontalVelocityState;", "horizontalVelocityState", "Lio/reactivex/rxjava3/core/Flowable;", "getHorizontalVelocityState", "()Lio/reactivex/rxjava3/core/Flowable;", "inSetup", "", "updateStates", "inCleanup", "calculateHorizontalVelocity", "", "HorizontalVelocityState", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nHorizontalVelocityWidgetModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalVelocityWidgetModel.kt\ndji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class HorizontalVelocityWidgetModel
extends WidgetModel {
    @Nullable
    private final GlobalPreferencesInterface preferencesManager;
    @NotNull
    private final DataProcessor<Velocity3D> aircraftVelocityProcessor;
    @NotNull
    private final DataProcessor<UnitConversionUtil.UnitType> unitTypeDataProcessor;
    @NotNull
    private final DataProcessor<HorizontalVelocityState> horizontalVelocityStateProcessor;

    public HorizontalVelocityWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.preferencesManager = preferencesManager;
        DataProcessor<Velocity3D> dataProcessor = DataProcessor.create(new Velocity3D());
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.aircraftVelocityProcessor = dataProcessor;
        DataProcessor<UnitConversionUtil.UnitType> dataProcessor2 = DataProcessor.create(UnitConversionUtil.UnitType.METRIC);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.unitTypeDataProcessor = dataProcessor2;
        DataProcessor<HorizontalVelocityState.ProductDisconnected> dataProcessor3 = DataProcessor.create(HorizontalVelocityState.ProductDisconnected.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.horizontalVelocityStateProcessor = dataProcessor3;
    }

    @NotNull
    public final Flowable<HorizontalVelocityState> getHorizontalVelocityState() {
        Flowable<HorizontalVelocityState> flowable = this.horizontalVelocityStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        block1: {
            this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftVelocity), this.aircraftVelocityProcessor);
            this.bindDataProcessor(GlobalPreferenceKeys.create("UnitType"), this.unitTypeDataProcessor);
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface != null) {
                globalPreferencesInterface.setUpListener();
            }
            GlobalPreferencesInterface globalPreferencesInterface2 = this.preferencesManager;
            if (globalPreferencesInterface2 == null) break block1;
            GlobalPreferencesInterface it = globalPreferencesInterface2;
            boolean bl = false;
            this.unitTypeDataProcessor.onNext(it.getUnitType());
        }
    }

    @Override
    protected void updateStates() {
        if (((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            float f = this.calculateHorizontalVelocity();
            UnitConversionUtil.UnitType unitType = this.unitTypeDataProcessor.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
            this.horizontalVelocityStateProcessor.onNext(new HorizontalVelocityState.CurrentVelocity(f, unitType));
        } else {
            this.horizontalVelocityStateProcessor.onNext(HorizontalVelocityState.ProductDisconnected.INSTANCE);
        }
    }

    @Override
    protected void inCleanup() {
        block0: {
            GlobalPreferencesInterface globalPreferencesInterface = this.preferencesManager;
            if (globalPreferencesInterface == null) break block0;
            globalPreferencesInterface.cleanup();
        }
    }

    private final float calculateHorizontalVelocity() {
        Double d = this.aircraftVelocityProcessor.getValue().getX();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getX(...)");
        double d2 = ((Number)d).doubleValue();
        int n = 2;
        double d3 = Math.pow(d2, n);
        Double d4 = this.aircraftVelocityProcessor.getValue().getY();
        Intrinsics.checkNotNullExpressionValue((Object)d4, (String)"getY(...)");
        d2 = ((Number)d4).doubleValue();
        n = 2;
        double d5 = Math.sqrt(d3 + Math.pow(d2, n));
        UnitConversionUtil.UnitType unitType = this.unitTypeDataProcessor.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)unitType), (String)"getValue(...)");
        return (float)MathExtensions.toVelocity(d5, unitType);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel$HorizontalVelocityState;", "", "<init>", "()V", "ProductDisconnected", "CurrentVelocity", "Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel$HorizontalVelocityState$CurrentVelocity;", "Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel$HorizontalVelocityState$ProductDisconnected;", "android-sdk-v5-uxsdk_release"})
    public static abstract class HorizontalVelocityState {
        private HorizontalVelocityState() {
        }

        public /* synthetic */ HorizontalVelocityState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel$HorizontalVelocityState$CurrentVelocity;", "Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel$HorizontalVelocityState;", "velocity", "", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "<init>", "(FLdji/v5/ux/core/util/UnitConversionUtil$UnitType;)V", "getVelocity", "()F", "getUnitType", "()Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_release"})
        public static final class CurrentVelocity
        extends HorizontalVelocityState {
            private final float velocity;
            @NotNull
            private final UnitConversionUtil.UnitType unitType;

            public CurrentVelocity(float velocity, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                super(null);
                this.velocity = velocity;
                this.unitType = unitType;
            }

            public final float getVelocity() {
                return this.velocity;
            }

            @NotNull
            public final UnitConversionUtil.UnitType getUnitType() {
                return this.unitType;
            }

            public final float component1() {
                return this.velocity;
            }

            @NotNull
            public final UnitConversionUtil.UnitType component2() {
                return this.unitType;
            }

            @NotNull
            public final CurrentVelocity copy(float velocity, @NotNull UnitConversionUtil.UnitType unitType) {
                Intrinsics.checkNotNullParameter((Object)((Object)unitType), (String)"unitType");
                return new CurrentVelocity(velocity, unitType);
            }

            public static /* synthetic */ CurrentVelocity copy$default(CurrentVelocity currentVelocity, float f, UnitConversionUtil.UnitType unitType, int n, Object object) {
                if ((n & 1) != 0) {
                    f = currentVelocity.velocity;
                }
                if ((n & 2) != 0) {
                    unitType = currentVelocity.unitType;
                }
                return currentVelocity.copy(f, unitType);
            }

            @NotNull
            public String toString() {
                return "CurrentVelocity(velocity=" + this.velocity + ", unitType=" + this.unitType + ")";
            }

            public int hashCode() {
                int result = Float.hashCode(this.velocity);
                result = result * 31 + this.unitType.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CurrentVelocity)) {
                    return false;
                }
                CurrentVelocity currentVelocity = (CurrentVelocity)other;
                if (Float.compare(this.velocity, currentVelocity.velocity) != 0) {
                    return false;
                }
                return this.unitType == currentVelocity.unitType;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel$HorizontalVelocityState$ProductDisconnected;", "Ldji/v5/ux/core/widget/horizontalvelocity/HorizontalVelocityWidgetModel$HorizontalVelocityState;", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
        public static final class ProductDisconnected
        extends HorizontalVelocityState {
            @NotNull
            public static final ProductDisconnected INSTANCE = new ProductDisconnected();

            private ProductDisconnected() {
                super(null);
            }
        }
    }
}

