/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.Set;

public class UxSharedPreferencesUtil {
    public static final String PREF_KEY_UNIT = "pref_key_unit";
    private static volatile boolean INITIALIZED = false;
    private static String sUserId;
    private static SharedPreferences SP;

    private UxSharedPreferencesUtil() {
    }

    public static synchronized void initialize(Context context) {
        if (context == null || INITIALIZED) {
            return;
        }
        sUserId = "ux_" + context.getPackageName();
        SP = PreferenceManager.getDefaultSharedPreferences((Context)context);
        INITIALIZED = true;
    }

    public static void setEmptyUserId() {
        UxSharedPreferencesUtil.setUserId("");
    }

    public static void setUserId(String userId) {
        sUserId = userId;
    }

    public static SharedPreferences.Editor getEditor() {
        return SP.edit();
    }

    public static boolean contains(String key) {
        return SP.contains(key);
    }

    public static String getString(String key, String defValue, boolean user) {
        return SP.getString(user ? key + sUserId : key, defValue);
    }

    public static void putString(String key, String value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putString(user ? key + sUserId : key, value).apply();
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void commitString(String key, String value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putString(user ? key + sUserId : key, value).commit();
    }

    public static boolean getBoolean(String key, boolean defValue, boolean user) {
        return SP.getBoolean(user ? key + sUserId : key, defValue);
    }

    public static void putBoolean(String key, boolean value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putBoolean(user ? key + sUserId : key, value).apply();
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void commitBoolean(String key, boolean value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putBoolean(user ? key + sUserId : key, value).commit();
    }

    public static int getInt(String key, int defValue, boolean user) {
        return SP.getInt(user ? key + sUserId : key, defValue);
    }

    public static void putInt(String key, int value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putInt(user ? key + sUserId : key, value).apply();
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void commitInteger(String key, int value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putInt(user ? key + sUserId : key, value).commit();
    }

    public static long getLong(String key, long defValue, boolean user) {
        return SP.getLong(user ? key + sUserId : key, defValue);
    }

    public static void putLong(String key, long value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putLong(user ? key + sUserId : key, value).apply();
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void commitLong(String key, long value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putLong(user ? key + sUserId : key, value).commit();
    }

    public static float getFloat(String key, float defValue, boolean user) {
        return SP.getFloat(user ? key + sUserId : key, defValue);
    }

    public static void putFloat(String key, float value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putFloat(user ? key + sUserId : key, value).apply();
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void commitFloat(String key, float value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putFloat(user ? key + sUserId : key, value).commit();
    }

    public static double getDouble(String key, double defValue, boolean user) {
        if (!UxSharedPreferencesUtil.contains(key)) {
            return defValue;
        }
        return Double.longBitsToDouble(UxSharedPreferencesUtil.getLong(key, 0L, user));
    }

    public static void putDouble(String key, double value, boolean user) {
        UxSharedPreferencesUtil.putLong(key, Double.doubleToLongBits(value), user);
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void commitDouble(String key, double value, boolean user) {
        UxSharedPreferencesUtil.commitLong(key, Double.doubleToLongBits(value), user);
    }

    public static Set<String> getStringSet(String key, Set<String> defValue, boolean user) {
        return SP.getStringSet(user ? key + sUserId : key, defValue);
    }

    public static void putStringSet(String key, Set<String> value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putStringSet(user ? key + sUserId : key, value).apply();
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void commitStringSet(String key, Set<String> value, boolean user) {
        UxSharedPreferencesUtil.getEditor().putStringSet(user ? key + sUserId : key, value).commit();
    }

    public static void remove(String key, boolean user) {
        UxSharedPreferencesUtil.getEditor().remove(user ? key + sUserId : key).apply();
    }

    public static void commitRemove(String key, boolean user) {
        UxSharedPreferencesUtil.getEditor().remove(user ? key + sUserId : key).commit();
    }

    public static void remove(boolean user, String ... keys) {
        if (keys != null && keys.length > 0) {
            for (String key : keys) {
                UxSharedPreferencesUtil.remove(key, user);
            }
        }
    }

    public static void clear() {
        UxSharedPreferencesUtil.getEditor().clear().apply();
    }

    public static void commitClear() {
        UxSharedPreferencesUtil.getEditor().clear().commit();
    }
}

