/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.location.Location;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Size;
import android.view.ViewDebug;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.common.LocationCoordinate3D;
import dji.v5.common.utils.UnitUtils;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LocationUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.hsi.HSICompassProcesser;
import dji.v5.ux.core.ui.hsi.HSIContract;
import dji.v5.ux.core.ui.hsi.HSIMarkerLayer;
import dji.v5.ux.core.ui.hsi.HSIView;
import dji.v5.ux.core.ui.hsi.HSIWidgetModel;
import dji.v5.ux.core.ui.hsi.dashboard.FpvStrokeConfig;
import dji.v5.ux.core.util.DrawUtils;
import dji.v5.ux.mapkit.core.utils.DJIGpsUtils;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.concurrent.CopyOnWriteArrayList;

public class HSIMarkerLayer
implements HSIContract.HSILayer {
    @NonNull
    private static final Path PATH = new Path();
    private static final int MAX_DISPLAY_DISTANCE_NUMBER = 999;
    private static final float FLOAT_THRESHOLD = 1.0E-6f;
    private static final int HSI_HOME_RC_MERGE_THRESHOLD = 5;
    @NonNull
    private HSIContract.HSIContainer mHSIContainer;
    @NonNull
    private final float[] mFloats = new float[2];
    @NonNull
    private final Bitmap mHomePointBitmap;
    private final Bitmap mHomePointCornerBitmap;
    private final int mHomePointMarkerSize;
    @NonNull
    private final Bitmap mWayPointBitmap;
    @ViewDebug.ExportedProperty(category="dji")
    private final int mMarkerIndicatorTextSize;
    private float mMarkerIndicatorTextMaxWidth;
    @NonNull
    private final Bitmap mRngPointBitmap;
    @NonNull
    private final Bitmap mSmartTrackPointBitmap;
    private final Bitmap mRemoteControlPointBitmap;
    private final Bitmap mRemoteControlDirectionNormalBitmap;
    private final Bitmap mRemoteControlDirectionMergeBitmap;
    @NonNull
    private Bitmap mAdsbRedBitmap;
    @NonNull
    private Bitmap mAdsbYellowBitmap;
    private final int mAdsbMarkerSize;
    private final int mMarkerMarginVertical;
    private final int mMarkerMarginHorizontal;
    private int mMarkerNameInset;
    private float mMarkerNameTriangleWidth;
    private float mMarkerNameTriangleHeight;
    @NonNull
    private final BehaviorSubject<LocationCoordinate3D> mSubject = BehaviorSubject.create();
    @Nullable
    private LocationCoordinate3D mAircraftLocation;
    @Nullable
    private LocationCoordinate2D mHomeLocation;
    @NonNull
    private IndicatorInfo mHomeInfo = new IndicatorInfo();
    @NonNull
    private IndicatorInfo mRngInfo = new IndicatorInfo();
    private IndicatorInfo mSelectPinInfo = new IndicatorInfo(true);
    @NonNull
    private IndicatorInfo mSmartTrackInfo = new IndicatorInfo();
    @NonNull
    private IndicatorInfo mWayPointInfo = new IndicatorInfo();
    @NonNull
    private IndicatorInfo mRemoteControlInfo = new IndicatorInfo();
    private IndicatorInfo mRemoteControlDirectionInfo = new IndicatorInfo();
    HSICompassProcesser mCompassProcesser;
    @NonNull
    private final CopyOnWriteArrayList<BearingDistance> mAdsbYellowDistances = new CopyOnWriteArrayList();
    @NonNull
    private final CopyOnWriteArrayList<BearingDistance> mAdsbRedDistances = new CopyOnWriteArrayList();
    private Paint mStrokePaint = new Paint(5);
    @Nullable
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    private Location mLastLocation;
    private float mRcDegree;
    FpvStrokeConfig mStrokeConfig;
    @NonNull
    private HSIWidgetModel widgetModel;
    private static final int INDICATOR_ALIGN_LEFT = 0;
    private static final int INDICATOR_ALIGN_RIGHT = 1;
    private static final int INDICATOR_ALIGN_TOP = 2;
    private static final int INDICATOR_ALIGN_BOTTOM = 3;

    public HSIMarkerLayer(@NonNull Context context, @Nullable AttributeSet attrs, @NonNull HSIContract.HSIContainer container, HSIWidgetModel widgetModel) {
        this.mHSIContainer = container;
        this.mStrokeConfig = new FpvStrokeConfig(context);
        this.widgetModel = widgetModel;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.HSIView);
        this.mHomePointMarkerSize = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_home_point_marker_size, 0);
        this.mHomePointBitmap = DrawUtils.drawableRes2Bitmap(typedArray.getResourceId(R.styleable.HSIView_uxsdk_hsi_home_point_marker, R.drawable.uxsdk_fpv_pfd_hsi_home_point));
        this.mHomePointCornerBitmap = DrawUtils.drawableRes2Bitmap(typedArray.getResourceId(R.styleable.HSIView_uxsdk_hsi_home_point_marker, R.drawable.uxsdk_fpv_hsi_compass_home_point));
        this.mWayPointBitmap = DrawUtils.drawableRes2Bitmap(typedArray.getResourceId(R.styleable.HSIView_uxsdk_hsi_waypoint_marker, R.drawable.uxsdk_fpv_hsi_waypoint));
        int remoteControlRes = typedArray.getResourceId(R.styleable.HSIView_uxsdk_hsi_remote_control_point_marker, R.drawable.uxsdk_fpv_hsi_rc);
        this.mRemoteControlPointBitmap = DrawUtils.drawableRes2Bitmap(remoteControlRes);
        this.mSmartTrackPointBitmap = DrawUtils.drawableRes2Bitmap(typedArray.getResourceId(R.styleable.HSIView_uxsdk_hsi_smart_track_point_marker, R.drawable.uxsdk_fpv_hsi_smart_track_point));
        this.mRngPointBitmap = DrawUtils.drawableRes2Bitmap(typedArray.getResourceId(R.styleable.HSIView_uxsdk_hsi_rng_point_marker, R.drawable.uxsdk_fpv_hsi_rng_point));
        this.mAdsbMarkerSize = context.getResources().getDimensionPixelSize(R.dimen.uxsdk_10_dp);
        this.mAdsbRedBitmap = DrawUtils.drawableRes2Bitmap(R.drawable.uxsdk_fpv_hsi_plane_danger);
        this.mAdsbYellowBitmap = DrawUtils.drawableRes2Bitmap(R.drawable.uxsdk_fpv_hsi_plane_caution);
        this.mMarkerMarginHorizontal = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_marker_margin_horizontal, context.getResources().getDimensionPixelSize(R.dimen.uxsdk_2_dp));
        this.mMarkerNameInset = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_marker_name_inset, context.getResources().getDimensionPixelSize(R.dimen.uxsdk_4_dp));
        this.mMarkerMarginVertical = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_marker_margin_vertical, 0);
        this.mMarkerIndicatorTextSize = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_marker_indicator_text_size, context.getResources().getDimensionPixelSize(R.dimen.uxsdk_8_dp));
        this.mMarkerIndicatorTextMaxWidth = typedArray.getDimensionPixelSize(R.styleable.HSIView_uxsdk_hsi_marker_indicator_text_max_width, context.getResources().getDimensionPixelSize(R.dimen.uxsdk_60_dp));
        typedArray.recycle();
        this.mStrokePaint.setStrokeWidth(this.mStrokeConfig.getStrokeBoldWidth());
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setColor(this.mStrokeConfig.getStrokeDeepColor());
        this.mMarkerNameTriangleWidth = context.getResources().getDimension(R.dimen.uxsdk_4_dp);
        this.mMarkerNameTriangleHeight = context.getResources().getDimension(R.dimen.uxsdk_6_dp);
        this.mSelectPinInfo.textSize = this.mMarkerIndicatorTextSize;
        this.mSelectPinInfo.horizontalAlign = 0;
        this.mSelectPinInfo.verticalAlign = 3;
        this.mSelectPinInfo.textOffset.set(0, (int)this.mHSIContainer.getDegreeIndicatorHeight());
        this.mHomeInfo.textSize = this.mMarkerIndicatorTextSize;
        this.mHomeInfo.horizontalAlign = 1;
        this.mHomeInfo.verticalAlign = 3;
        this.mHomeInfo.marker = this.mHomePointBitmap;
        this.mHomeInfo.cornerMarker = this.mHomePointCornerBitmap;
        this.mHomeInfo.markSize = this.mHomePointMarkerSize;
        this.mHomeInfo.textOffset.set(0, (int)this.mHSIContainer.getDegreeIndicatorHeight());
        this.mRngInfo.textSize = this.mMarkerIndicatorTextSize;
        this.mRngInfo.horizontalAlign = 1;
        this.mRngInfo.verticalAlign = 2;
        this.mRngInfo.marker = this.mRngPointBitmap;
        this.mRngInfo.showInHsi = false;
        this.mRngInfo.textOffset.set(0, (int)(-this.mHSIContainer.getDegreeIndicatorHeight()));
        this.mSmartTrackInfo.textSize = this.mMarkerIndicatorTextSize;
        this.mSmartTrackInfo.horizontalAlign = 1;
        this.mSmartTrackInfo.verticalAlign = 2;
        this.mSmartTrackInfo.marker = this.mSmartTrackPointBitmap;
        this.mSmartTrackInfo.showInHsi = false;
        this.mSmartTrackInfo.textOffset.set(0, (int)(-this.mHSIContainer.getDegreeIndicatorHeight()));
        this.mWayPointInfo.textColor = context.getResources().getColor(R.color.uxsdk_blue_highlight);
        this.mWayPointInfo.textSize = this.mMarkerIndicatorTextSize;
        this.mWayPointInfo.horizontalAlign = 0;
        this.mWayPointInfo.verticalAlign = 2;
        this.mWayPointInfo.marker = this.mWayPointBitmap;
        this.mWayPointInfo.textOffset.set(0, (int)(-this.mHSIContainer.getDegreeIndicatorHeight()));
        this.mRemoteControlInfo.textSize = this.mMarkerIndicatorTextSize;
        this.mRemoteControlInfo.marker = this.mRemoteControlPointBitmap;
        this.mRemoteControlInfo.showOnCorner = false;
        this.mRemoteControlDirectionNormalBitmap = DrawUtils.drawableRes2Bitmap(R.drawable.uxsdk_fpv_hsi_rc_arrow);
        this.mRemoteControlDirectionMergeBitmap = DrawUtils.drawableRes2Bitmap(R.drawable.uxsdk_fpv_hsi_home_arrow);
        this.mRemoteControlDirectionInfo.showOnCorner = false;
        this.mCompassProcesser = new HSICompassProcesser(context, this::onRcDegreeChanged);
    }

    public void onRcDegreeChanged(int strength, float degree) {
        this.mRemoteControlDirectionInfo.showInHsi = strength > 1;
        this.mRcDegree = degree;
    }

    @Override
    public void onStart() {
        this.mCompositeDisposable = new CompositeDisposable();
        this.startListenAircraftLocation();
        this.startListenHomeLocation();
        this.startListenSmartTrackIfNeed();
        this.startListenRc();
        this.mCompassProcesser.start();
    }

    private void startListenAircraftLocation() {
        this.addDisposable(this.widgetModel.getAircraftLocationDataProcessor().toFlowable().subscribe(location -> {
            if (location != null) {
                this.mAircraftLocation = location;
                if (this.mHomeLocation != null) {
                    this.updateLocation(this.mHomeInfo.distance, this.mHomeLocation.getLatitude(), this.mHomeLocation.getLongitude());
                }
                this.mSubject.onNext((Object)this.mAircraftLocation);
            }
        }));
    }

    private void startListenHomeLocation() {
        this.addDisposable(this.widgetModel.getHomeLocationDataProcessor().toFlowable().subscribe(locationCoordinate2D -> {
            this.mHomeLocation = locationCoordinate2D;
            if (this.mHomeLocation == null) {
                return;
            }
            if (this.mLastLocation == null) {
                this.mLastLocation = new Location("HomeLocation");
                this.mLastLocation.setLongitude(this.mHomeLocation.getLongitude().doubleValue());
                this.mLastLocation.setLatitude(this.mHomeLocation.getLatitude().doubleValue());
                if (!this.mRemoteControlInfo.distance.isValidate()) {
                    this.updateLocation(this.mRemoteControlInfo.distance, this.mLastLocation.getLatitude(), this.mLastLocation.getLongitude());
                }
            }
            this.mHomeInfo.distance.mLatitude = this.mHomeLocation.getLatitude();
            this.mHomeInfo.distance.mLongitude = this.mHomeLocation.getLongitude();
            this.updateLocation(this.mHomeInfo.distance, this.mHomeLocation.getLatitude(), this.mHomeLocation.getLongitude());
        }));
    }

    private void startListenRc() {
        this.mLastLocation = LocationUtil.getLastLocation();
        this.addDisposable(this.mSubject.doOnNext(myLocation -> {
            Location location = this.mLastLocation;
            if (location != null && DJIGpsUtils.isAvailable(location.getLatitude(), location.getLongitude())) {
                this.updateLocation(this.mRemoteControlInfo.distance, location.getLatitude(), location.getLongitude());
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribeOn(Schedulers.computation()).subscribe());
        this.mCompositeDisposable.add(this.widgetModel.getLocationDataProcessor().toFlowable().subscribe(location -> {
            this.mLastLocation = location;
            this.updateLocation(this.mRemoteControlInfo.distance, location.getLatitude(), location.getLongitude());
        }));
    }

    private void startListenSmartTrackIfNeed() {
    }

    @Override
    public void onStop() {
        this.mCompassProcesser.stop();
        if (this.mCompositeDisposable != null && !this.mCompositeDisposable.isDisposed()) {
            this.mCompositeDisposable.dispose();
            this.mCompositeDisposable = null;
        }
    }

    @Override
    public void enterFpvMode(boolean fpv) {
    }

    @Override
    public void draw(Canvas canvas, Paint paint, int compassSize) {
        canvas.save();
        canvas.translate(0.0f, (float)compassSize / 2.0f);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(-1);
        if (this.isAircraftLocationAvailable()) {
            boolean mergeRc = this.mergeRcAndHome();
            if (!mergeRc) {
                this.drawRemoteControlPoint(canvas, paint, compassSize);
            }
            this.drawRemoteControlDirection(canvas, paint, compassSize, mergeRc);
            this.drawHomePoint(canvas, paint, compassSize);
            this.drawAdsbPoint(canvas, paint, compassSize);
        }
        canvas.restore();
    }

    private void drawRemoteControlDirection(Canvas canvas, Paint paint, int compassSize, boolean mergeRc) {
        IndicatorInfo draw = this.mRemoteControlDirectionInfo;
        IndicatorInfo from = mergeRc ? this.mHomeInfo : this.mRemoteControlInfo;
        draw.marker = mergeRc ? this.mRemoteControlDirectionMergeBitmap : this.mRemoteControlDirectionNormalBitmap;
        draw.distance.mDistance = from.distance.mDistance;
        draw.distance.mInitialBearing = from.distance.mInitialBearing;
        draw.markerRotate = this.mRcDegree - this.mHSIContainer.getCurrentDegree();
        this.drawIndicatorInfo(canvas, paint, compassSize, draw);
    }

    private boolean mergeRcAndHome() {
        if (this.mHomeInfo.distance.isValidate() && this.mRemoteControlInfo.distance.isValidate()) {
            float[] results = new float[1];
            Location.distanceBetween((double)this.mLastLocation.getLatitude(), (double)this.mLastLocation.getLongitude(), (double)this.mHomeInfo.distance.mLatitude, (double)this.mHomeInfo.distance.mLongitude, (float[])results);
            return results[0] < 5.0f;
        }
        return false;
    }

    private void addDisposable(Disposable disposable) {
        if (disposable == null) {
            return;
        }
        if (this.mCompositeDisposable != null && !this.mCompositeDisposable.isDisposed()) {
            this.mCompositeDisposable.add(disposable);
        }
    }

    private void updateLocation(BearingDistance target, double latitude, double longitude) {
        if (!this.isAircraftLocationAvailable() || !this.isAvailable(latitude, longitude)) {
            target.setInvalid();
            return;
        }
        if (this.mAircraftLocation == null) {
            return;
        }
        Location.distanceBetween((double)this.mAircraftLocation.getLatitude(), (double)this.mAircraftLocation.getLongitude(), (double)latitude, (double)longitude, (float[])this.mFloats);
        target.mDistance = this.mFloats[0];
        target.mInitialBearing = this.mFloats[1];
    }

    private boolean isAircraftLocationAvailable() {
        return this.mAircraftLocation != null && this.isAvailable(this.mAircraftLocation.getLatitude(), this.mAircraftLocation.getLongitude());
    }

    @NonNull
    private Size getScaleBitmapSize(Bitmap pinPointBitmap, int markerSize) {
        int width = pinPointBitmap.getWidth();
        int height = pinPointBitmap.getHeight();
        if (markerSize == 0) {
            return new Size(width, height);
        }
        if (height > width) {
            return new Size(Math.round((float)width * (float)markerSize / (float)height), markerSize);
        }
        return new Size(markerSize, Math.round((float)height * (float)markerSize / (float)width));
    }

    private void drawRemoteControlPoint(Canvas canvas, Paint paint, int compassSize) {
        BearingDistance distance = this.mRemoteControlInfo.distance;
        if (distance == null || !distance.isValidate()) {
            return;
        }
        Bitmap bitmap = this.mRemoteControlPointBitmap;
        if (bitmap == null) {
            return;
        }
        this.drawIndicatorInfo(canvas, paint, compassSize, this.mRemoteControlInfo);
    }

    private void drawHomePoint(Canvas canvas, Paint paint, int compassSize) {
        IndicatorInfo indicatorInfo = this.mHomeInfo;
        this.drawIndicatorInfo(canvas, paint, compassSize, indicatorInfo);
    }

    private void drawIndicatorInfo(Canvas canvas, Paint paint, int compassSize, IndicatorInfo indicatorInfo) {
        if (!indicatorInfo.distance.isValidate()) {
            return;
        }
        if (indicatorInfo.showInHsi) {
            canvas.save();
            this.drawMarkerOnHsi(canvas, compassSize, indicatorInfo.distance, false);
            this.drawMarker(canvas, indicatorInfo.markerRotate, indicatorInfo.marker, this.getScaleBitmapSize(indicatorInfo.marker, indicatorInfo.markSize), indicatorInfo.markerOffset, paint, false);
            canvas.restore();
        }
        if (indicatorInfo.showOnCorner) {
            this.drawMarkerIndicator(canvas, compassSize, indicatorInfo.textOffset, indicatorInfo.cornerMarker != null ? indicatorInfo.cornerMarker : indicatorInfo.marker, indicatorInfo, paint);
        }
    }

    private void drawAdsbPoint(Canvas canvas, Paint paint, int compassSize) {
        for (BearingDistance adsbDistance : this.mAdsbYellowDistances) {
            canvas.save();
            this.drawMarkerOnHsi(canvas, compassSize, adsbDistance, true);
            this.drawMarker(canvas, this.mAdsbYellowBitmap, new Size(this.mAdsbMarkerSize, this.mAdsbMarkerSize), new PointF(0.0f, 0.0f), paint, true);
            canvas.restore();
        }
    }

    private float transformDegreePointToDrone(float initialBearing) {
        float degree = -this.mHSIContainer.getCurrentDegree() + initialBearing;
        if (degree > 180.0f) {
            degree -= 360.0f;
        }
        return 180.0f + degree;
    }

    private void drawMarkerOnHsi(Canvas canvas, int compassSize, BearingDistance distance, boolean isPointToDrone) {
        if (distance == null || !distance.isValidate()) {
            return;
        }
        canvas.rotate(-this.mHSIContainer.getCurrentDegree() + distance.mInitialBearing);
        float ratio = distance.mDistance / (float)this.mHSIContainer.getVisibleDistanceInHsiInMeters();
        if (ratio > 1.0f || isPointToDrone) {
            ratio = 1.0f;
        }
        canvas.translate(0.0f, -((float)compassSize / 2.0f - this.mHSIContainer.getCalibrationAreaWidth() - this.mHSIContainer.getCompassBitmapOffset()) * ratio);
        canvas.rotate(-(-this.mHSIContainer.getCurrentDegree() + distance.mInitialBearing));
        if (isPointToDrone) {
            canvas.rotate(this.transformDegreePointToDrone(distance.mInitialBearing));
        }
    }

    private void drawMarker(Canvas canvas, Bitmap marker, Size size, PointF position, Paint paint, boolean isPointToDrone) {
        this.drawMarker(canvas, 0.0f, marker, size, position, paint, isPointToDrone);
    }

    private void drawMarker(Canvas canvas, float rotate, Bitmap marker, Size size, PointF position, Paint paint, boolean isPointToDrone) {
        int flag = paint.getFlags();
        paint.setFlags(flag | 2);
        canvas.save();
        int offsetX = size.getWidth() / 2;
        int offsetY = isPointToDrone ? 0 : size.getHeight() / 2;
        canvas.translate(position.x, position.y);
        HSIView.RECT.set(0, 0, marker.getWidth(), marker.getHeight());
        HSIView.RECT2.set(-offsetX, -offsetY, -offsetX + size.getWidth(), -offsetY + size.getHeight());
        if (this.needRotateCanvas(rotate)) {
            canvas.rotate(rotate);
        }
        canvas.drawBitmap(marker, HSIView.RECT, HSIView.RECT2, paint);
        canvas.restore();
        paint.setFlags(flag);
    }

    private boolean needRotateCanvas(float rotate) {
        return rotate > 1.0E-6f || rotate < -1.0E-6f;
    }

    private void drawMarkerIndicator(Canvas canvas, int compassSize, Point position, Bitmap marker, IndicatorInfo indicatorInfo, Paint paint) {
        if (indicatorInfo.distance == null || !indicatorInfo.distance.isValidate()) {
            return;
        }
        canvas.save();
        float radius = (float)compassSize / 2.0f;
        canvas.translate((float)position.x + (indicatorInfo.horizontalAlign == 0 ? -radius : radius), (float)position.y + (indicatorInfo.verticalAlign == 2 ? -radius : radius));
        this.drawMarkerIndicatorContent(canvas, marker, indicatorInfo, paint);
        canvas.restore();
    }

    private void drawMarkerIndicatorContent(Canvas canvas, Bitmap marker, IndicatorInfo indicatorInfo, Paint paint) {
        int textSize = indicatorInfo.textSize;
        BearingDistance distance = indicatorInfo.distance;
        canvas.save();
        String text = this.getText(distance.mDistance);
        paint.setColor(-1);
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize((float)textSize);
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        int horizontalAlign = indicatorInfo.horizontalAlign;
        int verticalAlign = indicatorInfo.verticalAlign;
        canvas.translate(horizontalAlign == 0 ? (float)(-this.mMarkerMarginHorizontal) : (float)this.mMarkerMarginHorizontal, verticalAlign == 2 ? (float)this.mMarkerMarginVertical : (float)(-this.mMarkerMarginVertical));
        paint.setTextAlign(horizontalAlign == 0 ? Paint.Align.LEFT : Paint.Align.RIGHT);
        if (verticalAlign == 2) {
            canvas.translate(0.0f, -fontMetrics.ascent);
            this.drawTextWithStroke(canvas, 0, 0.0f, text, paint);
            canvas.translate(0.0f, fontMetrics.descent);
        } else {
            canvas.translate(0.0f, -fontMetrics.descent);
            this.drawTextWithStroke(canvas, 0, 0.0f, text, paint);
            canvas.translate(0.0f, fontMetrics.ascent - (float)marker.getHeight());
        }
        int flag = paint.getFlags();
        paint.setFlags(flag | 2);
        canvas.drawBitmap(marker, horizontalAlign == 0 ? 0.0f : (float)(-marker.getWidth()), 0.0f, paint);
        Bitmap markerSecondary = indicatorInfo.cornerMarkerSecondary;
        if (markerSecondary != null) {
            canvas.drawBitmap(markerSecondary, horizontalAlign == 0 ? (float)marker.getWidth() : (float)(-marker.getWidth() - markerSecondary.getWidth()), (float)(marker.getHeight() - markerSecondary.getHeight()) / 2.0f, paint);
        }
        paint.setFlags(flag);
        canvas.restore();
        float offsetY = fontMetrics.descent - fontMetrics.ascent + (float)marker.getHeight() / 2.0f - (float)this.mMarkerMarginVertical;
        this.drawName(canvas, indicatorInfo, paint, distance, offsetY);
    }

    private void drawName(Canvas canvas, IndicatorInfo indicatorInfo, Paint paint, BearingDistance distance, float centerY) {
        String name = distance.mName;
        if (!TextUtils.isEmpty((CharSequence)name)) {
            float textWidth;
            float textHeight;
            paint.setTextAlign(Paint.Align.LEFT);
            TextPaint textPaint = new TextPaint(paint);
            int firstLineCount = textPaint.breakText(name, true, this.mMarkerIndicatorTextMaxWidth, null);
            String firstLine = name.substring(0, firstLineCount);
            String secondLine = null;
            if (firstLineCount != name.length()) {
                secondLine = TextUtils.ellipsize((CharSequence)name.substring(firstLineCount), (TextPaint)textPaint, (float)this.mMarkerIndicatorTextMaxWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString();
            }
            boolean multiLine = secondLine != null;
            Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
            float height = fontMetrics.descent - fontMetrics.ascent;
            float baselineOffset = height / 2.0f - fontMetrics.descent;
            Rect rect = HSIView.RECT;
            if (multiLine) {
                textHeight = height * 2.0f;
                rect.set(0, 0, Math.round(this.mMarkerIndicatorTextMaxWidth), Math.round(textHeight));
                textWidth = this.mMarkerIndicatorTextMaxWidth;
            } else {
                textHeight = height;
                textWidth = paint.measureText(name);
                rect.set(0, 0, Math.round(textWidth), Math.round(textHeight));
            }
            int textColor = indicatorInfo.textColor;
            paint.setColor(textColor);
            Rect bgRect = HSIView.RECT2;
            bgRect.set(rect);
            bgRect.inset(-this.mMarkerNameInset, -this.mMarkerNameInset);
            float bgOffset = this.getNameBgOffset(distance);
            int horizontalAlign = indicatorInfo.horizontalAlign;
            float dx = this.getNameOffsetX(textWidth, bgOffset, horizontalAlign);
            float dy = this.getNameOffsetY(indicatorInfo, centerY, textHeight);
            canvas.translate(dx, dy);
            if (distance.mDrawBg) {
                this.drawNameBg(canvas, bgRect, paint, horizontalAlign == 0);
            }
            if (multiLine) {
                float baseline = (float)(rect.top * 3 + rect.bottom) / 4.0f + baselineOffset;
                this.drawTextWithStroke(canvas, 0, baseline, firstLine, paint);
                this.drawTextWithStroke(canvas, 0, baseline += (float)rect.height() / 2.0f, secondLine, paint);
            } else {
                float baseline = (float)rect.centerY() + baselineOffset;
                this.drawTextWithStroke(canvas, 0, baseline, name, paint);
            }
        }
    }

    private float getNameBgOffset(BearingDistance distance) {
        return distance.mDrawBg ? this.mMarkerNameTriangleWidth + (float)this.mMarkerNameInset + (float)this.mMarkerMarginHorizontal : 0.0f;
    }

    private float getNameOffsetX(float textWidth, float bgOffset, int horizontalAlign) {
        float dx = horizontalAlign == 0 ? (float)(-this.mMarkerMarginHorizontal) - textWidth - bgOffset : (float)this.mMarkerMarginHorizontal + bgOffset;
        return dx;
    }

    private float getNameOffsetY(IndicatorInfo indicatorInfo, float centerY, float textHeight) {
        int verticalAlign = indicatorInfo.verticalAlign;
        float dy = verticalAlign == 2 ? Math.max(centerY - textHeight / 2.0f, 0.0f) : Math.min(-centerY - textHeight / 2.0f, -textHeight);
        return dy;
    }

    private void drawNameBg(Canvas canvas, Rect bgRect, Paint paint, boolean alignLeft) {
        Paint.Style style2 = paint.getStyle();
        int color2 = paint.getColor();
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(AndUtil.getResColor((int)R.color.uxsdk_black_60_percent));
        canvas.drawRoundRect((float)bgRect.left, (float)bgRect.top, (float)bgRect.right, (float)bgRect.bottom, 5.0f, 5.0f, paint);
        Path path = PATH;
        path.reset();
        float offset = this.mMarkerNameTriangleHeight / 2.0f;
        int lineX = alignLeft ? bgRect.right : bgRect.left;
        float pointX = alignLeft ? (float)bgRect.right + this.mMarkerNameTriangleWidth : (float)bgRect.left - this.mMarkerNameTriangleWidth;
        path.moveTo((float)lineX, (float)bgRect.centerY() + offset);
        path.lineTo(pointX, (float)bgRect.centerY());
        path.lineTo((float)lineX, (float)bgRect.centerY() - offset);
        path.close();
        canvas.drawPath(path, paint);
        paint.setStyle(style2);
        paint.setColor(color2);
    }

    private void drawTextWithStroke(Canvas canvas, int x, float baseline, String text, Paint paint) {
        this.mStrokePaint.setTypeface(paint.getTypeface());
        this.mStrokePaint.setTextSize(paint.getTextSize());
        this.mStrokePaint.setTextAlign(paint.getTextAlign());
        canvas.drawText(text, (float)x, baseline, this.mStrokePaint);
        canvas.drawText(text, (float)x, baseline, paint);
    }

    private String getText(float value) {
        String unit;
        String extra = "";
        boolean hasDecimals = false;
        if (!UnitUtils.isMetricUnits()) {
            value = UnitUtils.getValueFromMetricByLength((float)value, (UnitUtils.UnitType)UnitUtils.UnitType.IMPERIAL);
            unit = UnitUtils.getUintStrByLength((UnitUtils.UnitType)UnitUtils.UnitType.IMPERIAL);
            if (UnitUtils.moreThanMile((float)(value + 0.5f))) {
                unit = "mi";
                boolean bl = hasDecimals = (value = UnitUtils.footToMile((float)value)) < 99.5f;
                if (value > 999.0f) {
                    extra = "+";
                    value = 999.0f;
                }
            }
        } else {
            unit = UnitUtils.getUintStrByLength((UnitUtils.UnitType)UnitUtils.UnitType.METRIC);
            if (value + 0.5f >= 1000.0f) {
                extra = "k";
                boolean bl = hasDecimals = (value /= 1000.0f) < 99.95f;
                if (value > 999.0f) {
                    value = 999.0f;
                    extra = "+k";
                }
            }
        }
        if (hasDecimals) {
            return "" + (float)Math.round(value * 10.0f) / 10.0f + extra + unit;
        }
        return "" + Math.round(value) + extra + unit;
    }

    public boolean isAvailable(double latitude, double longitude) {
        return Math.abs(latitude) > 1.0E-7 && Math.abs(longitude) > 1.0E-7 && Math.abs(latitude) <= 90.0 && Math.abs(longitude) <= 180.0;
    }

    private static class IndicatorInfo {
        int textColor;
        int textSize;
        BearingDistance distance;
        int markSize;
        PointF markerOffset = new PointF();
        Point textOffset = new Point();
        Bitmap marker;
        Bitmap cornerMarker;
        Bitmap cornerMarkerSecondary;
        float markerRotate;
        boolean showInHsi = true;
        boolean showOnCorner = true;
        @IndicatorAlign
        int horizontalAlign;
        @IndicatorAlign
        int verticalAlign;

        private IndicatorInfo() {
            this(false);
        }

        private IndicatorInfo(boolean drawNameBg) {
            this.distance = new BearingDistance();
            this.distance.mDrawBg = drawNameBg;
        }
    }

    private static class BearingDistance {
        private static final float INVALID_DISTANCE = -1.0f;
        private float mDistance = -1.0f;
        private float mInitialBearing = 0.0f;
        private double mLatitude;
        private double mLongitude;
        private boolean mDrawBg = false;
        private String mName;

        private BearingDistance() {
        }

        boolean isValidate() {
            return this.mDistance >= 0.0f && !Float.isNaN(this.mDistance);
        }

        void setInvalid() {
            this.mDistance = -1.0f;
        }
    }
}

