/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DividerLayout;

public class DividerRelativeLayout
extends RelativeLayout
implements DividerLayout {
    private boolean mTopDividerEnable;
    private boolean mBottomDividerEnable;
    private int mBottomDividerColor;
    private int mBottomDividerHeight;
    private int mTopDividerMarginLeft;
    private int mBottomDividerMarginLeft;
    private Paint sPaint = new Paint();

    public DividerRelativeLayout(Context context) {
        this(context, null);
    }

    public DividerRelativeLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DividerRelativeLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    @TargetApi(value=21)
    public DividerRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DividerRelativeLayout);
        this.mTopDividerEnable = a.getBoolean(R.styleable.DividerRelativeLayout_uxsdk_topDividerEnable, false);
        this.mBottomDividerEnable = a.getBoolean(R.styleable.DividerRelativeLayout_uxsdk_bottomDividerEnable, true);
        int defColor = this.getResources().getColor(R.color.uxsdk_dic_color_c20_divider);
        this.mBottomDividerColor = a.getColor(R.styleable.DividerRelativeLayout_uxsdk_bottomDividerColor, defColor);
        this.mBottomDividerHeight = a.getDimensionPixelSize(R.styleable.DividerRelativeLayout_uxsdk_bottomDividerHeight, AndUtil.dip2px((Context)context, (float)1.0f));
        this.mTopDividerMarginLeft = a.getDimensionPixelSize(R.styleable.DividerRelativeLayout_uxsdk_topDividerMarginLeft, 0);
        this.mBottomDividerMarginLeft = a.getDimensionPixelSize(R.styleable.DividerRelativeLayout_uxsdk_bottomDividerMarginLeft, 0);
        this.sPaint.setColor(this.mBottomDividerColor);
        a.recycle();
        this.setWillNotDraw(false);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBottomDividerEnable) {
            canvas.drawRect((float)this.mBottomDividerMarginLeft, (float)this.getHeight() - (float)this.mBottomDividerHeight, (float)this.getWidth(), (float)this.getHeight(), this.sPaint);
        }
        if (this.mTopDividerEnable) {
            canvas.drawRect((float)this.mTopDividerMarginLeft, 0.0f, (float)this.getWidth(), (float)this.mBottomDividerHeight, this.sPaint);
        }
    }

    @Override
    public void setTopDividerEnable(boolean enabled) {
        this.mTopDividerEnable = enabled;
        this.invalidate();
    }

    @Override
    public void setBottomDividerEnable(boolean enabled) {
        this.mBottomDividerEnable = enabled;
        this.invalidate();
    }

    @Override
    public void setTopDividerColor(int color2) {
    }

    @Override
    public void setBottomDividerColor(int color2) {
        this.mBottomDividerColor = color2;
        this.invalidate();
    }

    @Override
    public void setTopDividerHeight(int height) {
    }

    @Override
    public void setBottomDividerHeight(int height) {
        this.mBottomDividerHeight = height;
        this.invalidate();
    }

    @Override
    public void setTopMarginLeft(int marginLeft) {
        this.mTopDividerMarginLeft = marginLeft;
        this.invalidate();
    }

    @Override
    public void setBottomMarginLeft(int marginLeft) {
        this.mBottomDividerMarginLeft = marginLeft;
        this.invalidate();
    }
}

