/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracapture.shootphoto;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.camera.CameraShootPhotoMode;
import dji.sdk.keyvalue.value.camera.CameraStorageLocation;
import dji.sdk.keyvalue.value.camera.SDCardLoadState;
import dji.sdk.keyvalue.value.camera.SSDOperationState;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.ui.ProgressRingView;
import dji.v5.ux.cameracore.util.CameraActionSound;
import dji.v5.ux.cameracore.util.CameraResource;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraAEBPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraBurstPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraIntervalPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraPanoramaPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraPhotoState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraPhotoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraSDPhotoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.CameraSSDPhotoStorageState;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.ShootPhotoWidgetModel;
import dji.v5.ux.cameracore.widget.cameracontrols.RemoteControllerButtonDownModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.UxErrorHandle;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.HashMap;
import java.util.Map;

public class ShootPhotoWidget
extends ConstraintLayoutWidget<Object>
implements View.OnClickListener,
ICameraIndex {
    private static final String TAG = "ShootPhotoWidget";
    private ShootPhotoWidgetModel widgetModel;
    private RemoteControllerButtonDownModel buttonDownModel;
    private ProgressRingView borderProgressRingView;
    private ImageView centerImageView;
    private ImageView storageStatusOverlayImageView;
    private Drawable startShootPhotoDrawable;
    private Drawable stopShootPhotoDrawable;
    @ColorInt
    private int progressRingColor;
    private Map<StorageIconState, Drawable> storageInternalIconMap;
    private Map<StorageIconState, Drawable> storageSSDIconMap;
    private Map<StorageIconState, Drawable> storageSDCardIconMap;
    private CameraActionSound cameraActionSound;

    public ShootPhotoWidget(Context context) {
        super(context);
    }

    public ShootPhotoWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ShootPhotoWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        ShootPhotoWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_shoot_photo, (ViewGroup)this);
        this.borderProgressRingView = (ProgressRingView)this.findViewById(R.id.progress_ring_view_border);
        this.centerImageView = (ImageView)this.findViewById(R.id.image_view_center);
        this.storageStatusOverlayImageView = (ImageView)this.findViewById(R.id.image_view_storage_status_overlay);
        this.storageInternalIconMap = new HashMap<StorageIconState, Drawable>();
        this.storageSSDIconMap = new HashMap<StorageIconState, Drawable>();
        this.storageSDCardIconMap = new HashMap<StorageIconState, Drawable>();
        this.cameraActionSound = new CameraActionSound(context);
        if (!this.isInEditMode()) {
            this.centerImageView.setOnClickListener((View.OnClickListener)this);
            this.widgetModel = new ShootPhotoWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.buttonDownModel = new RemoteControllerButtonDownModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        this.initDefaults();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
            this.buttonDownModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
            this.buttonDownModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.isShootingPhoto().observeOn(SchedulerProvider.ui()).subscribe(this::onIsShootingPhotoChange, UxErrorHandle.logErrorConsumer(TAG, "isShootingPhoto: ")));
        this.addReaction(this.reactToCanStartOrStopShootingPhoto());
        this.addReaction(this.reactToPhotoStateAndPhotoStorageState());
        this.addReaction(this.buttonDownModel.isShutterButtonDownProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(aBoolean -> {
            if (aBoolean == Boolean.TRUE) {
                this.actionOnShootingPhoto();
            }
        }));
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getContext().getResources().getString(R.string.uxsdk_widget_default_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        if (!this.isInEditMode()) {
            this.widgetModel.updateCameraSource(cameraIndex, lensType);
        }
    }

    public void onClick(View v) {
        if (v.equals(this.centerImageView)) {
            this.actionOnShootingPhoto();
        }
    }

    private void actionOnShootingPhoto() {
        if (!this.widgetModel.isPhotoMode()) {
            return;
        }
        Single stop = this.widgetModel.canStopShootingPhoto().firstOrError();
        Single start = this.widgetModel.canStartShootingPhoto().firstOrError();
        this.addDisposable(Single.zip((SingleSource)stop, (SingleSource)start, Pair::new).flatMapCompletable(pairs -> {
            if (((Boolean)pairs.first).booleanValue()) {
                return this.widgetModel.stopShootPhoto();
            }
            if (((Boolean)pairs.second).booleanValue()) {
                return this.widgetModel.startShootPhoto();
            }
            return Completable.complete();
        }).observeOn(SchedulerProvider.ui()).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(TAG, "Start Stop Shoot Photo")));
    }

    private Drawable getCameraResourceDrawable(int resourceId) {
        return this.getResources().getDrawable(resourceId);
    }

    private void updateCameraForegroundResource(@NonNull CameraPhotoState cameraPhotoState, @NonNull CameraPhotoStorageState cameraPhotoStorageState) {
        Drawable foregroundDrawable = this.updateCameraActionSound(cameraPhotoState);
        if (cameraPhotoStorageState instanceof CameraSDPhotoStorageState) {
            CameraSDPhotoStorageState sdStorageState = (CameraSDPhotoStorageState)cameraPhotoStorageState;
            if (cameraPhotoStorageState.getStorageLocation() == CameraStorageLocation.SDCARD) {
                foregroundDrawable = this.updateResourceWithStorageInSDCard(sdStorageState);
            } else if (cameraPhotoStorageState.getStorageLocation() == CameraStorageLocation.INTERNAL) {
                foregroundDrawable = this.updateResourceWithStorageInternal(sdStorageState);
            }
        } else if (cameraPhotoStorageState instanceof CameraSSDPhotoStorageState) {
            CameraSSDPhotoStorageState ssdStorageState = (CameraSSDPhotoStorageState)cameraPhotoStorageState;
            if (ssdStorageState.getStorageOperationState() == SSDOperationState.NOT_FOUND) {
                foregroundDrawable = this.getSSDStorageIcon(StorageIconState.NOT_INSERTED);
            } else if (ssdStorageState.getStorageOperationState() == SSDOperationState.FULL) {
                foregroundDrawable = this.getSSDStorageIcon(StorageIconState.FULL);
            }
        }
        this.storageStatusOverlayImageView.setImageDrawable(foregroundDrawable);
    }

    private Drawable updateResourceWithStorageInternal(CameraSDPhotoStorageState sdStorageState) {
        Drawable foregroundDrawable = null;
        if (sdStorageState.getStorageOperationState() == SDCardLoadState.NOT_INSERTED) {
            foregroundDrawable = this.getInternalStorageIcon(StorageIconState.NOT_INSERTED);
        }
        return foregroundDrawable;
    }

    private Drawable updateResourceWithStorageInSDCard(CameraSDPhotoStorageState sdStorageState) {
        Drawable foregroundDrawable = null;
        if (sdStorageState.getStorageOperationState() == SDCardLoadState.NOT_INSERTED) {
            foregroundDrawable = this.getSDCardStorageIcon(StorageIconState.NOT_INSERTED);
        }
        return foregroundDrawable;
    }

    private Drawable updateCameraActionSound(CameraPhotoState cameraPhotoState) {
        Drawable foregroundDrawable = null;
        if (cameraPhotoState instanceof CameraPanoramaPhotoState) {
            foregroundDrawable = this.getCameraResourceDrawable(CameraResource.getPhotoModeImgResId(cameraPhotoState.getShootPhotoMode().value(), ((CameraPanoramaPhotoState)cameraPhotoState).getPhotoPanoramaMode().value()));
            this.cameraActionSound.setShutterCount(CameraActionSound.ShutterSoundCount.ONE);
        } else if (cameraPhotoState instanceof CameraAEBPhotoState) {
            int photoCount = ((CameraAEBPhotoState)cameraPhotoState).getPhotoAEBCount().value();
            foregroundDrawable = this.getCameraResourceDrawable(CameraResource.getPhotoModeImgResId(cameraPhotoState.getShootPhotoMode().value(), photoCount));
            this.cameraActionSound.setShutterCount(CameraActionSound.ShutterSoundCount.find(photoCount));
        } else if (cameraPhotoState instanceof CameraBurstPhotoState) {
            int photoCount = ((CameraBurstPhotoState)cameraPhotoState).getPhotoBurstCount().value();
            foregroundDrawable = this.getCameraResourceDrawable(CameraResource.getPhotoModeImgResId(cameraPhotoState.getShootPhotoMode().value(), photoCount));
            this.cameraActionSound.setShutterCount(CameraActionSound.ShutterSoundCount.find(photoCount));
        } else if (cameraPhotoState instanceof CameraIntervalPhotoState) {
            foregroundDrawable = this.getCameraResourceDrawable(CameraResource.getPhotoModeImgResId(cameraPhotoState.getShootPhotoMode().value(), ((CameraIntervalPhotoState)cameraPhotoState).getTimeIntervalInSeconds()));
            this.cameraActionSound.setShutterCount(CameraActionSound.ShutterSoundCount.ONE);
        } else if (cameraPhotoState.getShootPhotoMode() != CameraShootPhotoMode.NORMAL) {
            foregroundDrawable = this.getCameraResourceDrawable(CameraResource.getPhotoModeImgResId(cameraPhotoState.getShootPhotoMode().value(), 0));
            this.cameraActionSound.setShutterCount(CameraActionSound.ShutterSoundCount.ONE);
        }
        return foregroundDrawable;
    }

    private void onIsShootingPhotoChange(boolean isShootingPhoto) {
        this.borderProgressRingView.setIndeterminate(isShootingPhoto);
        if (isShootingPhoto) {
            this.cameraActionSound.playCapturePhoto();
        }
    }

    private Disposable reactToPhotoStateAndPhotoStorageState() {
        return Flowable.combineLatest(this.widgetModel.getCameraPhotoState(), this.widgetModel.getCameraStorageState(), Pair::new).observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateCameraForegroundResource((CameraPhotoState)values.first, (CameraPhotoStorageState)values.second), UxErrorHandle.logErrorConsumer(TAG, "reactToPhotoStateAndPhotoStorageState "));
    }

    private Disposable reactToCanStartOrStopShootingPhoto() {
        return Flowable.combineLatest(this.widgetModel.canStartShootingPhoto(), this.widgetModel.canStopShootingPhoto(), Pair::new).observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateImages((Boolean)values.first, (Boolean)values.second), UxErrorHandle.logErrorConsumer(TAG, "reactToCanStartOrStopShootingPhoto: "));
    }

    private void checkAndUpdatePhotoStateAndPhotoStorageState() {
        if (!this.isInEditMode()) {
            this.addDisposable(Flowable.combineLatest(this.widgetModel.getCameraPhotoState(), this.widgetModel.getCameraStorageState(), Pair::new).firstOrError().observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateCameraForegroundResource((CameraPhotoState)values.first, (CameraPhotoStorageState)values.second), UxErrorHandle.logErrorConsumer(TAG, "checkAndUpdatePhotoStateAndPhotoStorageState ")));
        }
    }

    private void checkAndUpdateCanStartOrStopShootingPhoto() {
        if (!this.isInEditMode()) {
            this.addDisposable(Flowable.combineLatest(this.widgetModel.canStartShootingPhoto(), this.widgetModel.canStopShootingPhoto(), Pair::new).firstOrError().observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateImages((Boolean)values.first, (Boolean)values.second), UxErrorHandle.logErrorConsumer(TAG, "checkAndUpdateCanStartOrStopShootingPhoto: ")));
        }
    }

    private void updateImages(boolean canStartShootingPhoto, boolean canStopShootingPhoto) {
        if (!canStopShootingPhoto) {
            this.enableAction(canStartShootingPhoto);
            this.centerImageView.setImageDrawable(this.startShootPhotoDrawable);
        } else {
            this.enableAction(true);
            this.centerImageView.setImageDrawable(this.stopShootPhotoDrawable);
        }
        this.storageStatusOverlayImageView.setVisibility(canStopShootingPhoto ? 8 : 0);
        this.borderProgressRingView.setRingColor(this.progressRingColor);
    }

    private void enableAction(boolean isEnabled) {
        this.centerImageView.setEnabled(isEnabled);
    }

    private void initDefaults() {
        this.startShootPhotoDrawable = this.getResources().getDrawable(R.drawable.uxsdk_shape_circle);
        this.stopShootPhotoDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_shutter_stop);
        this.setProgressRingColor(-1);
        this.setInternalStorageIcon(StorageIconState.NOT_INSERTED, R.drawable.uxsdk_ic_internal_storage_not_inserted);
        this.setInternalStorageIcon(StorageIconState.SLOW, R.drawable.uxsdk_ic_internal_storage_slow);
        this.setInternalStorageIcon(StorageIconState.FULL, R.drawable.uxsdk_ic_internal_storage_full);
        this.setSDCardStorageIcon(StorageIconState.NOT_INSERTED, R.drawable.uxsdk_ic_sdcard_not_inserted);
        this.setSDCardStorageIcon(StorageIconState.SLOW, R.drawable.uxsdk_ic_sdcard_slow);
        this.setSDCardStorageIcon(StorageIconState.FULL, R.drawable.uxsdk_ic_sdcard_full);
        this.setSSDStorageIcon(StorageIconState.NOT_INSERTED, R.drawable.uxsdk_ic_ssd_not_inserted);
        this.setSSDStorageIcon(StorageIconState.FULL, R.drawable.uxsdk_ic_ssd_full);
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShootPhotoWidget);
        this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.ShootPhotoWidget_uxsdk_cameraIndex, 0)), CameraLensType.UNKNOWN);
        this.setForegroundIconBackground(typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_foregroundIconBackground));
        this.setProgressRingColor(typedArray.getColor(R.styleable.ShootPhotoWidget_uxsdk_progressRingColor, -1));
        this.initShootPhotoDrawable(typedArray);
        this.initInternalStorageIcon(typedArray);
        this.initSSDStorageIcon(typedArray);
        this.initSDCardStorageIcon(typedArray);
        typedArray.recycle();
    }

    private void initSSDStorageIcon(TypedArray typedArray) {
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_ssdNotInsertedIcon) != null) {
            this.setSSDStorageIcon(StorageIconState.NOT_INSERTED, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_ssdNotInsertedIcon));
        }
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_ssdFullIcon) != null) {
            this.setSSDStorageIcon(StorageIconState.FULL, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_ssdFullIcon));
        }
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_ssdSlowIcon) != null) {
            this.setSSDStorageIcon(StorageIconState.SLOW, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_ssdSlowIcon));
        }
    }

    private void initSDCardStorageIcon(TypedArray typedArray) {
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_sdCardNotInsertedIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.NOT_INSERTED, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_sdCardNotInsertedIcon));
        }
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_sdCardFullIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.FULL, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_sdCardFullIcon));
        }
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_sdCardSlowIcon) != null) {
            this.setSDCardStorageIcon(StorageIconState.SLOW, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_sdCardSlowIcon));
        }
    }

    private void initInternalStorageIcon(TypedArray typedArray) {
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_internalStorageNotInsertedIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.NOT_INSERTED, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_internalStorageNotInsertedIcon));
        }
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_internalStorageFullIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.FULL, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_internalStorageFullIcon));
        }
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_internalStorageSlowIcon) != null) {
            this.setInternalStorageIcon(StorageIconState.SLOW, typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_internalStorageSlowIcon));
        }
    }

    private void initShootPhotoDrawable(TypedArray typedArray) {
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_shootPhotoStartIcon) != null) {
            this.startShootPhotoDrawable = typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_shootPhotoStartIcon);
        }
        if (typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_shootPhotoStopIcon) != null) {
            this.stopShootPhotoDrawable = typedArray.getDrawable(R.styleable.ShootPhotoWidget_uxsdk_shootPhotoStopIcon);
        }
    }

    public Drawable getStartShootPhotoDrawable() {
        return this.startShootPhotoDrawable;
    }

    public void setStartShootPhotoDrawable(@DrawableRes int resourceId) {
        this.setStartShootPhotoDrawable(this.getResources().getDrawable(resourceId));
    }

    public void setStartShootPhotoDrawable(@Nullable Drawable drawable2) {
        this.startShootPhotoDrawable = drawable2;
        this.checkAndUpdateCanStartOrStopShootingPhoto();
    }

    @Nullable
    public Drawable getStopShootPhotoDrawable() {
        return this.stopShootPhotoDrawable;
    }

    public void setStopShootPhotoDrawable(@DrawableRes int resourceId) {
        this.setStopShootPhotoDrawable(this.getResources().getDrawable(resourceId));
    }

    public void setStopShootPhotoDrawable(@Nullable Drawable drawable2) {
        this.stopShootPhotoDrawable = drawable2;
        this.checkAndUpdateCanStartOrStopShootingPhoto();
    }

    public void setInternalStorageIcon(@NonNull StorageIconState storageIconState, @DrawableRes int resourceId) {
        this.setInternalStorageIcon(storageIconState, this.getResources().getDrawable(resourceId));
    }

    public void setInternalStorageIcon(@NonNull StorageIconState storageIconState, @Nullable Drawable drawable2) {
        this.storageInternalIconMap.put(storageIconState, drawable2);
        this.checkAndUpdatePhotoStateAndPhotoStorageState();
    }

    @Nullable
    public Drawable getInternalStorageIcon(@NonNull StorageIconState storageIconState) {
        return this.storageInternalIconMap.get((Object)storageIconState);
    }

    public void setSDCardStorageIcon(@NonNull StorageIconState storageIconState, @DrawableRes int resourceId) {
        this.setSDCardStorageIcon(storageIconState, this.getResources().getDrawable(resourceId));
    }

    public void setSDCardStorageIcon(@NonNull StorageIconState storageIconState, @Nullable Drawable drawable2) {
        this.storageSDCardIconMap.put(storageIconState, drawable2);
        this.checkAndUpdatePhotoStateAndPhotoStorageState();
    }

    @Nullable
    public Drawable getSDCardStorageIcon(@NonNull StorageIconState storageIconState) {
        return this.storageSDCardIconMap.get((Object)storageIconState);
    }

    public void setSSDStorageIcon(@NonNull StorageIconState storageIconState, @DrawableRes int resourceId) {
        this.setSSDStorageIcon(storageIconState, this.getResources().getDrawable(resourceId));
    }

    public void setSSDStorageIcon(@NonNull StorageIconState storageIconState, @Nullable Drawable drawable2) {
        this.storageSSDIconMap.put(storageIconState, drawable2);
        this.checkAndUpdatePhotoStateAndPhotoStorageState();
    }

    @Nullable
    public Drawable getSSDStorageIcon(@NonNull StorageIconState storageIconState) {
        return this.storageSSDIconMap.get((Object)storageIconState);
    }

    @Nullable
    public Drawable getForegroundIconBackground() {
        return this.storageStatusOverlayImageView.getBackground();
    }

    public void setForegroundIconBackground(@DrawableRes int resourceId) {
        this.storageStatusOverlayImageView.setBackgroundResource(resourceId);
    }

    public void setForegroundIconBackground(@Nullable Drawable drawable2) {
        this.storageStatusOverlayImageView.setBackground(drawable2);
    }

    @ColorInt
    public int getProgressRingColor() {
        return this.progressRingColor;
    }

    public void setProgressRingColor(@ColorInt int color2) {
        this.progressRingColor = color2;
        this.checkAndUpdateCanStartOrStopShootingPhoto();
    }

    public static enum StorageIconState {
        SLOW,
        FULL,
        NOT_INSERTED;

    }
}

