/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.autoexposurelock;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class AutoExposureLockWidgetModel
extends WidgetModel
implements ICameraIndex {
    private final DataProcessor<Boolean> autoExposureLockBooleanProcessor;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public AutoExposureLockWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
        this.autoExposureLockBooleanProcessor = DataProcessor.create(false);
    }

    public Flowable<Boolean> isAutoExposureLockOn() {
        return this.autoExposureLockBooleanProcessor.toFlowable();
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Completable toggleAutoExposureLock() {
        return this.djiSdkModel.setValue(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyAELockEnabled, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.autoExposureLockBooleanProcessor.getValue() == false);
    }

    @Override
    protected void inSetup() {
        KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyAELockEnabled, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyAELockEnabled, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.autoExposureLockBooleanProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
    }
}

