/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.accessory;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import dji.rtk.CoordinateSystem;
import dji.sdk.keyvalue.value.rtkbasestation.RTKCustomNetworkSetting;
import dji.sdk.keyvalue.value.rtkbasestation.RTKReferenceStationSource;
import dji.sdk.keyvalue.value.rtkmobilestation.RTKPositioningSolution;
import dji.v5.manager.aircraft.rtk.RTKCenter;
import dji.v5.utils.common.ContextUtil;
import dji.v5.utils.common.DjiSharedPreferencesManager;
import dji.v5.utils.common.JsonUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.extension.ViewExtensions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldji/v5/ux/accessory/RTKUtil;", "", "<init>", "()V", "TAG", "", "USER_RTK_NETWORK_SERVICE_SETTINGS", "USER_RTK_REFERENCE_SOURCE", "USER_RTK_NETWORK_COORDINATE_SYSTEM_CMCC", "USER_RTK_NETWORK_COORDINATE_SYSTEM_QX", "getRTKTypeName", "view", "Landroid/view/View;", "rtkReferenceStationSource", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;", "getRTKStatusName", "positioningSolution", "Ldji/sdk/keyvalue/value/rtkmobilestation/RTKPositioningSolution;", "getNetRTKCoordinateSystem", "Ldji/rtk/CoordinateSystem;", "saveRTKCoordinateSystem", "", "coordinateSystem", "saveRtkCustomNetworkSetting", "settings", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKCustomNetworkSetting;", "getRtkCustomNetworkSetting", "getCoordinateName", "value", "android-sdk-v5-uxsdk_release"})
public final class RTKUtil {
    @NotNull
    public static final RTKUtil INSTANCE = new RTKUtil();
    @NotNull
    private static final String TAG = "RTKUtil";
    @NotNull
    private static final String USER_RTK_NETWORK_SERVICE_SETTINGS = "user_rtk_network_service_settings";
    @NotNull
    private static final String USER_RTK_REFERENCE_SOURCE = "user_rtk_reference_source";
    @NotNull
    private static final String USER_RTK_NETWORK_COORDINATE_SYSTEM_CMCC = "user_rtk_network_coordinate_system_cmcc";
    @NotNull
    private static final String USER_RTK_NETWORK_COORDINATE_SYSTEM_QX = "user_rtk_network_coordinate_system_qx";

    private RTKUtil() {
    }

    @NotNull
    public final String getRTKTypeName(@NotNull View view, @Nullable RTKReferenceStationSource rtkReferenceStationSource) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        View $this$getRTKTypeName_u24lambda_u240 = view;
        boolean bl = false;
        if (rtkReferenceStationSource == null) {
            return ViewExtensions.getString($this$getRTKTypeName_u24lambda_u240, R.string.uxsdk_rtk_type_unknown_rtk, new Object[0]);
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[rtkReferenceStationSource.ordinal()]) {
            case 1 -> ViewExtensions.getString($this$getRTKTypeName_u24lambda_u240, R.string.uxsdk_rtk_type_nrtk, new Object[0]);
            case 2 -> ViewExtensions.getString($this$getRTKTypeName_u24lambda_u240, R.string.uxsdk_rtk_type_rtk_mobile_station, new Object[0]);
            case 3 -> ViewExtensions.getString($this$getRTKTypeName_u24lambda_u240, R.string.uxsdk_rtk_type_custom_rtk, new Object[0]);
            case 4 -> ViewExtensions.getString($this$getRTKTypeName_u24lambda_u240, R.string.uxsdk_rtk_type_cmcc_rtk, new Object[0]);
            default -> ViewExtensions.getString($this$getRTKTypeName_u24lambda_u240, R.string.uxsdk_rtk_type_unknown_rtk, new Object[0]);
        };
    }

    @NotNull
    public final String getRTKStatusName(@NotNull View view, @Nullable RTKPositioningSolution positioningSolution) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        View $this$getRTKStatusName_u24lambda_u241 = view;
        boolean bl = false;
        if (positioningSolution == null) {
            return ViewExtensions.getString($this$getRTKStatusName_u24lambda_u241, R.string.uxsdk_rtk_solution_unknown, new Object[0]);
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[positioningSolution.ordinal()]) {
            case 1 -> ViewExtensions.getString($this$getRTKStatusName_u24lambda_u241, R.string.uxsdk_rtk_solution_none, new Object[0]);
            case 2 -> ViewExtensions.getString($this$getRTKStatusName_u24lambda_u241, R.string.uxsdk_rtk_solution_single, new Object[0]);
            case 3 -> ViewExtensions.getString($this$getRTKStatusName_u24lambda_u241, R.string.uxsdk_rtk_solution_float, new Object[0]);
            case 4 -> ViewExtensions.getString($this$getRTKStatusName_u24lambda_u241, R.string.uxsdk_rtk_solution_fixed, new Object[0]);
            case 5 -> ViewExtensions.getString($this$getRTKStatusName_u24lambda_u241, R.string.uxsdk_rtk_solution_unknown, new Object[0]);
            default -> ViewExtensions.getString($this$getRTKStatusName_u24lambda_u241, R.string.uxsdk_rtk_solution_unknown, new Object[0]);
        };
    }

    @Nullable
    public final CoordinateSystem getNetRTKCoordinateSystem(@NotNull RTKReferenceStationSource rtkReferenceStationSource) {
        Intrinsics.checkNotNullParameter((Object)rtkReferenceStationSource, (String)"rtkReferenceStationSource");
        String coordinateSystem = "";
        switch (WhenMappings.$EnumSwitchMapping$0[rtkReferenceStationSource.ordinal()]) {
            case 4: {
                coordinateSystem = DjiSharedPreferencesManager.getString((Context)ContextUtil.getContext(), (String)USER_RTK_NETWORK_COORDINATE_SYSTEM_CMCC, (String)"");
                break;
            }
            case 1: {
                coordinateSystem = DjiSharedPreferencesManager.getString((Context)ContextUtil.getContext(), (String)USER_RTK_NETWORK_COORDINATE_SYSTEM_QX, (String)"");
                break;
            }
            default: {
                Object[] objectArray = new Object[]{"getNetRTKCoordinateSystem error,unSupport rtkReferenceStationSource:" + rtkReferenceStationSource};
                LogUtils.e((String)TAG, (Object[])objectArray);
            }
        }
        return TextUtils.isEmpty((CharSequence)coordinateSystem) ? null : this.getCoordinateName(coordinateSystem);
    }

    public final void saveRTKCoordinateSystem(@NotNull RTKReferenceStationSource rtkReferenceStationSource, @NotNull CoordinateSystem coordinateSystem) {
        Intrinsics.checkNotNullParameter((Object)rtkReferenceStationSource, (String)"rtkReferenceStationSource");
        Intrinsics.checkNotNullParameter((Object)coordinateSystem, (String)"coordinateSystem");
        switch (WhenMappings.$EnumSwitchMapping$0[rtkReferenceStationSource.ordinal()]) {
            case 1: {
                DjiSharedPreferencesManager.putString((Context)ContextUtil.getContext(), (String)USER_RTK_NETWORK_COORDINATE_SYSTEM_QX, (String)coordinateSystem.name());
                break;
            }
            case 4: {
                DjiSharedPreferencesManager.putString((Context)ContextUtil.getContext(), (String)USER_RTK_NETWORK_COORDINATE_SYSTEM_CMCC, (String)coordinateSystem.name());
                break;
            }
            default: {
                Object[] objectArray = new Object[]{"saveRTKCoordinateSystem error,unSupport rtkReferenceStationSource:" + rtkReferenceStationSource};
                LogUtils.e((String)TAG, (Object[])objectArray);
            }
        }
    }

    public final void saveRtkCustomNetworkSetting(@NotNull RTKCustomNetworkSetting settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        DjiSharedPreferencesManager.putString((Context)ContextUtil.getContext(), (String)USER_RTK_NETWORK_SERVICE_SETTINGS, (String)settings.toString());
    }

    @Nullable
    public final RTKCustomNetworkSetting getRtkCustomNetworkSetting() {
        RTKCustomNetworkSetting rTKCustomNetworkSetting;
        String localSetting = DjiSharedPreferencesManager.getString((Context)ContextUtil.getContext(), (String)USER_RTK_NETWORK_SERVICE_SETTINGS, (String)"");
        if (!TextUtils.isEmpty((CharSequence)localSetting)) {
            rTKCustomNetworkSetting = (RTKCustomNetworkSetting)JsonUtil.toBean((String)localSetting, RTKCustomNetworkSetting.class);
        } else {
            rTKCustomNetworkSetting = RTKCenter.getInstance().getCustomRTKManager().getCustomNetworkRTKSettings();
            if (rTKCustomNetworkSetting == null) {
                rTKCustomNetworkSetting = new RTKCustomNetworkSetting("", Integer.valueOf(0), "", "", "");
            }
        }
        return rTKCustomNetworkSetting;
    }

    private final CoordinateSystem getCoordinateName(String value) {
        String string2 = value;
        return Intrinsics.areEqual((Object)string2, (Object)"CGCS2000") ? CoordinateSystem.CGCS2000 : (Intrinsics.areEqual((Object)string2, (Object)"WGS84") ? CoordinateSystem.WGS84 : CoordinateSystem.CGCS2000);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RTKReferenceStationSource.values().length];
            try {
                nArray[RTKReferenceStationSource.QX_NETWORK_SERVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.BASE_STATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.NTRIP_NETWORK_SERVICE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RTKPositioningSolution.values().length];
            try {
                nArray[RTKPositioningSolution.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKPositioningSolution.SINGLE_POINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKPositioningSolution.FLOAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKPositioningSolution.FIXED_POINT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKPositioningSolution.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

