/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.maps;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import dji.v5.ux.mapkit.core.MapkitOptions;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.maps.DJIMapView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DJIMapFragment
extends Fragment
implements DJIMapView.OnDJIMapReadyCallback {
    private DJIMapView mapView;
    private DJIMap djiMap;
    private List<DJIMapView.OnDJIMapReadyCallback> mapReadyCallbackList = new ArrayList<DJIMapView.OnDJIMapReadyCallback>();

    public static DJIMapFragment newInstance(MapkitOptions mapkitOptions) {
        DJIMapFragment fragment = new DJIMapFragment();
        Bundle bundle = new Bundle();
        bundle.putIntegerArrayList("support_provider_list", (ArrayList)mapkitOptions.getProviderList());
        bundle.putInt("map_type", mapkitOptions.getMapType());
        fragment.setArguments(bundle);
        return fragment;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        Context context = inflater.getContext();
        this.mapView = new DJIMapView((Activity)context, this.parseBundle(this.getArguments()));
        return this.mapView;
    }

    private MapkitOptions parseBundle(Bundle arguments) {
        int mapType = arguments.getInt("map_type");
        ArrayList supportList = arguments.getIntegerArrayList("support_provider_list");
        MapkitOptions.Builder builder = new MapkitOptions.Builder();
        builder.mapType(mapType);
        if (supportList != null && !supportList.isEmpty()) {
            Iterator iterator = supportList.iterator();
            while (iterator.hasNext()) {
                int provider = (Integer)iterator.next();
                builder.addMapProvider(provider);
            }
        }
        return builder.build();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mapView.onCreate(savedInstanceState);
        this.mapView.getDJIMapAsync(this);
    }

    @Override
    public void onDJIMapReady(DJIMap map) {
        this.djiMap = map;
        for (DJIMapView.OnDJIMapReadyCallback onMapReadyCallback : this.mapReadyCallbackList) {
            onMapReadyCallback.onDJIMapReady(this.djiMap);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mapView.onSaveInstanceState(outState);
    }

    public void onStart() {
        super.onStart();
        this.mapView.onStart();
    }

    public void onResume() {
        super.onResume();
        this.mapView.onResume();
    }

    public void onPause() {
        super.onPause();
        this.mapView.onPause();
    }

    public void onStop() {
        super.onStop();
        this.mapView.onStop();
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.mapView.onLowMemory();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mapView.onDestroy();
        this.mapReadyCallbackList.clear();
    }

    public void getDJIMapAsync(DJIMapView.OnDJIMapReadyCallback onDJIMapReadyCallback) {
        if (this.djiMap == null) {
            this.mapReadyCallbackList.add(onDJIMapReadyCallback);
        } else {
            onDJIMapReadyCallback.onDJIMapReady(this.djiMap);
        }
    }
}

