/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.airsense;

import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.flightcontroller.AirSenseSystemInformation;
import dji.sdk.keyvalue.value.flightcontroller.AirSenseWarningLevel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.model.WarningMessage;
import dji.v5.ux.core.model.WarningMessageError;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001*B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020\u000eJ0\u0010 \u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u001c2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020'H\u0014J\b\u0010)\u001a\u00020'H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006+"}, d2={"Ldji/v5/ux/core/widget/airsense/AirSenseWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;)V", "airSenseConnectedProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "airSenseSystemInformationProcessor", "Ldji/sdk/keyvalue/value/flightcontroller/AirSenseSystemInformation;", "airSenseWarningLevelProcessor", "Ldji/sdk/keyvalue/value/flightcontroller/AirSenseWarningLevel;", "sendWarningMessageKey", "Ldji/v5/ux/core/communication/UXKey;", "airSenseStateProcessor", "Ldji/v5/ux/core/widget/airsense/AirSenseWidgetModel$AirSenseState;", "airSenseWarningLevel", "Lio/reactivex/rxjava3/core/Flowable;", "getAirSenseWarningLevel", "()Lio/reactivex/rxjava3/core/Flowable;", "airSenseState", "getAirSenseState", "sendWarningMessages", "Lio/reactivex/rxjava3/core/Completable;", "reason", "", "warningSolution", "dangerousSolution", "warningLevel", "sendWarningMessage", "solution", "level", "Ldji/v5/ux/core/model/WarningMessage$Level;", "action", "Ldji/v5/ux/core/model/WarningMessage$Action;", "inSetup", "", "inCleanup", "updateStates", "AirSenseState", "android-sdk-v5-uxsdk_debug"})
public final class AirSenseWidgetModel
extends WidgetModel {
    @NotNull
    private final ObservableInMemoryKeyedStore keyedStore;
    @NotNull
    private final DataProcessor<Boolean> airSenseConnectedProcessor;
    @NotNull
    private final DataProcessor<AirSenseSystemInformation> airSenseSystemInformationProcessor;
    @NotNull
    private final DataProcessor<AirSenseWarningLevel> airSenseWarningLevelProcessor;
    @NotNull
    private final UXKey sendWarningMessageKey;
    @NotNull
    private final DataProcessor<AirSenseState> airSenseStateProcessor;

    @JvmOverloads
    public AirSenseWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        super(djiSdkModel, keyedStore);
        this.keyedStore = keyedStore;
        DataProcessor<Boolean> dataProcessor = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.airSenseConnectedProcessor = dataProcessor;
        DataProcessor<AirSenseSystemInformation> dataProcessor2 = DataProcessor.create(new AirSenseSystemInformation());
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.airSenseSystemInformationProcessor = dataProcessor2;
        DataProcessor<AirSenseWarningLevel> dataProcessor3 = DataProcessor.create(AirSenseWarningLevel.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.airSenseWarningLevelProcessor = dataProcessor3;
        UXKey uXKey = UXKeys.create("SendWarningMessage");
        Intrinsics.checkNotNullExpressionValue((Object)uXKey, (String)"create(...)");
        this.sendWarningMessageKey = uXKey;
        DataProcessor<AirSenseState> dataProcessor4 = DataProcessor.create(AirSenseState.DISCONNECTED);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.airSenseStateProcessor = dataProcessor4;
    }

    @NotNull
    public final Flowable<AirSenseWarningLevel> getAirSenseWarningLevel() {
        Flowable flowable = this.airSenseWarningLevelProcessor.toFlowable().distinctUntilChanged();
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"distinctUntilChanged(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<AirSenseState> getAirSenseState() {
        Flowable<AirSenseState> flowable = this.airSenseStateProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Completable sendWarningMessages(@Nullable String reason, @Nullable String warningSolution, @Nullable String dangerousSolution, @NotNull AirSenseWarningLevel warningLevel) {
        Completable completable;
        Intrinsics.checkNotNullParameter((Object)warningLevel, (String)"warningLevel");
        switch (WhenMappings.$EnumSwitchMapping$0[warningLevel.ordinal()]) {
            case 1: {
                Completable completable2 = this.sendWarningMessage(reason, warningSolution, WarningMessage.Level.WARNING, WarningMessage.Action.INSERT).andThen((CompletableSource)this.sendWarningMessage(reason, dangerousSolution, WarningMessage.Level.DANGEROUS, WarningMessage.Action.REMOVE));
                completable = completable2;
                Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"andThen(...)");
                break;
            }
            case 2: 
            case 3: {
                Completable completable3 = this.sendWarningMessage(reason, warningSolution, WarningMessage.Level.WARNING, WarningMessage.Action.REMOVE).andThen((CompletableSource)this.sendWarningMessage(reason, dangerousSolution, WarningMessage.Level.DANGEROUS, WarningMessage.Action.INSERT));
                completable = completable3;
                Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"andThen(...)");
                break;
            }
            default: {
                Completable completable4 = this.sendWarningMessage(reason, warningSolution, WarningMessage.Level.WARNING, WarningMessage.Action.REMOVE).andThen((CompletableSource)this.sendWarningMessage(reason, dangerousSolution, WarningMessage.Level.DANGEROUS, WarningMessage.Action.REMOVE));
                completable = completable4;
                Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"andThen(...)");
            }
        }
        return completable;
    }

    private final Completable sendWarningMessage(String reason, String solution, WarningMessage.Level level, WarningMessage.Action action) {
        WarningMessage.Builder builder = new WarningMessage.Builder(WarningMessage.WarningType.FLY_SAFE).code(-1).subCode(WarningMessageError.OTHER_AIRCRAFT_NEARBY.value()).reason(reason).solution(solution).level(level).type(WarningMessage.Type.PINNED).action(action);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"action(...)");
        WarningMessage.Builder builder2 = builder;
        WarningMessage warningMessage = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)warningMessage, (String)"build(...)");
        WarningMessage warningMessage2 = warningMessage;
        Completable completable = this.keyedStore.setValue(this.sendWarningMessageKey, warningMessage2);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"setValue(...)");
        return completable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAirSenseSystemConnected), this.airSenseConnectedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAirSenseSystemInformation), this.airSenseSystemInformationProcessor, arg_0 -> AirSenseWidgetModel.inSetup$lambda$0(this, arg_0));
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
        AirSenseState airSenseState;
        if (!((Boolean)this.productConnectionProcessor.getValue()).booleanValue()) {
            airSenseState = AirSenseState.DISCONNECTED;
        } else if (!this.airSenseConnectedProcessor.getValue().booleanValue()) {
            airSenseState = AirSenseState.NO_AIR_SENSE_CONNECTED;
        } else if (this.airSenseSystemInformationProcessor.getValue().getAirplaneStates().isEmpty()) {
            airSenseState = AirSenseState.NO_AIRPLANES_NEARBY;
        } else {
            AirSenseWarningLevel airSenseWarningLevel = this.airSenseSystemInformationProcessor.getValue().getWarningLevel();
            switch (airSenseWarningLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[airSenseWarningLevel.ordinal()]) {
                case 4: {
                    airSenseState = AirSenseState.WARNING_LEVEL_0;
                    break;
                }
                case 5: {
                    airSenseState = AirSenseState.WARNING_LEVEL_1;
                    break;
                }
                case 1: {
                    airSenseState = AirSenseState.WARNING_LEVEL_2;
                    break;
                }
                case 2: {
                    airSenseState = AirSenseState.WARNING_LEVEL_3;
                    break;
                }
                case 3: {
                    airSenseState = AirSenseState.WARNING_LEVEL_4;
                    break;
                }
                default: {
                    airSenseState = AirSenseState.UNKNOWN;
                }
            }
        }
        this.airSenseStateProcessor.onNext(airSenseState);
    }

    private static final void inSetup$lambda$0(AirSenseWidgetModel this$0, AirSenseSystemInformation it) {
        this$0.airSenseWarningLevelProcessor.onNext(it.getWarningLevel());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Ldji/v5/ux/core/widget/airsense/AirSenseWidgetModel$AirSenseState;", "", "<init>", "(Ljava/lang/String;I)V", "DISCONNECTED", "NO_AIR_SENSE_CONNECTED", "NO_AIRPLANES_NEARBY", "WARNING_LEVEL_0", "WARNING_LEVEL_1", "WARNING_LEVEL_2", "WARNING_LEVEL_3", "WARNING_LEVEL_4", "UNKNOWN", "android-sdk-v5-uxsdk_debug"})
    public static final class AirSenseState
    extends Enum<AirSenseState> {
        public static final /* enum */ AirSenseState DISCONNECTED = new AirSenseState();
        public static final /* enum */ AirSenseState NO_AIR_SENSE_CONNECTED = new AirSenseState();
        public static final /* enum */ AirSenseState NO_AIRPLANES_NEARBY = new AirSenseState();
        public static final /* enum */ AirSenseState WARNING_LEVEL_0 = new AirSenseState();
        public static final /* enum */ AirSenseState WARNING_LEVEL_1 = new AirSenseState();
        public static final /* enum */ AirSenseState WARNING_LEVEL_2 = new AirSenseState();
        public static final /* enum */ AirSenseState WARNING_LEVEL_3 = new AirSenseState();
        public static final /* enum */ AirSenseState WARNING_LEVEL_4 = new AirSenseState();
        public static final /* enum */ AirSenseState UNKNOWN = new AirSenseState();
        private static final /* synthetic */ AirSenseState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AirSenseState[] values() {
            return (AirSenseState[])$VALUES.clone();
        }

        public static AirSenseState valueOf(String value) {
            return Enum.valueOf(AirSenseState.class, value);
        }

        @NotNull
        public static EnumEntries<AirSenseState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = airSenseStateArray = new AirSenseState[]{AirSenseState.DISCONNECTED, AirSenseState.NO_AIR_SENSE_CONNECTED, AirSenseState.NO_AIRPLANES_NEARBY, AirSenseState.WARNING_LEVEL_0, AirSenseState.WARNING_LEVEL_1, AirSenseState.WARNING_LEVEL_2, AirSenseState.WARNING_LEVEL_3, AirSenseState.WARNING_LEVEL_4, AirSenseState.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AirSenseWarningLevel.values().length];
            try {
                nArray[AirSenseWarningLevel.LEVEL_2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AirSenseWarningLevel.LEVEL_3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AirSenseWarningLevel.LEVEL_4.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AirSenseWarningLevel.LEVEL_0.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AirSenseWarningLevel.LEVEL_1.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

