/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.view.IconicsImageView;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DividerConstraintLayout;

public class TextCell
extends DividerConstraintLayout {
    protected TextView mTitle;
    protected ImageView mInfoIV;
    protected TextView mContent;
    protected TextView mSubhead;
    protected IconicsImageView mArrow;
    protected ImageView mIcon;
    protected TextView mSummary;

    public TextCell(Context context) {
        this(context, null, 0);
    }

    public TextCell(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextCell(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        String drawableStr;
        TextCell.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TextCell, defStyleAttr, 0);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mInfoIV = (ImageView)this.findViewById(R.id.info_iv);
        this.mContent = (TextView)this.findViewById(R.id.content);
        this.mSubhead = (TextView)this.findViewById(R.id.subhead);
        this.mArrow = (IconicsImageView)this.findViewById(R.id.arrow);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mSummary = (TextView)this.findViewById(R.id.summary);
        this.initTitleAndContent(ta);
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_infoImageView)) {
            this.mInfoIV.setBackground(ta.getDrawable(R.styleable.TextCell_uxsdk_text_cell_infoImageView));
            this.mInfoIV.setVisibility(0);
        } else {
            this.mInfoIV.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_contentColor)) {
            this.mContent.setTextColor(ta.getColor(R.styleable.TextCell_uxsdk_text_cell_contentColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_dic_color_c24_white_Transparent6)));
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_contentTextSize)) {
            this.mContent.setTextSize(0, ta.getDimension(R.styleable.TextCell_uxsdk_text_cell_contentTextSize, 14.0f));
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_arrow)) {
            int direction = ta.getInt(R.styleable.TextCell_uxsdk_text_cell_arrow, 0);
            this.setRightImageDirection(ArrowDirection.find(direction));
        }
        this.initSummary(ta);
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_subhead)) {
            String str = ta.getString(R.styleable.TextCell_uxsdk_text_cell_subhead);
            this.mSubhead.setVisibility(0);
            this.mSubhead.setText((CharSequence)str);
        } else {
            this.mSubhead.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_drawable) && !TextUtils.isEmpty((CharSequence)(drawableStr = ta.getString(R.styleable.TextCell_uxsdk_text_cell_drawable)))) {
            IconicsDrawable drawable2 = new IconicsDrawable(this.getContext(), drawableStr);
            this.setRightImage(drawable2);
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_arrowRes)) {
            this.mArrow.setVisibility(0);
            this.mArrow.setImageDrawable(ta.getDrawable(R.styleable.TextCell_uxsdk_text_cell_arrowRes));
        }
        ta.recycle();
        this.setMinHeight((int)AndUtil.getItemHeight((Context)this.getContext()));
    }

    void initTitleAndContent(TypedArray ta) {
        this.mTitle.setText((CharSequence)ta.getString(R.styleable.TextCell_uxsdk_text_cell_title));
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_content)) {
            this.mContent.setText((CharSequence)ta.getString(R.styleable.TextCell_uxsdk_text_cell_content));
        } else {
            this.mContent.setVisibility(4);
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_titleColor)) {
            this.mTitle.setTextColor(ta.getColor(R.styleable.TextCell_uxsdk_text_cell_titleColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_dic_color_c8_white)));
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_titleTextSize)) {
            Log.w((String)"test", (String)("" + ta.getDimension(R.styleable.TextCell_uxsdk_text_cell_titleTextSize, 16.0f)));
            this.mTitle.setTextSize(0, ta.getDimension(R.styleable.TextCell_uxsdk_text_cell_titleTextSize, 16.0f));
        }
    }

    void initSummary(TypedArray ta) {
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_summary)) {
            this.mSummary.setVisibility(0);
            this.mSummary.setText((CharSequence)ta.getString(R.styleable.TextCell_uxsdk_text_cell_summary));
        } else {
            this.mSummary.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_summaryColor)) {
            this.mSummary.setTextColor(ta.getColor(R.styleable.TextCell_uxsdk_text_cell_summaryColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.uxsdk_dic_color_c24_white_Transparent6)));
        }
        if (ta.hasValue(R.styleable.TextCell_uxsdk_text_cell_summaryTextSize)) {
            this.mSummary.setTextSize(0, ta.getDimension(R.styleable.TextCell_uxsdk_text_cell_summaryTextSize, 12.0f));
        }
    }

    protected int getLayoutId() {
        return R.layout.uxsdk_cell_text_layout;
    }

    public void setArrowResVisible(boolean visibility) {
        this.mArrow.setVisibility(visibility ? 0 : 8);
    }

    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
    }

    public void setTitleColor(@ColorInt int titleColor) {
        this.mTitle.setTextColor(titleColor);
    }

    public void setInfoImageVisibility(int visibility) {
        this.mInfoIV.setVisibility(visibility);
    }

    public void setContent(String content) {
        if (!TextUtils.isEmpty((CharSequence)content)) {
            this.mContent.setText((CharSequence)content);
            this.mContent.setVisibility(0);
        } else {
            this.mContent.setVisibility(4);
        }
    }

    public void setContentColor(@ColorInt int contentColor) {
        this.mContent.setTextColor(contentColor);
    }

    public void setRightImage(IconicsDrawable icon) {
        if (icon != null) {
            this.mArrow.setIcon(icon);
            this.mArrow.setVisibility(0);
        } else {
            this.mArrow.setVisibility(8);
        }
    }

    public void setRightImageVisibility(int visibility) {
        this.mArrow.setVisibility(visibility);
    }

    public void setRightImageDirection(ArrowDirection direction) {
        if (direction == null) {
            this.mArrow.setVisibility(8);
            return;
        }
        int imgRes = -1;
        switch (direction.ordinal()) {
            case 3: {
                imgRes = R.drawable.uxsdk_arrow_down;
                break;
            }
            case 1: {
                imgRes = R.drawable.uxsdk_arrow_up;
                break;
            }
            case 0: {
                imgRes = R.drawable.uxsdk_arrow_left;
                break;
            }
            case 2: {
                imgRes = R.drawable.uxsdk_arrow_right;
                break;
            }
        }
        if (imgRes != -1) {
            this.mArrow.setVisibility(0);
            this.mArrow.setImageResource(imgRes);
        } else {
            this.mArrow.setVisibility(8);
        }
    }

    public void setIcon(@DrawableRes int resId) {
        if (resId == 0) {
            this.mIcon.setVisibility(8);
        } else {
            this.mIcon.setVisibility(0);
            this.mIcon.setImageResource(resId);
        }
    }

    public void setIconBackground(Drawable background) {
        this.mIcon.setBackground(background);
    }

    public void setSummary(String summary) {
        if (TextUtils.isEmpty((CharSequence)summary)) {
            this.mSummary.setVisibility(8);
        } else {
            this.mSummary.setVisibility(0);
            this.mSummary.setText((CharSequence)summary);
        }
    }

    public void setSummaryColor(@ColorInt int summaryColor) {
        if (summaryColor != 0) {
            this.mSummary.setTextColor(summaryColor);
        }
    }

    public void setInfoOnClickListener(View.OnClickListener listener2) {
        if (this.mInfoIV != null) {
            this.mInfoIV.setOnClickListener(listener2);
        }
    }

    public void setRightImageBackground(Drawable drawable2) {
        this.mArrow.setBackground(drawable2);
    }

    public static enum ArrowDirection {
        LEFT(1),
        TOP(2),
        RIGHT(3),
        BOTTOM(4),
        UNKNOWN(0);

        private int value;

        private ArrowDirection(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ArrowDirection find(int index) {
            ArrowDirection[] values = ArrowDirection.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].getValue() != index) continue;
                return values[i];
            }
            return UNKNOWN;
        }
    }
}

