/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.util;

import android.content.Context;
import androidx.annotation.NonNull;
import dji.v5.ux.R;
import dji.v5.ux.core.util.AudioUtil;
import io.reactivex.rxjava3.disposables.Disposable;

public class CameraActionSound {
    private final Context context;
    private ShutterSoundCount shutterCount;

    public CameraActionSound(Context con) {
        this.context = con;
    }

    private int shutterCountSound(ShutterSoundCount value) {
        return switch (value.ordinal()) {
            case 0 -> R.raw.uxsdk_shutter_1;
            case 1 -> R.raw.uxsdk_shutter_3;
            case 2 -> R.raw.uxsdk_shutter_5;
            case 3 -> R.raw.uxsdk_shutter_7;
            case 4 -> R.raw.uxsdk_shutter_10;
            case 5 -> R.raw.uxsdk_shutter_14;
            default -> R.raw.uxsdk_shutter_3;
        };
    }

    public void setShutterCount(@NonNull ShutterSoundCount count) {
        this.shutterCount = count;
    }

    @NonNull
    public Disposable playCapturePhoto() {
        return AudioUtil.playSoundInBackground(this.context, this.shutterCountSound(this.shutterCount));
    }

    @NonNull
    public Disposable playStartRecordVideo() {
        return AudioUtil.playSoundInBackground(this.context, R.raw.uxsdk_video_voice);
    }

    @NonNull
    public Disposable playStopRecordVideo() {
        return AudioUtil.playSoundInBackground(this.context, R.raw.uxsdk_end_video_record);
    }

    public static enum ShutterSoundCount {
        ONE(1),
        THREE(3),
        FIVE(5),
        SEVEN(7),
        TEN(10),
        FOURTEEN(14),
        UNKNOWN(1);

        private int value;
        private static ShutterSoundCount[] values;

        private ShutterSoundCount(int value) {
            this.value = value;
        }

        public static ShutterSoundCount find(int value) {
            ShutterSoundCount result = UNKNOWN;
            for (int i = 0; i < ShutterSoundCount.getValues().length; ++i) {
                if (!ShutterSoundCount.getValues()[i]._equals(value)) continue;
                result = ShutterSoundCount.getValues()[i];
                break;
            }
            return result;
        }

        public int value() {
            return this.value;
        }

        private boolean _equals(int b) {
            return this.value == b;
        }

        public static ShutterSoundCount[] getValues() {
            if (values == null) {
                values = ShutterSoundCount.values();
            }
            return values;
        }
    }
}

