/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.airlink.Bandwidth;
import dji.sdk.keyvalue.value.airlink.FrequencyInterferenceInfo;
import dji.sdk.keyvalue.value.airlink.SDRHdOffsetParams;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.TextCell;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.hd.InfoWidgetModel;
import dji.v5.ux.core.widget.hd.SignalInfo;
import java.util.ArrayList;
import java.util.List;

public class InfoWidget
extends ConstraintLayoutWidget<Object> {
    private SignalInfo mSdrSignal = new SignalInfo();
    private List<FrequencyInterferenceInfo> mRssis = new ArrayList<FrequencyInterferenceInfo>();
    private Integer mCurNfIndex = Integer.MAX_VALUE;
    private int mRangeSize = 5;
    private Integer[] mValidRanges;
    private SDRHdOffsetParams mOffsetParams;
    private float mNfStartIndex = 2400.5f;
    private float mLeftNfIndex = Float.MAX_VALUE;
    private int sdrDownQuality = -1;
    private int sdrUpQuality = -1;
    private int linkSignalQuality = -1;
    private boolean fcConnected = false;
    private SignalLevel mSignalLevel = SignalLevel.LEVEL_0;
    private TextCell sdrInfoTextCell;
    private TextView summaryText;
    private InfoWidgetModel widgetModel = new InfoWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());

    public InfoWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public InfoWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public InfoWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        InfoWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_sdr_info_text_layout, (ViewGroup)this);
        this.sdrInfoTextCell = (TextCell)this.findViewById(R.id.tc_setting_menu_sdr_info_text);
        this.summaryText = (TextView)this.findViewById(R.id.summaryText);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getBandwidth().subscribe(value -> {
            this.mSdrSignal.bandwidth = value;
            this.summaryText.setText((CharSequence)this.mSdrSignal.toString());
        }));
        this.addReaction(this.widgetModel.getFrequencyInterfaceInfoList().subscribe(value -> {
            this.mRssis = value;
            this.updateAverageValue();
            this.summaryText.setText((CharSequence)this.mSdrSignal.toString());
        }));
        this.addReaction(this.widgetModel.getFrequencyPointIndexRange().subscribe(value -> {
            this.mValidRanges = new Integer[2];
            this.mValidRanges[0] = value.getMin();
            this.mValidRanges[1] = value.getMax();
            this.onValidRangeChanged();
            this.summaryText.setText((CharSequence)this.mSdrSignal.toString());
        }));
        this.addReaction(this.widgetModel.getSdrHdOffsetParamsData().subscribe(value -> {
            this.mOffsetParams = value;
            this.updateAverageValue();
            this.summaryText.setText((CharSequence)this.mSdrSignal.toString());
        }));
        this.addReaction(this.widgetModel.getDynamicDataRate().subscribe(value -> {
            this.mSdrSignal.dataRate = value.floatValue();
            this.summaryText.setText((CharSequence)this.mSdrSignal.toString());
        }));
        this.addReaction(this.widgetModel.getFrequencyPointIndex().subscribe(value -> {
            this.mCurNfIndex = value;
            this.mLeftNfIndex = (float)this.mCurNfIndex.intValue() - (float)this.mRangeSize;
            this.updateAverageValue();
            this.summaryText.setText((CharSequence)this.mSdrSignal.toString());
        }));
        this.addReaction(this.widgetModel.getDownLinkQuality().subscribe(value -> {
            this.sdrDownQuality = value;
            this.updateSdrSignalLevelLiveData();
        }));
        this.addReaction(this.widgetModel.getUpLinkQuality().subscribe(value -> {
            this.sdrUpQuality = value;
            this.updateSdrSignalLevelLiveData();
        }));
        this.addReaction(this.widgetModel.getLinkSignalQuality().subscribe(value -> {
            this.linkSignalQuality = value;
            this.updateSdrSignalLevelLiveData();
        }));
        this.addReaction(this.widgetModel.getFcConnection().subscribe(value -> {
            this.fcConnected = value;
            this.updateSdrSignalLevelLiveData();
        }));
    }

    public void onValidRangeChanged() {
        if (this.mSdrSignal.bandwidth == null || this.mValidRanges == null) {
            return;
        }
        float selectRange = 5.0f;
        if (this.mSdrSignal.bandwidth == Bandwidth.BANDWIDTH_20MHZ) {
            selectRange = 10.0f;
        } else if (this.mSdrSignal.bandwidth == Bandwidth.BANDWIDTH_40MHZ) {
            selectRange = 20.0f;
        }
        float left = this.mValidRanges[0].intValue();
        if (left != 2400.0f && left != 5470.0f) {
            left -= selectRange;
        }
        this.mNfStartIndex = left;
    }

    private void updateAverageValue() {
        if (this.mRssis == null || (float)this.mCurNfIndex.intValue() == Float.MAX_VALUE || this.mLeftNfIndex == Float.MAX_VALUE) {
            return;
        }
        int rssiStartIndex = (int)((this.mLeftNfIndex - this.mNfStartIndex) / 2.0f);
        if (rssiStartIndex < 0) {
            rssiStartIndex = 0;
        }
        float average = 0.0f;
        for (int i = rssiStartIndex; i < rssiStartIndex + this.mRangeSize && i < this.mRssis.size(); ++i) {
            average += (float)this.mRssis.get(i).getRssi().intValue();
        }
        average /= (float)this.mRangeSize;
        if (this.mOffsetParams != null) {
            average += (float)((this.mOffsetParams.getRcLinkOffset().byteValue() > 0 ? this.mOffsetParams.getRcLinkOffset().byteValue() : (byte)0) + this.mOffsetParams.getPathLossOffset().byteValue() + this.mOffsetParams.getTxPowerOffset().byteValue());
        }
        this.mSdrSignal.strength = average;
    }

    private void updateSdrSignalLevelLiveData() {
        int value = Integer.min(this.sdrDownQuality, this.sdrUpQuality);
        if (!this.fcConnected) {
            this.mSignalLevel = SignalLevel.LEVEL_0;
        } else if (this.linkSignalQuality > 0) {
            switch (this.linkSignalQuality) {
                case 4: 
                case 5: {
                    this.mSignalLevel = SignalLevel.LEVEL_3;
                    break;
                }
                case 3: {
                    this.mSignalLevel = SignalLevel.LEVEL_2;
                    break;
                }
                case 1: 
                case 2: {
                    this.mSignalLevel = SignalLevel.LEVEL_1;
                    break;
                }
            }
        } else {
            this.mSignalLevel = value > 60 ? SignalLevel.LEVEL_3 : (value <= 60 && value >= 40 ? SignalLevel.LEVEL_2 : SignalLevel.LEVEL_1);
        }
        this.setTextCellContent(this.mSignalLevel);
    }

    private void setTextCellContent(SignalLevel level) {
        switch (level.ordinal()) {
            case 1: {
                this.sdrInfoTextCell.setContent(this.getResources().getString(R.string.uxsdk_fpv_top_bar_gps_signal_state_weak));
                this.sdrInfoTextCell.setContentColor(AndUtil.getResColor((int)R.color.uxsdk_tips_danger_in_dark));
                break;
            }
            case 2: {
                this.sdrInfoTextCell.setContent(this.getResources().getString(R.string.uxsdk_fpv_top_bar_gps_signal_state_normal));
                this.sdrInfoTextCell.setContentColor(AndUtil.getResColor((int)R.color.uxsdk_tips_caution_in_dark));
                break;
            }
            case 3: {
                this.sdrInfoTextCell.setContent(this.getResources().getString(R.string.uxsdk_fpv_top_bar_gps_signal_state_strong));
                this.sdrInfoTextCell.setContentColor(AndUtil.getResColor((int)R.color.uxsdk_green));
                break;
            }
            default: {
                this.sdrInfoTextCell.setContent("N/A");
                this.sdrInfoTextCell.setContentColor(AndUtil.getResColor((int)R.color.uxsdk_tips_danger_in_dark));
            }
        }
    }

    private static enum SignalLevel {
        LEVEL_0,
        LEVEL_1,
        LEVEL_2,
        LEVEL_3;

    }
}

