/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.aperture;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraAperture;
import dji.sdk.keyvalue.value.camera.CameraExposureSettings;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;

public class CameraConfigApertureWidgetModel
extends WidgetModel
implements ICameraIndex {
    private DataProcessor<CameraExposureSettings> exposureSettingsProcessor;
    private DataProcessor<CameraAperture> apertureProcessor;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public CameraConfigApertureWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.exposureSettingsProcessor = DataProcessor.create(new CameraExposureSettings());
        this.apertureProcessor = DataProcessor.create(CameraAperture.UNKNOWN);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Flowable<CameraAperture> getAperture() {
        return this.apertureProcessor.toFlowable();
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureSettings, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.exposureSettingsProcessor, exposureSettings -> {
            if (exposureSettings.getAperture() != null) {
                this.apertureProcessor.onNext(exposureSettings.getAperture());
            }
        });
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
    }
}

