/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.fpvinteraction;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.GimbalKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraMeteringMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.common.DoublePoint2D;
import dji.sdk.keyvalue.value.common.IntPoint2D;
import dji.sdk.keyvalue.value.gimbal.CtrlInfo;
import dji.sdk.keyvalue.value.gimbal.GimbalSpeedRotation;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.GlobalPreferencesInterface;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.communication.UXKeys;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.SettingDefinitions;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class FPVInteractionWidgetModel
extends WidgetModel
implements ICameraIndex {
    private final DataProcessor<SettingDefinitions.ControlMode> controlModeProcessor;
    private final DataProcessor<CameraMeteringMode> meteringModeProcessor;
    private final DataProcessor<Boolean> aeLockedProcessor;
    private final DataProcessor<Boolean> isYawAdjustSupportedProcessor;
    private final GlobalPreferencesInterface preferencesManager;
    private final ObservableInMemoryKeyedStore keyedStore;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensIndex = CameraLensType.CAMERA_LENS_WIDE;
    private DJIKey<DoublePoint2D> focusTargetKey;
    private DJIKey<DoublePoint2D> meteringPointKey;
    private DJIKey<CameraMeteringMode> meteringModeKey;
    private UXKey controlModeKey;

    public FPVInteractionWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore, @Nullable GlobalPreferencesInterface preferencesManager) {
        super(djiSdkModel, keyedStore);
        this.meteringModeProcessor = DataProcessor.create(CameraMeteringMode.UNKNOWN);
        this.controlModeProcessor = DataProcessor.create(SettingDefinitions.ControlMode.SPOT_METER);
        if (preferencesManager != null) {
            this.controlModeProcessor.onNext(preferencesManager.getControlMode());
        }
        this.aeLockedProcessor = DataProcessor.create(false);
        this.isYawAdjustSupportedProcessor = DataProcessor.create(true);
        this.preferencesManager = preferencesManager;
        this.keyedStore = keyedStore;
    }

    @Override
    protected void inSetup() {
        this.focusTargetKey = KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraFocusTarget, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensIndex);
        this.meteringPointKey = KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeySpotMeteringPoint, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensIndex);
        this.meteringModeKey = KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraMeteringMode, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensIndex);
        this.bindDataProcessor(this.meteringModeKey, this.meteringModeProcessor, this::setMeteringMode);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyAELockEnabled, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensIndex), this.aeLockedProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyYawAdjustSupported, (ComponentIndexType)this.cameraIndex), this.isYawAdjustSupportedProcessor);
        this.controlModeKey = UXKeys.create("ControlMode");
        this.bindDataProcessor(this.controlModeKey, this.controlModeProcessor);
        if (this.preferencesManager != null) {
            this.preferencesManager.setUpListener();
        }
    }

    @Override
    protected void inCleanup() {
        if (this.preferencesManager != null) {
            this.preferencesManager.cleanup();
        }
    }

    @Override
    protected void updateStates() {
    }

    private void setMeteringMode(CameraMeteringMode meteringMode) {
        if (meteringMode == CameraMeteringMode.REGION) {
            this.setControlMode(SettingDefinitions.ControlMode.SPOT_METER);
        } else if (meteringMode == CameraMeteringMode.CENTER) {
            this.setControlMode(SettingDefinitions.ControlMode.CENTER_METER);
        }
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensIndex;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensIndex = lensType;
        this.restart();
    }

    @NonNull
    public Completable setControlMode(@NonNull SettingDefinitions.ControlMode controlMode) {
        if (this.preferencesManager != null) {
            this.preferencesManager.setControlMode(controlMode);
        }
        return this.keyedStore.setValue(this.controlModeKey, (Object)controlMode);
    }

    @NonNull
    public Flowable<SettingDefinitions.ControlMode> getControlMode() {
        return this.controlModeProcessor.toFlowable();
    }

    @NonNull
    public Flowable<Boolean> isAeLocked() {
        return this.aeLockedProcessor.toFlowable();
    }

    @NonNull
    public Completable updateFocusTarget(@FloatRange(from=0.0, to=1.0) float targetX, @FloatRange(from=0.0, to=1.0) float targetY) {
        return this.djiSdkModel.setValue(this.focusTargetKey, this.createPointF(targetX, targetY));
    }

    @NonNull
    public Completable updateMetering(@FloatRange(from=0.0, to=1.0) float targetX, @FloatRange(from=0.0, to=1.0) float targetY) {
        if (this.controlModeProcessor.getValue() == SettingDefinitions.ControlMode.SPOT_METER) {
            return this.djiSdkModel.setValue(this.meteringPointKey, new DoublePoint2D(Double.valueOf(targetX), Double.valueOf(targetY)));
        }
        if (this.controlModeProcessor.getValue() == SettingDefinitions.ControlMode.CENTER_METER) {
            return this.djiSdkModel.setValue(this.meteringModeKey, CameraMeteringMode.CENTER);
        }
        return Completable.complete();
    }

    public boolean canRotateGimbalYaw() {
        return this.isYawAdjustSupportedProcessor.getValue();
    }

    public Completable rotateGimbalBySpeed(double yaw, double pitch) {
        return this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)GimbalKey.KeyRotateBySpeed, (ComponentIndexType)this.cameraIndex), new GimbalSpeedRotation(Double.valueOf(pitch), Double.valueOf(yaw), Double.valueOf(0.0), new CtrlInfo()));
    }

    @VisibleForTesting
    @NonNull
    protected DoublePoint2D createPointF(float x, float y) {
        return new DoublePoint2D(Double.valueOf(x), Double.valueOf(y));
    }

    @VisibleForTesting
    @NonNull
    protected IntPoint2D createPoint(int x, int y) {
        return new IntPoint2D(Integer.valueOf(x), Integer.valueOf(y));
    }
}

