/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.ux.mapkit.core.Mapkit;
import dji.v5.ux.mapkit.core.MapkitOptions;
import dji.v5.ux.mapkit.core.maps.DJIMapViewInternal;
import dji.v5.ux.mapkit.core.places.IInternalPlacesClient;

public abstract class MapProvider {
    protected static final String TAG = MapProvider.class.getSimpleName();
    protected int providerType;
    protected MapProvider nextProvider;

    protected MapProvider() {
    }

    @Mapkit.MapProviderConstant
    public int getProviderType() {
        return this.providerType;
    }

    public MapProvider getNextProvider() {
        return this.nextProvider;
    }

    protected abstract DJIMapViewInternal requestMapView(@NonNull Context var1, @NonNull MapkitOptions var2);

    protected abstract IInternalPlacesClient requestGeocodingClient(Context var1, MapkitOptions var2);

    public DJIMapViewInternal dispatchMapViewRequest(@NonNull Context context, @Nullable MapkitOptions mapkitOptions) {
        DJIMapViewInternal mapView;
        if (mapkitOptions == null) {
            mapkitOptions = new MapkitOptions.Builder().build();
        }
        if ((mapView = this.requestMapView(context, mapkitOptions)) != null) {
            return mapView;
        }
        if (this.nextProvider != null) {
            mapView = this.nextProvider.dispatchMapViewRequest(context, mapkitOptions);
        }
        return mapView;
    }

    public IInternalPlacesClient dispatchGeocodingClientRequest(@NonNull Context context, MapkitOptions mapkitOptions) {
        IInternalPlacesClient client = this.requestGeocodingClient(context, mapkitOptions);
        if (client != null) {
            return client;
        }
        if (this.nextProvider != null) {
            client = this.nextProvider.dispatchGeocodingClientRequest(context, mapkitOptions);
        }
        return client;
    }

    public MapProvider next(MapProvider nextProvider) {
        this.nextProvider = nextProvider;
        return this;
    }
}

