/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.useraccount;

import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.account.LoginInfo;
import dji.v5.manager.account.LoginInfoUpdateListener;
import dji.v5.manager.interfaces.IUserAccountManager;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.UXSDKError;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class UserAccountLoginWidgetModel
extends WidgetModel {
    private DataProcessor<LoginInfo> loginInfoDataProcessor;
    private IUserAccountManager userAccountManager;
    private LoginInfoUpdateListener loginInfoUpdateListener = loginInfo -> this.loginInfoDataProcessor.onNext(loginInfo);

    public UserAccountLoginWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore, @NonNull IUserAccountManager userAccountManager) {
        super(djiSdkModel, keyedStore);
        this.userAccountManager = userAccountManager;
        this.loginInfoDataProcessor = DataProcessor.create(new LoginInfo());
    }

    @Override
    protected void inSetup() {
        if (this.userAccountManager != null) {
            this.userAccountManager.addLoginInfoUpdateListener(this.loginInfoUpdateListener);
        }
    }

    @Override
    protected void inCleanup() {
        this.userAccountManager.removeLoginInfoUpdateListener(this.loginInfoUpdateListener);
    }

    @Override
    protected void updateStates() {
    }

    public Flowable<LoginInfo> getUserAccountInformation() {
        return this.loginInfoDataProcessor.toFlowable();
    }

    public Completable loginUser(@NonNull FragmentActivity context) {
        return Completable.create(emitter -> this.userAccountManager.logInDJIUserAccount(context, false, new CommonCallbacks.CompletionCallback(){

            public void onSuccess() {
                emitter.onComplete();
            }

            public void onFailure(@NonNull IDJIError error) {
                if (!emitter.isDisposed()) {
                    UXSDKError uxsdkError = new UXSDKError(error);
                    emitter.onError((Throwable)uxsdkError);
                }
            }
        }));
    }

    public Completable logoutUser() {
        return Completable.create(emitter -> this.userAccountManager.logOutDJIUserAccount(new CommonCallbacks.CompletionCallback(){

            public void onSuccess() {
                emitter.onComplete();
            }

            public void onFailure(@NonNull IDJIError error) {
                emitter.onError((Throwable)new UXSDKError(error));
            }
        }));
    }
}

