/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.common;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.BatteryKey;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.GimbalKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.PayloadKey;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.key.RemoteControllerKey;
import dji.sdk.keyvalue.key.RtkMobileStationKey;
import dji.sdk.keyvalue.value.battery.BatteryOverviewValue;
import dji.sdk.keyvalue.value.battery.IndustryBatteryType;
import dji.sdk.keyvalue.value.camera.CameraType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.payload.PayloadCameraType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.List;

public class CommonAboutWidgetModel
extends WidgetModel {
    public final DataProcessor<String> rcSerialNumberProcessor = DataProcessor.create("");
    public final DataProcessor<Boolean> rtkConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<List<BatteryOverviewValue>> batteryOverviewProcessor = DataProcessor.create(new ArrayList());
    public final DataProcessor<Boolean> rcConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<Boolean> fcConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<Boolean> gimbal1ConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<Boolean> gimbal2ConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<Boolean> gimbal3ConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<Boolean> camera1ConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<Boolean> camera2ConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<Boolean> camera3ConnectionProcessor = DataProcessor.create(false);
    public final DataProcessor<String> camera1SerialNumberProcessor = DataProcessor.create("");
    public final DataProcessor<String> camera2SerialNumberProcessor = DataProcessor.create("");
    public final DataProcessor<String> camera3SerialNumberProcessor = DataProcessor.create("");

    protected CommonAboutWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyRcRK3399SirialNumber), this.rcSerialNumberProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyConnection), this.rcConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), this.fcConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)RtkMobileStationKey.KeyIsRTKDongleConnect), this.rtkConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyBatteryOverviews, (ComponentIndexType)ComponentIndexType.AGGREGATION), this.batteryOverviewProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyConnection, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.gimbal1ConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyConnection, (ComponentIndexType)ComponentIndexType.RIGHT), this.gimbal2ConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyConnection, (ComponentIndexType)ComponentIndexType.UP), this.gimbal3ConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyConnection, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.camera1ConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyConnection, (ComponentIndexType)ComponentIndexType.RIGHT), this.camera2ConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyConnection, (ComponentIndexType)ComponentIndexType.UP), this.camera3ConnectionProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySerialNumber, (ComponentIndexType)ComponentIndexType.LEFT_OR_MAIN), this.camera1SerialNumberProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySerialNumber, (ComponentIndexType)ComponentIndexType.RIGHT), this.camera2SerialNumberProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeySerialNumber, (ComponentIndexType)ComponentIndexType.UP), this.camera3SerialNumberProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    public Single<String> getRCVersion() {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)RemoteControllerKey.KeyFirmwareVersion)).observeOn(AndroidSchedulers.mainThread());
    }

    public Completable doForceUpdateCache() {
        return this.djiSdkModel.performActionWithOutResult(KeyTools.createKey((DJIActionKeyInfo)RemoteControllerKey.KeyForceUpdateCacheValue), "FirmwareVersion").observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getGimbalVersion(ComponentIndexType cameraIndex) {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyFirmwareVersion, (ComponentIndexType)cameraIndex)).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getCameraVersion(ComponentIndexType cameraIndex) {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyFirmwareVersion, (ComponentIndexType)cameraIndex)).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<CameraType> getCameraType(ComponentIndexType cameraIndex) {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraType, (ComponentIndexType)cameraIndex)).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getPayloadCameraVersion(ComponentIndexType cameraIndex) {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)PayloadKey.KeyFirmwareVersion, (ComponentIndexType)cameraIndex)).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getPayloadCameraName(ComponentIndexType cameraIndex) {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)PayloadKey.KeyPayloadCameraType, (ComponentIndexType)cameraIndex)).flatMap(type -> {
            if (type != PayloadCameraType.UNKNOWN) {
                return Single.just((Object)CameraUtil.getPayloadCameraName(type));
            }
            return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)PayloadKey.KeyPayloadProductName, (ComponentIndexType)cameraIndex));
        }).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getCameraName(ComponentIndexType cameraIndex) {
        return this.getCameraType(cameraIndex).flatMap(cameraType -> {
            if (cameraType != CameraType.PAYLOAD) {
                return Single.just((Object)CameraUtil.getCameraDisplayName(cameraType)).observeOn(AndroidSchedulers.mainThread());
            }
            return this.getPayloadCameraName(cameraIndex);
        });
    }

    public Single<String> getFCSerialNumber() {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeySerialNumber)).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getRTKSerialNumber() {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)RtkMobileStationKey.KeyRTKDongleSN)).observeOn(AndroidSchedulers.mainThread());
    }

    public Flowable<Boolean> getBatteryConnection(int index, Object listenerHolder) {
        return this.djiSdkModel.addListener(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyConnection, (int)index), listenerHolder).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getBatteryVersion(int index) {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyFirmwareVersion, (int)index)).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<IndustryBatteryType> getIndustryBatteryType(int index) {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)BatteryKey.KeyIndustryBatteryType, (int)index)).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getProductVersion() {
        return this.djiSdkModel.getValue(KeyTools.createKey((DJIKeyInfo)ProductKey.KeyFirmwareVersion)).observeOn(AndroidSchedulers.mainThread());
    }
}

