/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.focusexposureswitch;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.focusexposureswitch.FocusExposureSwitchWidgetModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.GlobalPreferencesManager;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.SettingDefinitions;
import dji.v5.ux.core.util.UxErrorHandle;

public class FocusExposureSwitchWidget
extends FrameLayoutWidget<Object>
implements View.OnClickListener,
ICameraIndex {
    private static final String TAG = "FocusExpoSwitchWidget";
    private ImageView focusExposureSwitchImageView;
    private FocusExposureSwitchWidgetModel widgetModel;
    private Drawable manualFocusDrawable;
    private Drawable autoFocusDrawable;
    private Drawable spotMeterDrawable;

    public FocusExposureSwitchWidget(@NonNull Context context) {
        super(context);
    }

    public FocusExposureSwitchWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FocusExposureSwitchWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        FocusExposureSwitchWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_focus_exposure_switch, (ViewGroup)this);
        this.focusExposureSwitchImageView = (ImageView)this.findViewById(R.id.focus_exposure_switch_image_view);
        if (this.getBackground() == null) {
            this.setBackgroundResource(R.drawable.uxsdk_background_black_rectangle);
        }
        if (!this.isInEditMode()) {
            this.widgetModel = new FocusExposureSwitchWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance(), GlobalPreferencesManager.getInstance());
        }
        this.initDefaults();
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
        this.setOnClickListener(this);
    }

    private void initDefaults() {
        this.manualFocusDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_focus_switch_manual);
        this.autoFocusDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_focus_switch_auto);
        this.spotMeterDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_metering_switch);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.isFocusModeChangeSupported().observeOn(SchedulerProvider.ui()).subscribe(this::updateVisibility));
        this.addReaction(this.widgetModel.getControlMode().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == this.getId()) {
            this.addDisposable(this.widgetModel.switchControlMode().observeOn(SchedulerProvider.ui()).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(TAG, "switchControlMode: ")));
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    private void updateVisibility(boolean isFocusModeChangeSupported) {
        if (isFocusModeChangeSupported) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
    }

    private void updateUI(SettingDefinitions.ControlMode controlMode) {
        if (controlMode == SettingDefinitions.ControlMode.SPOT_METER || controlMode == SettingDefinitions.ControlMode.CENTER_METER) {
            this.focusExposureSwitchImageView.setImageDrawable(this.spotMeterDrawable);
        } else if (controlMode == SettingDefinitions.ControlMode.MANUAL_FOCUS) {
            this.focusExposureSwitchImageView.setImageDrawable(this.manualFocusDrawable);
        } else {
            this.focusExposureSwitchImageView.setImageDrawable(this.autoFocusDrawable);
        }
    }

    private void checkAndUpdateUI() {
        if (!this.isInEditMode()) {
            this.addDisposable(this.widgetModel.getControlMode().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI, UxErrorHandle.logErrorConsumer(TAG, "Update UI ")));
        }
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FocusExposureSwitchWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.FocusExposureSwitchWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.FocusExposureSwitchWidget_uxsdk_lensType, 0)));
        }
        if (typedArray.getDrawable(R.styleable.FocusExposureSwitchWidget_uxsdk_meteringDrawable) != null) {
            this.spotMeterDrawable = typedArray.getDrawable(R.styleable.FocusExposureSwitchWidget_uxsdk_meteringDrawable);
        }
        if (typedArray.getDrawable(R.styleable.FocusExposureSwitchWidget_uxsdk_manualFocusDrawable) != null) {
            this.manualFocusDrawable = typedArray.getDrawable(R.styleable.FocusExposureSwitchWidget_uxsdk_manualFocusDrawable);
        }
        if (typedArray.getDrawable(R.styleable.FocusExposureSwitchWidget_uxsdk_autoFocusDrawable) != null) {
            this.autoFocusDrawable = typedArray.getDrawable(R.styleable.FocusExposureSwitchWidget_uxsdk_autoFocusDrawable);
        }
        this.setIconBackground(typedArray.getDrawable(R.styleable.FocusExposureSwitchWidget_uxsdk_iconBackground));
        typedArray.recycle();
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_default_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Nullable
    public Drawable getManualFocusIcon() {
        return this.manualFocusDrawable;
    }

    public void setManualFocusIcon(@DrawableRes int resourceId) {
        this.setManualFocusIcon(this.getResources().getDrawable(resourceId));
    }

    public void setManualFocusIcon(@Nullable Drawable drawable2) {
        this.manualFocusDrawable = drawable2;
        this.checkAndUpdateUI();
    }

    @Nullable
    public Drawable getAutoFocusIcon() {
        return this.autoFocusDrawable;
    }

    public void setAutoFocusIcon(@DrawableRes int resourceId) {
        this.setAutoFocusIcon(this.getResources().getDrawable(resourceId));
    }

    public void setAutoFocusIcon(@Nullable Drawable drawable2) {
        this.autoFocusDrawable = drawable2;
        this.checkAndUpdateUI();
    }

    @Nullable
    public Drawable getMeteringIcon() {
        return this.spotMeterDrawable;
    }

    public void setMeteringIcon(@DrawableRes int resourceId) {
        this.setMeteringIcon(this.getResources().getDrawable(resourceId));
    }

    public void setMeteringIcon(@Nullable Drawable drawable2) {
        this.spotMeterDrawable = drawable2;
        this.checkAndUpdateUI();
    }

    @Nullable
    public Drawable getIconBackground() {
        return this.focusExposureSwitchImageView.getBackground();
    }

    public void setIconBackground(@DrawableRes int resourceId) {
        this.focusExposureSwitchImageView.setBackgroundResource(resourceId);
    }

    public void setIconBackground(@Nullable Drawable drawable2) {
        this.focusExposureSwitchImageView.setBackground(drawable2);
    }
}

