/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.training.simulatorcontrol.preset;

import android.app.Dialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.DrawableRes;
import androidx.annotation.StyleRes;
import dji.v5.ux.R;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.training.simulatorcontrol.preset.SimulatorPresetData;
import dji.v5.ux.training.util.SimulatorPresetUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010(\u001a\u00020\u00122\b\b\u0001\u0010)\u001a\u00020\"J\u0010\u0010.\u001a\u00020\u00122\b\b\u0001\u00100\u001a\u00020\"J\u0010\u00103\u001a\u00020\u00122\b\b\u0001\u00100\u001a\u00020\"J\u0010\u0010:\u001a\u00020\u00122\b\b\u0001\u0010)\u001a\u00020\"R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010#\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R(\u0010+\u001a\u0004\u0018\u00010*2\b\u0010\u001b\u001a\u0004\u0018\u00010*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00101\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010-\"\u0004\b3\u0010/R(\u00104\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u001f\"\u0004\b6\u0010!R$\u00107\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010%\"\u0004\b9\u0010'\u00a8\u0006;"}, d2={"Ldji/v5/ux/training/simulatorcontrol/preset/SavePresetDialog;", "Landroid/app/Dialog;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "cancelable", "", "simulatorPresetData", "Ldji/v5/ux/training/simulatorcontrol/preset/SimulatorPresetData;", "<init>", "(Landroid/content/Context;ZLdji/v5/ux/training/simulatorcontrol/preset/SimulatorPresetData;)V", "titleTextView", "Landroid/widget/TextView;", "saveTextView", "cancelTextView", "presetEditText", "Landroid/widget/EditText;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onClick", "v", "Landroid/view/View;", "savePreset", "name", "", "value", "Landroid/content/res/ColorStateList;", "titleTextColors", "getTitleTextColors", "()Landroid/content/res/ColorStateList;", "setTitleTextColors", "(Landroid/content/res/ColorStateList;)V", "", "titleTextColor", "getTitleTextColor", "()I", "setTitleTextColor", "(I)V", "setTitleTextAppearance", "textAppearance", "Landroid/graphics/drawable/Drawable;", "titleBackground", "getTitleBackground", "()Landroid/graphics/drawable/Drawable;", "setTitleBackground", "(Landroid/graphics/drawable/Drawable;)V", "resourceId", "buttonBackground", "getButtonBackground", "setButtonBackground", "buttonTextColors", "getButtonTextColors", "setButtonTextColors", "buttonTextColor", "getButtonTextColor", "setButtonTextColor", "setButtonTextAppearance", "android-sdk-v5-uxsdk_debug"})
public final class SavePresetDialog
extends Dialog
implements View.OnClickListener {
    @NotNull
    private final SimulatorPresetData simulatorPresetData;
    @NotNull
    private final TextView titleTextView;
    @NotNull
    private final TextView saveTextView;
    @NotNull
    private final TextView cancelTextView;
    @NotNull
    private final EditText presetEditText;

    public SavePresetDialog(@NotNull Context context, boolean cancelable, @NotNull SimulatorPresetData simulatorPresetData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)simulatorPresetData, (String)"simulatorPresetData");
        super(context);
        this.setContentView(R.layout.uxsdk_dialog_simulator_save_preset);
        this.titleTextView = (TextView)this.findViewById(R.id.textview_save_preset_header);
        this.presetEditText = (EditText)this.findViewById(R.id.edit_text_preset_name);
        this.saveTextView = (TextView)this.findViewById(R.id.textview_save_preset);
        this.saveTextView.setOnClickListener((View.OnClickListener)this);
        this.cancelTextView = (TextView)this.findViewById(R.id.textview_cancel_simulator_dialog);
        this.cancelTextView.setOnClickListener((View.OnClickListener)this);
        this.setCancelable(cancelable);
        this.simulatorPresetData = simulatorPresetData;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        block1: {
            super.onCreate(savedInstanceState);
            Window window = this.getWindow();
            if (window != null) {
                window.setBackgroundDrawableResource(R.drawable.uxsdk_background_dialog_rounded_corners);
            }
            Window window2 = this.getWindow();
            if (window2 == null) break block1;
            window2.setLayout((int)this.getContext().getResources().getDimension(R.dimen.uxsdk_simulator_dialog_width), -2);
        }
    }

    public void onClick(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int id2 = v.getId();
        if (id2 == R.id.textview_save_preset) {
            this.savePreset(this.presetEditText.getText().toString());
        } else if (id2 == R.id.textview_cancel_simulator_dialog) {
            this.dismiss();
        }
    }

    private final void savePreset(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getResources().getString(R.string.uxsdk_simulator_preset_name_empty_error), (int)0).show();
        } else {
            SimulatorPresetUtils.INSTANCE.savePreset(name, this.simulatorPresetData);
            this.dismiss();
        }
    }

    @Nullable
    public final ColorStateList getTitleTextColors() {
        return ViewExtensions.getTextColorStateList(this.titleTextView);
    }

    public final void setTitleTextColors(@Nullable ColorStateList value) {
        ViewExtensions.setTextColorStateList(this.titleTextView, value);
    }

    public final int getTitleTextColor() {
        return ViewExtensions.getTextColor(this.titleTextView);
    }

    public final void setTitleTextColor(int value) {
        ViewExtensions.setTextColor(this.titleTextView, value);
    }

    public final void setTitleTextAppearance(@StyleRes int textAppearance) {
        this.titleTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    @Nullable
    public final Drawable getTitleBackground() {
        return this.titleTextView.getBackground();
    }

    public final void setTitleBackground(@Nullable Drawable value) {
        this.titleTextView.setBackground(value);
    }

    public final void setTitleBackground(@DrawableRes int resourceId) {
        this.setTitleBackground(this.getContext().getResources().getDrawable(resourceId));
    }

    @NotNull
    public final Drawable getButtonBackground() {
        Drawable drawable2 = this.saveTextView.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
        return drawable2;
    }

    public final void setButtonBackground(@NotNull Drawable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.saveTextView.setBackground(value);
        this.cancelTextView.setBackground(value);
    }

    public final void setButtonBackground(@DrawableRes int resourceId) {
        this.setButtonBackground(this.getContext().getResources().getDrawable(resourceId));
    }

    @Nullable
    public final ColorStateList getButtonTextColors() {
        return ViewExtensions.getTextColorStateList(this.saveTextView);
    }

    public final void setButtonTextColors(@Nullable ColorStateList value) {
        ViewExtensions.setTextColorStateList(this.saveTextView, value);
        ViewExtensions.setTextColorStateList(this.cancelTextView, value);
    }

    public final int getButtonTextColor() {
        return ViewExtensions.getTextColor(this.saveTextView);
    }

    public final void setButtonTextColor(int value) {
        ViewExtensions.setTextColor(this.saveTextView, value);
        ViewExtensions.setTextColor(this.cancelTextView, value);
    }

    public final void setButtonTextAppearance(@StyleRes int textAppearance) {
        this.saveTextView.setTextAppearance(this.getContext(), textAppearance);
        this.cancelTextView.setTextAppearance(this.getContext(), textAppearance);
    }
}

