/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.gmap.place;

import android.content.Context;
import android.os.Bundle;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.PlaceLikelihood;
import com.google.android.gms.location.places.Places;
import com.google.android.gms.maps.model.LatLng;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.places.DJIPlacesClient;
import dji.v5.ux.mapkit.core.places.DJIPoiItem;
import dji.v5.ux.mapkit.core.places.DJIPoiSearchQuery;
import dji.v5.ux.mapkit.core.places.IInternalPlacesClient;
import dji.v5.ux.mapkit.gmap.utils.GoogleUtils;
import java.util.ArrayList;

public class GMapPlaceDelegate
implements IInternalPlacesClient,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private GoogleApiClient googleApiClient;
    private DJIPlacesClient.OnPoiSearchListener onPoiSearchListener;
    private Context context;

    public GMapPlaceDelegate(Context context) {
        this.googleApiClient = new GoogleApiClient.Builder(context).addApi(Places.PLACE_DETECTION_API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.context = context;
    }

    @Override
    public void setOnPoiSearchListener(DJIPlacesClient.OnPoiSearchListener onPoiSearchListener) {
        this.onPoiSearchListener = onPoiSearchListener;
    }

    @Override
    public void setPoiSearchQuery(DJIPoiSearchQuery poiSearchQuery) {
    }

    @Override
    public void setOnRegeocodeSearchListener(DJIPlacesClient.OnRegeocodeSearchListener onRegeocodeSearchListener) {
    }

    @Override
    public void regeocodeSearchAsyn(DJILatLng latLng) {
    }

    @Override
    public void searchPOIAsyn(DJILatLng latLng) {
        this.searchPOIAsyn(latLng, 300);
    }

    @Override
    public void searchPOIAsyn(DJILatLng latLng, int radius) {
        this.googleApiClient.connect();
    }

    public void onConnected(Bundle bundle) {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        PendingResult result = Places.PlaceDetectionApi.getCurrentPlace(this.googleApiClient, null);
        result.setResultCallback(placeLikelihoods -> {
            ArrayList<DJIPoiItem> poiList = new ArrayList<DJIPoiItem>(placeLikelihoods.getCount());
            for (PlaceLikelihood placeLikelihood : placeLikelihoods) {
                Place place = placeLikelihood.getPlace();
                LatLng latLng = place.getLatLng();
                DJILatLng ll = GoogleUtils.fromLatLng(latLng);
                DJIPoiItem item = new DJIPoiItem(place.getName().toString(), place.getAddress().toString(), ll);
                poiList.add(item);
            }
            if (this.onPoiSearchListener != null) {
                this.onPoiSearchListener.onPoiSearched(poiList);
            }
            this.googleApiClient.disconnect();
        });
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
    }
}

