/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import dji.v5.ux.R;
import dji.v5.ux.core.communication.GlobalPreferencesManager;
import dji.v5.ux.core.extension.ViewExtensions;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u00020\u00072\b\b\u0001\u0010\u000e\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u0013\u00a8\u0006,"}, d2={"Ldji/v5/ux/core/ui/GridLineView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "paint", "Landroid/graphics/Paint;", "gridWidth", "gridHeight", "color", "lineColor", "getLineColor", "()I", "setLineColor", "(I)V", "type", "Ldji/v5/ux/core/ui/GridLineView$GridLineType;", "getType", "()Ldji/v5/ux/core/ui/GridLineView$GridLineType;", "setType", "(Ldji/v5/ux/core/ui/GridLineView$GridLineType;)V", "lineWidth", "", "getLineWidth", "()F", "setLineWidth", "(F)V", "numLines", "numberOfLines", "getNumberOfLines", "setNumberOfLines", "adjustDimensions", "", "width", "height", "onDraw", "canvas", "Landroid/graphics/Canvas;", "GridLineType", "android-sdk-v5-uxsdk_release"})
public final class GridLineView
extends View {
    @NotNull
    private final Paint paint;
    private int gridWidth;
    private int gridHeight;
    private int lineColor;
    private float lineWidth;
    private int numberOfLines;

    @JvmOverloads
    public GridLineView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.paint = new Paint();
        this.lineColor = ViewExtensions.getColor(this, R.color.uxsdk_white_80_percent);
        this.lineWidth = 1.0f;
        this.numberOfLines = 4;
        if (!this.isInEditMode()) {
            this.setWillNotDraw(false);
            this.paint.setAntiAlias(true);
            this.paint.setColor(this.lineColor);
            this.paint.setStrokeWidth(this.lineWidth);
        }
    }

    public /* synthetic */ GridLineView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @ColorInt
    public final int getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(@ColorInt int color2) {
        this.lineColor = color2;
        if (!this.isInEditMode()) {
            this.paint.setColor(this.lineColor);
        }
        this.invalidate();
    }

    @NotNull
    public final GridLineType getType() {
        return GlobalPreferencesManager.getInstance() != null ? GlobalPreferencesManager.getInstance().getGridLineType() : GridLineType.NONE;
    }

    public final void setType(@NotNull GridLineType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.getType() != type && GlobalPreferencesManager.getInstance() != null) {
            GlobalPreferencesManager.getInstance().setGridLineType(type);
            this.invalidate();
        }
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    public final void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        if (!this.isInEditMode()) {
            this.paint.setStrokeWidth(lineWidth);
        }
        this.invalidate();
    }

    public final int getNumberOfLines() {
        return this.numberOfLines;
    }

    public final void setNumberOfLines(int numLines) {
        this.numberOfLines = numLines;
        this.invalidate();
    }

    public final void adjustDimensions(int width, int height) {
        if (width > 0 && height > 0) {
            this.gridWidth = width;
            this.gridHeight = height;
        } else {
            this.gridWidth = 0;
            this.gridHeight = 0;
        }
        this.invalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        int heightOffset;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.gridHeight == 0 || this.gridWidth == 0) {
            return;
        }
        float measureWidth = this.getMeasuredWidth();
        float measureHeight = this.getMeasuredHeight();
        measureHeight -= 1.0f;
        int widthOffset = (int)(((measureWidth -= 1.0f) - (float)this.gridWidth) / (float)2);
        if (widthOffset < 0) {
            widthOffset = 0;
        }
        if ((heightOffset = (int)((measureHeight - (float)this.gridHeight) / (float)2)) < 0) {
            heightOffset = 0;
        }
        if (this.getType() != GridLineType.NONE) {
            float horizontalOffset = (measureHeight - (float)heightOffset - (float)heightOffset) / (float)(this.numberOfLines - 1);
            for (float y = (float)heightOffset; y <= measureHeight - (float)heightOffset; y += horizontalOffset) {
                canvas.drawLine((float)widthOffset, y, measureWidth - (float)widthOffset, y, this.paint);
            }
            float verticalOffset = (measureWidth - (float)widthOffset - (float)widthOffset) / (float)(this.numberOfLines - 1);
            for (float x = (float)widthOffset; x <= measureWidth - (float)widthOffset; x += verticalOffset) {
                canvas.drawLine(x, (float)heightOffset, x, measureHeight - (float)heightOffset, this.paint);
            }
            if (this.getType() == GridLineType.PARALLEL_DIAGONAL) {
                canvas.drawLine((float)widthOffset, (float)heightOffset, measureWidth - (float)widthOffset, measureHeight - (float)heightOffset, this.paint);
                canvas.drawLine((float)widthOffset, measureHeight - (float)heightOffset, measureWidth - (float)widthOffset, (float)heightOffset, this.paint);
            }
        }
    }

    @JvmOverloads
    public GridLineView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GridLineView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Ldji/v5/ux/core/ui/GridLineView$GridLineType;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "()I", "NONE", "PARALLEL", "PARALLEL_DIAGONAL", "UNKNOWN", "Companion", "android-sdk-v5-uxsdk_release"})
    public static final class GridLineType
    extends Enum<GridLineType> {
        @NotNull
        public static final Companion Companion;
        private final int value;
        @NotNull
        private static final GridLineType[] values;
        public static final /* enum */ GridLineType NONE;
        public static final /* enum */ GridLineType PARALLEL;
        public static final /* enum */ GridLineType PARALLEL_DIAGONAL;
        public static final /* enum */ GridLineType UNKNOWN;
        private static final /* synthetic */ GridLineType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private GridLineType(int value) {
            this.value = value;
        }

        @JvmName(name="value")
        public final int value() {
            return this.value;
        }

        public static GridLineType[] values() {
            return (GridLineType[])$VALUES.clone();
        }

        public static GridLineType valueOf(String value) {
            return Enum.valueOf(GridLineType.class, value);
        }

        @NotNull
        public static EnumEntries<GridLineType> getEntries() {
            return $ENTRIES;
        }

        @NotNull
        public static final GridLineType[] getValues() {
            return Companion.getValues();
        }

        @JvmStatic
        @NotNull
        public static final GridLineType find(int value) {
            return Companion.find(value);
        }

        static {
            NONE = new GridLineType(0);
            PARALLEL = new GridLineType(1);
            PARALLEL_DIAGONAL = new GridLineType(2);
            UNKNOWN = new GridLineType(3);
            $VALUES = gridLineTypeArray = new GridLineType[]{GridLineType.NONE, GridLineType.PARALLEL, GridLineType.PARALLEL_DIAGONAL, GridLineType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            values = GridLineType.values();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007R$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\n\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ldji/v5/ux/core/ui/GridLineView$GridLineType$Companion;", "", "<init>", "()V", "values", "", "Ldji/v5/ux/core/ui/GridLineView$GridLineType;", "getValues$annotations", "getValues", "()[Ldji/v5/ux/core/ui/GridLineView$GridLineType;", "[Ldji/v5/ux/core/ui/GridLineView$GridLineType;", "find", "value", "", "android-sdk-v5-uxsdk_release"})
        @SourceDebugExtension(value={"SMAP\nGridLineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridLineView.kt\ndji/v5/ux/core/ui/GridLineView$GridLineType$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final GridLineType[] getValues() {
                return values;
            }

            @JvmStatic
            public static /* synthetic */ void getValues$annotations() {
            }

            @JvmStatic
            @NotNull
            public final GridLineType find(int value) {
                GridLineType gridLineType;
                GridLineType gridLineType2;
                block2: {
                    GridLineType[] gridLineTypeArray = this.getValues();
                    int n = gridLineTypeArray.length;
                    for (int i = 0; i < n; ++i) {
                        GridLineType gridLineType3;
                        GridLineType it = gridLineType3 = gridLineTypeArray[i];
                        boolean bl = false;
                        if (!(it.value() == value)) continue;
                        gridLineType2 = gridLineType3;
                        break block2;
                    }
                    gridLineType2 = gridLineType = null;
                }
                if (gridLineType2 == null) {
                    gridLineType = UNKNOWN;
                }
                return gridLineType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

